/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.local;

import com.browserstack.local.LocalException;
import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;

class LocalBinary {
    private static final String BIN_URL = "https://s3.amazonaws.com/browserStack/browserstack-local/";
    private String httpPath;
    private String binaryPath;
    private boolean isOSWindows;
    private final String[] orderedPaths = new String[]{System.getProperty("user.home") + "/.browserstack", System.getProperty("user.dir"), System.getProperty("java.io.tmpdir")};

    LocalBinary() throws LocalException {
        this.initialize();
        this.getBinary();
    }

    private void initialize() throws LocalException {
        String binFileName;
        String osname = System.getProperty("os.name").toLowerCase();
        this.isOSWindows = osname.contains("windows");
        if (this.isOSWindows) {
            binFileName = "BrowserStackLocal.exe";
        } else if (osname.contains("mac") || osname.contains("darwin")) {
            binFileName = "BrowserStackLocal-darwin-x64";
        } else if (osname.contains("linux")) {
            String arch = System.getProperty("os.arch");
            binFileName = "BrowserStackLocal-linux-" + (arch.contains("64") ? "x64" : "ia32");
        } else {
            throw new LocalException("Failed to detect OS type");
        }
        this.httpPath = BIN_URL + binFileName;
    }

    private void getBinary() throws LocalException {
        String destParentDir = this.getAvailableDirectory();
        this.binaryPath = destParentDir + "/BrowserStackLocal";
        if (this.isOSWindows) {
            this.binaryPath = this.binaryPath + ".exe";
        }
        if (!new File(this.binaryPath).exists()) {
            this.downloadBinary(destParentDir);
        }
    }

    private String getAvailableDirectory() throws LocalException {
        for (int i = 0; i < this.orderedPaths.length; ++i) {
            String path = this.orderedPaths[i];
            if (!this.makePath(path)) continue;
            return path;
        }
        throw new LocalException("Error trying to download BrowserStackLocal binary");
    }

    private boolean makePath(String path) {
        try {
            if (!new File(path).exists()) {
                new File(path).mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void downloadBinary(String destParentDir) throws LocalException {
        try {
            if (!new File(destParentDir).exists()) {
                new File(destParentDir).mkdirs();
            }
            URL url = new URL(this.httpPath);
            String source = destParentDir + "/BrowserStackLocal";
            if (this.isOSWindows) {
                source = source + ".exe";
            }
            File f = new File(source);
            FileUtils.copyURLToFile((URL)url, (File)f);
            this.changePermissions(this.binaryPath);
        }
        catch (Exception e) {
            throw new LocalException("Error trying to download BrowserStackLocal binary");
        }
    }

    private void changePermissions(String path) {
        File f = new File(path);
        f.setExecutable(true, true);
        f.setReadable(true, true);
        f.setWritable(true, true);
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }
}

