/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.byteplus.error.SdkError;
import com.byteplus.helper.Utils;
import com.byteplus.helper.VodUploadProgressEventType;
import com.byteplus.helper.VodUploadProgressListener;
import com.byteplus.helper.VodUploadProgressListenerHelper;
import com.byteplus.model.ApiInfo;
import com.byteplus.model.Credentials;
import com.byteplus.model.ServiceInfo;
import com.byteplus.model.beans.UploadCompleteInfo;
import com.byteplus.model.response.RawResponse;
import com.byteplus.model.sts2.Policy;
import com.byteplus.model.sts2.SecurityToken2;
import com.byteplus.model.sts2.Statement;
import com.byteplus.service.BaseServiceImpl;
import com.byteplus.service.vod.IVodService;
import com.byteplus.service.vod.VodServiceConfig;
import com.byteplus.service.vod.model.business.VodHeaderPair;
import com.byteplus.service.vod.model.business.VodUploadAddress;
import com.byteplus.service.vod.model.request.AddOrUpdateCertificateV2Request;
import com.byteplus.service.vod.model.request.DescribeVodEnhanceImageDataRequest;
import com.byteplus.service.vod.model.request.DescribeVodMostPlayedStatisDataRequest;
import com.byteplus.service.vod.model.request.DescribeVodPlayedStatisDataRequest;
import com.byteplus.service.vod.model.request.DescribeVodRealtimeMediaDataRequest;
import com.byteplus.service.vod.model.request.DescribeVodSnapshotDataRequest;
import com.byteplus.service.vod.model.request.DescribeVodSpaceSubtitleStatisDataRequest;
import com.byteplus.service.vod.model.request.DescribeVodSpaceTranscodeDataRequest;
import com.byteplus.service.vod.model.request.VodAddCallbackSubscriptionRequest;
import com.byteplus.service.vod.model.request.VodAddDomainToSchedulerRequest;
import com.byteplus.service.vod.model.request.VodApplyUploadInfoRequest;
import com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest;
import com.byteplus.service.vod.model.request.VodCreateCdnPreloadTaskRequest;
import com.byteplus.service.vod.model.request.VodCreateCdnRefreshTaskRequest;
import com.byteplus.service.vod.model.request.VodCreateDomainV2Request;
import com.byteplus.service.vod.model.request.VodCreateHlsDecryptionKeyRequest;
import com.byteplus.service.vod.model.request.VodCreatePlaylistRequest;
import com.byteplus.service.vod.model.request.VodCreateSpaceRequest;
import com.byteplus.service.vod.model.request.VodCreateVideoClassificationRequest;
import com.byteplus.service.vod.model.request.VodDeleteMediaRequest;
import com.byteplus.service.vod.model.request.VodDeletePlaylistRequest;
import com.byteplus.service.vod.model.request.VodDeleteTranscodesRequest;
import com.byteplus.service.vod.model.request.VodDeleteVideoClassificationRequest;
import com.byteplus.service.vod.model.request.VodDescribeIPInfoRequest;
import com.byteplus.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest;
import com.byteplus.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest;
import com.byteplus.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest;
import com.byteplus.service.vod.model.request.VodGetContentBlockTasksRequest;
import com.byteplus.service.vod.model.request.VodGetDirectEditProgressRequest;
import com.byteplus.service.vod.model.request.VodGetDirectEditResultRequest;
import com.byteplus.service.vod.model.request.VodGetDrmLicenseRequest;
import com.byteplus.service.vod.model.request.VodGetHlsDecryptionKeyRequest;
import com.byteplus.service.vod.model.request.VodGetMediaInfosRequest;
import com.byteplus.service.vod.model.request.VodGetMediaListRequest;
import com.byteplus.service.vod.model.request.VodGetPlayInfoRequest;
import com.byteplus.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest;
import com.byteplus.service.vod.model.request.VodGetPlaylistsRequest;
import com.byteplus.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest;
import com.byteplus.service.vod.model.request.VodGetRecommendedPosterRequest;
import com.byteplus.service.vod.model.request.VodGetSpaceDetailRequest;
import com.byteplus.service.vod.model.request.VodGetSubtitleInfoListRequest;
import com.byteplus.service.vod.model.request.VodGetWorkflowExecutionStatusRequest;
import com.byteplus.service.vod.model.request.VodListCdnAccessLogRequest;
import com.byteplus.service.vod.model.request.VodListCdnPvDataRequest;
import com.byteplus.service.vod.model.request.VodListCdnStatusDataDetailRequest;
import com.byteplus.service.vod.model.request.VodListCdnStatusDataRequest;
import com.byteplus.service.vod.model.request.VodListCdnTasksRequest;
import com.byteplus.service.vod.model.request.VodListCdnTopAccessUrlRequest;
import com.byteplus.service.vod.model.request.VodListCdnUsageDataDetailRequest;
import com.byteplus.service.vod.model.request.VodListCdnUsageDataRequest;
import com.byteplus.service.vod.model.request.VodListDomainRequest;
import com.byteplus.service.vod.model.request.VodListSnapshotsRequest;
import com.byteplus.service.vod.model.request.VodListSpaceRequest;
import com.byteplus.service.vod.model.request.VodListVideoClassificationsRequest;
import com.byteplus.service.vod.model.request.VodQueryUploadTaskInfoRequest;
import com.byteplus.service.vod.model.request.VodRemoveDomainFromSchedulerRequest;
import com.byteplus.service.vod.model.request.VodRetrieveTranscodeResultRequest;
import com.byteplus.service.vod.model.request.VodSetCallbackEventRequest;
import com.byteplus.service.vod.model.request.VodStartDomainRequest;
import com.byteplus.service.vod.model.request.VodStartWorkflowRequest;
import com.byteplus.service.vod.model.request.VodStopDomainRequest;
import com.byteplus.service.vod.model.request.VodSubmitBlockTasksRequest;
import com.byteplus.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest;
import com.byteplus.service.vod.model.request.VodUpdateDomainExpireV2Request;
import com.byteplus.service.vod.model.request.VodUpdateDomainPlayRuleRequestRequest;
import com.byteplus.service.vod.model.request.VodUpdateMediaInfoRequest;
import com.byteplus.service.vod.model.request.VodUpdateMediaPublishStatusRequest;
import com.byteplus.service.vod.model.request.VodUpdateMediaStorageClassRequest;
import com.byteplus.service.vod.model.request.VodUpdatePlaylistRequest;
import com.byteplus.service.vod.model.request.VodUpdateSpaceUploadConfigRequest;
import com.byteplus.service.vod.model.request.VodUpdateSubtitleInfoRequest;
import com.byteplus.service.vod.model.request.VodUpdateSubtitleStatusRequest;
import com.byteplus.service.vod.model.request.VodUpdateVideoClassificationRequest;
import com.byteplus.service.vod.model.request.VodUploadMaterialRequest;
import com.byteplus.service.vod.model.request.VodUploadMediaRequest;
import com.byteplus.service.vod.model.request.VodUrlUploadRequest;
import com.byteplus.service.vod.model.response.AddOrUpdateCertificateV2Response;
import com.byteplus.service.vod.model.response.DescribeVodEnhanceImageDataResponse;
import com.byteplus.service.vod.model.response.DescribeVodMostPlayedStatisDataResponse;
import com.byteplus.service.vod.model.response.DescribeVodPlayedStatisDataResponse;
import com.byteplus.service.vod.model.response.DescribeVodRealtimeMediaDataResponse;
import com.byteplus.service.vod.model.response.DescribeVodSnapshotDataResponse;
import com.byteplus.service.vod.model.response.DescribeVodSpaceSubtitleStatisDataResponse;
import com.byteplus.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse;
import com.byteplus.service.vod.model.response.VodAddCallbackSubscriptionResponse;
import com.byteplus.service.vod.model.response.VodAddDomainToSchedulerResponse;
import com.byteplus.service.vod.model.response.VodApplyUploadInfoResponse;
import com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse;
import com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse;
import com.byteplus.service.vod.model.response.VodCreateCdnPreloadTaskResponse;
import com.byteplus.service.vod.model.response.VodCreateCdnRefreshTaskResponse;
import com.byteplus.service.vod.model.response.VodCreateDomainV2Response;
import com.byteplus.service.vod.model.response.VodCreateHlsDecryptionKeyResponse;
import com.byteplus.service.vod.model.response.VodCreatePlaylistResponse;
import com.byteplus.service.vod.model.response.VodCreateSpaceResponse;
import com.byteplus.service.vod.model.response.VodCreateVideoClassificationResponse;
import com.byteplus.service.vod.model.response.VodDeleteMediaResponse;
import com.byteplus.service.vod.model.response.VodDeletePlaylistResponse;
import com.byteplus.service.vod.model.response.VodDeleteTranscodesResponse;
import com.byteplus.service.vod.model.response.VodDeleteVideoClassificationResponse;
import com.byteplus.service.vod.model.response.VodDescribeIPInfoResponse;
import com.byteplus.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse;
import com.byteplus.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse;
import com.byteplus.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse;
import com.byteplus.service.vod.model.response.VodGetContentBlockTasksResponse;
import com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse;
import com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse;
import com.byteplus.service.vod.model.response.VodGetHlsDecryptionKeyResponse;
import com.byteplus.service.vod.model.response.VodGetMediaInfosResponse;
import com.byteplus.service.vod.model.response.VodGetMediaListResponse;
import com.byteplus.service.vod.model.response.VodGetPlayInfoResponse;
import com.byteplus.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse;
import com.byteplus.service.vod.model.response.VodGetPlaylistsResponse;
import com.byteplus.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse;
import com.byteplus.service.vod.model.response.VodGetRecommendedPosterResponse;
import com.byteplus.service.vod.model.response.VodGetSpaceDetailResponse;
import com.byteplus.service.vod.model.response.VodGetSubtitleInfoListResponse;
import com.byteplus.service.vod.model.response.VodGetWorkflowExecutionStatusResponse;
import com.byteplus.service.vod.model.response.VodListCdnAccessLogResponse;
import com.byteplus.service.vod.model.response.VodListCdnStatusDataDetailResponse;
import com.byteplus.service.vod.model.response.VodListCdnTasksResponse;
import com.byteplus.service.vod.model.response.VodListCdnTopAccessUrlResponse;
import com.byteplus.service.vod.model.response.VodListCdnUsageDataDetailResponse;
import com.byteplus.service.vod.model.response.VodListDomainResponse;
import com.byteplus.service.vod.model.response.VodListSnapshotsResponse;
import com.byteplus.service.vod.model.response.VodListSpaceResponse;
import com.byteplus.service.vod.model.response.VodListVideoClassificationsResponse;
import com.byteplus.service.vod.model.response.VodQueryUploadTaskInfoResponse;
import com.byteplus.service.vod.model.response.VodRemoveDomainFromSchedulerResponse;
import com.byteplus.service.vod.model.response.VodRetrieveTranscodeResultResponse;
import com.byteplus.service.vod.model.response.VodSetCallbackEventResponse;
import com.byteplus.service.vod.model.response.VodStartDomainResponse;
import com.byteplus.service.vod.model.response.VodStartWorkflowResponse;
import com.byteplus.service.vod.model.response.VodStopDomainResponse;
import com.byteplus.service.vod.model.response.VodSubmitBlockTasksResponse;
import com.byteplus.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse;
import com.byteplus.service.vod.model.response.VodUpdateDomainExpireV2Response;
import com.byteplus.service.vod.model.response.VodUpdateDomainPlayRuleResponse;
import com.byteplus.service.vod.model.response.VodUpdateMediaInfoResponse;
import com.byteplus.service.vod.model.response.VodUpdateMediaPublishStatusResponse;
import com.byteplus.service.vod.model.response.VodUpdateMediaStorageClassResponse;
import com.byteplus.service.vod.model.response.VodUpdatePlaylistResponse;
import com.byteplus.service.vod.model.response.VodUpdateSpaceUploadConfigResponse;
import com.byteplus.service.vod.model.response.VodUpdateSubtitleInfoResponse;
import com.byteplus.service.vod.model.response.VodUpdateSubtitleStatusResponse;
import com.byteplus.service.vod.model.response.VodUpdateVideoClassificationResponse;
import com.byteplus.service.vod.model.response.VodUrlUploadResponse;
import com.byteplus.util.Sts2Utils;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class VodServiceImpl
extends BaseServiceImpl
implements IVodService {
    private static final VodServiceImpl AP_SINGAPORE_1_SERVICE = new VodServiceImpl("ap-singapore-1");
    private static final VodServiceImpl AP_SOUTHEAST_1_SERVICE = new VodServiceImpl("ap-southeast-1");

    public static IVodService getInstance() {
        return AP_SINGAPORE_1_SERVICE;
    }

    protected VodServiceImpl(String region) {
        super(VodServiceImpl.getRegionServiceInfo(region), VodServiceImpl.getRegionApiInfoList(region));
    }

    private static ServiceInfo getRegionServiceInfo(String region) {
        if (VodServiceConfig.ServiceInfoMap.containsKey(region)) {
            return VodServiceConfig.ServiceInfoMap.get(region);
        }
        return new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("ConnectionTimeout", 5000);
                this.put("SocketTimeout", 5000);
                this.put("Scheme", "https");
                this.put("Host", "vod.byteplusapi.com");
                this.put("Header", new ArrayList<Header>(){
                    {
                        this.add(new BasicHeader("Accept", "application/json"));
                    }
                });
                this.put("Credentials", new Credentials("ap-singapore-1", "vod"));
            }
        });
    }

    private static Map<String, ApiInfo> getRegionApiInfoList(String region) {
        if (region.equals("ap-southeast-1")) {
            return VodServiceConfig.apiInfoListApSoutheast1;
        }
        return VodServiceConfig.apiInfoList;
    }

    public static IVodService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = VodServiceConfig.ServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Cant find the region, please check it carefully");
        }
        switch (region) {
            case "ap-singapore-1": {
                return AP_SINGAPORE_1_SERVICE;
            }
            case "ap-southeast-1": {
                return AP_SOUTHEAST_1_SERVICE;
            }
        }
        throw new Exception("Cant find the region, please check it carefully");
    }

    @Override
    public String getPrivateDrmAuthToken(VodGetPrivateDrmPlayAuthRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        return this.getSignUrl("GetPrivateDrmPlayAuth", Utils.mapToPairList(params));
    }

    @Override
    public String createSha1HlsDrmAuthToken(Long expireSeconds) throws Exception {
        return this.createHlsDrmAuthToken("HMAC-SHA1", expireSeconds);
    }

    public String createHlsDrmAuthToken(String dsa, Long expireSeconds) throws Exception {
        if (expireSeconds == null || expireSeconds <= 0L) {
            throw new Exception("Invalid Expire");
        }
        String token = this.createAuth(dsa, expireSeconds);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DrmAuthToken", token);
        params.put("X-Expires", expireSeconds.toString());
        return this.getSignUrl("GetHlsDecryptionKey", Utils.mapToPairList(params));
    }

    private String createAuth(String dsa, long expireSeconds) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getAccessKey())) {
            throw new Exception("Invalid Ak");
        }
        if (StringUtils.isBlank((CharSequence)this.getSecretKey())) {
            throw new Exception("Invalid Sk");
        }
        long deadline = System.currentTimeMillis() / 1000L + expireSeconds;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        String deadlineDate = df.format(new Date(deadline * 1000L));
        String timestamp = String.valueOf(deadline);
        byte[] kDate = Utils.hmacSHA256(this.getSecretKey().getBytes(), deadlineDate);
        byte[] kRegion = Utils.hmacSHA256(kDate, this.getRegion());
        byte[] kService = Utils.hmacSHA256(kRegion, "vod");
        byte[] kCredentials = Utils.hmacSHA256(kService, "request");
        String key = Hex.encodeHexString((byte[])kCredentials);
        String signDataString = StringUtils.join((Object[])new String[]{dsa, "&", "2.0", "&", timestamp});
        String sign = "";
        switch (dsa) {
            case "HMAC-SHA1": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA1(key.getBytes(), signDataString));
                break;
            }
            case "HMAC-SHA256": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA256(key.getBytes(), signDataString));
                break;
            }
            default: {
                sign = Base64.encodeBase64String((byte[])"".getBytes());
            }
        }
        return StringUtils.join((Object[])new String[]{dsa, ":", "2.0", ":", timestamp, ":", this.getAccessKey(), ":", sign});
    }

    @Override
    public String getSubtitleAuthToken(VodGetSubtitleInfoListRequest input, Long expireSeconds) throws Exception {
        if (input.getVid() == "") {
            throw new Exception("\u4f20\u5165\u7684Vid\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Vid", input.getVid());
        params.put("Status", "Published");
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getSubtitleAuthToken = this.getSignUrl("GetSubtitleInfoList", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetSubtitleAuthToken", getSubtitleAuthToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getPlayAuthToken(VodGetPlayInfoRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getPlayInfoToken = this.getSignUrl("GetPlayInfo", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getThirdPartyDrmAuthToken(VodGetDrmLicenseRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getDrmLicenseToken = this.getSignUrl("GetDrmLicense", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetThirdPartyDrmAuthToken", getDrmLicenseToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getFairPlayCertUrl(String certId, Long expireSeconds) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CertId", certId);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        return this.getWholeSignUrl("GetFairPlayCert", Utils.mapToPairList(params));
    }

    @Override
    public SecurityToken2 getUploadSts2() throws Exception {
        return this.getUploadSts2WithExpire(3600000L);
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(long expire) throws Exception {
        Policy inlinePolicy = new Policy();
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("vod:ApplyUploadInfo");
        actions.add("vod:CommitUploadInfo");
        ArrayList<String> resources = new ArrayList<String>();
        Statement statement = Sts2Utils.newAllowStatement(actions, resources);
        inlinePolicy.addStatement(statement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public VodCommitUploadInfoResponse uploadMedia(VodUploadMediaRequest vodUploadMediaRequest, VodUploadProgressListener listener) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "media", vodUploadMediaRequest.getFileName(), vodUploadMediaRequest.getFileExtension(), vodUploadMediaRequest.getStorageClass(), listener);
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMediaRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMediaRequest.getFunctions()).setCallbackArgs(vodUploadMediaRequest.getCallbackArgs()).build();
        VodCommitUploadInfoResponse vodCommitUploadInfoResponse = this.commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1L);
        }
        return vodCommitUploadInfoResponse;
    }

    private UploadCompleteInfo uploadToB(String spaceName, String filePath, String fileType, String fileName, String fileExtension, int storageClass, VodUploadProgressListener listener) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.FILE_SIZE_EVENT, file.length());
        VodApplyUploadInfoRequest vodApplyUploadInfoRequest = VodApplyUploadInfoRequest.newBuilder().setSpaceName(spaceName).setFileName(fileName).setFileType(fileType).setFileExtension(fileExtension).setStorageClass(storageClass).build();
        VodApplyUploadInfoResponse vodApplyUploadInfoResponse = this.applyUploadInfo(vodApplyUploadInfoRequest);
        if (vodApplyUploadInfoResponse.getResponseMetadata().hasError()) {
            throw new Exception(vodApplyUploadInfoResponse.getResponseMetadata().getError().getMessage());
        }
        VodUploadAddress vodUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getUploadAddress();
        if (!vodApplyUploadInfoResponse.hasResult() || vodUploadAddress.getStoreInfosCount() == 0) {
            throw new Exception("apply upload result is null");
        }
        String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
        String sessionKey = vodUploadAddress.getSessionKey();
        String auth = vodUploadAddress.getStoreInfos(0).getAuth();
        String host = vodUploadAddress.getUploadHosts(0);
        List<VodHeaderPair> uploadHeaderList = vodUploadAddress.getUploadHeaderList();
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException().retryIfResult(Predicates.equalTo((Object)false)).retryIfResult(Predicates.isNull()).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
        if (file.length() < 0x1400000L) {
            this.directUpload(host, oid, auth, uploadHeaderList, file, retryer, storageClass, listener);
        } else {
            this.chunkUpload(host, oid, auth, uploadHeaderList, file, true, retryer, storageClass, listener);
        }
        UploadCompleteInfo uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
        return uploadCompleteInfo;
    }

    private void directUpload(String host, String oid, String auth, List<VodHeaderPair> uploadHeaderList, File file, Retryer retryer, int storageClass, VodUploadProgressListener listener) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s", host, oidEncode);
        byte[] bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        long crc32 = Utils.crc32(bytes);
        String checkSum = String.format("%08x", crc32);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        headers.put("Content-CRC32", checkSum);
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));
        if (storageClass == 2) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        retryer.call(() -> this.putData(url, bytes, headers));
        VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, file.length() - 1L);
    }

    private void chunkUpload(String host, String oid, String auth, List<VodHeaderPair> uploadHeaderList, File file, boolean isLargeFile, Retryer retryer, int storageClass, VodUploadProgressListener listener) throws Exception {
        String uploadID = this.initUploadPart(host, oid, auth, isLargeFile, uploadHeaderList, retryer, storageClass);
        byte[] data = new byte[0x1400000];
        ArrayList<String> parts = new ArrayList<String>();
        long num = file.length() / 0x1400000L;
        long lastNum = num - 1L;
        String objectContentType = "";
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            long partNumber;
            for (long i = 0L; i < lastNum; ++i) {
                bis.read(data);
                partNumber = isLargeFile ? i + 1L : i;
                UploadPartResponse uploadPartResponse = this.uploadPart(host, oid, auth, uploadID, partNumber, data, isLargeFile, retryer, storageClass);
                parts.add(uploadPartResponse.getCheckSum());
                if (partNumber == 1L) {
                    objectContentType = uploadPartResponse.getObjectContentType();
                }
                VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, data.length);
            }
            long readCount = 0x1400000L * lastNum;
            int len = (int)(file.length() - readCount);
            byte[] lastPart = new byte[len];
            bis.read(lastPart);
            partNumber = isLargeFile ? lastNum + 1L : lastNum;
            UploadPartResponse uploadPartResponse = this.uploadPart(host, oid, auth, uploadID, partNumber, lastPart, isLargeFile, retryer, storageClass);
            parts.add(uploadPartResponse.getCheckSum());
            if (partNumber == 1L) {
                objectContentType = uploadPartResponse.getObjectContentType();
            }
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, lastPart.length - 1);
        }
        this.uploadMergePart(host, oid, auth, uploadID, (String[])parts.stream().toArray(String[]::new), isLargeFile, retryer, storageClass, objectContentType);
    }

    private String initUploadPart(String host, String oid, String auth, boolean isLargeFile, List<VodHeaderPair> uploadHeaderList, Retryer retryer, int storageClass) throws ExecutionException, RetryException, IOException {
        HttpResponse httpResponse;
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s?uploads", host, oidEncode);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));
        if (storageClass == 2) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        if ((httpResponse = (HttpResponse)retryer.call(() -> this.putDataWithResponse(url, new byte[0], headers))) == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    private UploadPartResponse uploadPart(String host, String oid, String auth, String uploadID, long partNumber, byte[] data, boolean isLargeFile, Retryer retryer, int storageClass) throws Exception {
        HttpResponse httpResponse;
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s?partNumber=%d&uploadID=%s", host, oidEncode, partNumber, uploadID);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        long crc32 = Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if (storageClass == 2) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        if ((httpResponse = (HttpResponse)retryer.call(() -> this.putDataWithResponse(url, data, headers))) == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        return UploadPartResponse.builder().checkSum(checkSum).objectContentType(result.getJSONObject("payload").getJSONObject("meta").getString("ObjectContentType")).build();
    }

    private void uploadMergePart(String host, String oid, String auth, String uploadID, String[] checkSum, boolean isLargeFile, Retryer retryer, int storageClass, String objectContentType) throws ExecutionException, RetryException {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s?uploadID=%s&ObjectContentType=%s", host, oidEncode, uploadID, objectContentType);
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if (storageClass == 2) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        retryer.call(() -> this.putData(url, body.getBytes(), headers));
    }

    @Override
    public VodCommitUploadInfoResponse uploadMaterial(VodUploadMaterialRequest vodUploadMaterialRequest, VodUploadProgressListener listener) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMaterialRequest.getSpaceName(), vodUploadMaterialRequest.getFilePath(), vodUploadMaterialRequest.getFileType(), vodUploadMaterialRequest.getFileName(), vodUploadMaterialRequest.getFileExtension(), 0, listener);
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMaterialRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMaterialRequest.getFunctions()).setCallbackArgs(vodUploadMaterialRequest.getCallbackArgs()).build();
        VodCommitUploadInfoResponse vodCommitUploadInfoResponse = this.commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1L);
        }
        return vodCommitUploadInfoResponse;
    }

    @Override
    public VodSubmitDirectEditTaskAsyncResponse submitDirectEditTaskAsync(VodSubmitDirectEditTaskAsyncRequest input) throws Exception {
        RawResponse response;
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        JSONObject inputMap = JSON.parseObject((String)jsonData);
        if (inputMap.containsKey("EditParam")) {
            JSONObject editParam = JSON.parseObject((String)input.getEditParam().toString(StandardCharsets.UTF_8));
            inputMap.put("EditParam", editParam);
        }
        if ((response = this.json("SubmitDirectEditTaskAsync", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)inputMap))).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitDirectEditTaskAsyncResponse.Builder responseBuilder = VodSubmitDirectEditTaskAsyncResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse getDirectEditResult(VodGetDirectEditResultRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        RawResponse response = this.json("GetDirectEditResult", new ArrayList<NameValuePair>(), jsonData);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetDirectEditResultResponse resp = (VodGetDirectEditResultResponse)JSON.parseObject((byte[])response.getData(), VodGetDirectEditResultResponse.class, (Feature[])new Feature[0]);
        if (resp.result != null) {
            for (int i = 0; i < resp.result.size(); ++i) {
                Map<String, Object> value = resp.result.get(i);
                if (!value.containsKey("EditParam")) continue;
                Object editParam = value.get("EditParam");
                byte[] editParamBytes = JSON.toJSONBytes((Object)editParam, (SerializerFeature[])new SerializerFeature[0]);
                value.put("EditParam", editParamBytes);
                resp.result.set(i, value);
            }
        }
        VodGetDirectEditResultResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes((Object)resp, (SerializerFeature[])new SerializerFeature[0]))), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse getDirectEditProgress(VodGetDirectEditProgressRequest input) throws Exception {
        RawResponse response = this.query("GetDirectEditProgress", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetDirectEditProgressResponse resp = (VodGetDirectEditProgressResponse)JSON.parseObject((byte[])response.getData(), VodGetDirectEditProgressResponse.class, (Feature[])new Feature[0]);
        if (resp.result != null) {
            Result res = new Result();
            res.result = (Integer)resp.result;
            resp.result = res;
        }
        VodGetDirectEditProgressResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes((Object)resp, (SerializerFeature[])new SerializerFeature[0]))), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlayInfoResponse getPlayInfo(VodGetPlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoResponse.Builder responseBuilder = VodGetPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPrivateDrmPlayAuthResponse getPrivateDrmPlayAuth(VodGetPrivateDrmPlayAuthRequest input) throws Exception {
        RawResponse response = this.query("GetPrivateDrmPlayAuth", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPrivateDrmPlayAuthResponse.Builder responseBuilder = VodGetPrivateDrmPlayAuthResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetHlsDecryptionKeyResponse getHlsDecryptionKey(VodGetHlsDecryptionKeyRequest input) throws Exception {
        RawResponse response = this.query("GetHlsDecryptionKey", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetHlsDecryptionKeyResponse.Builder responseBuilder = VodGetHlsDecryptionKeyResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateHlsDecryptionKeyResponse createHlsDecryptionKey(VodCreateHlsDecryptionKeyRequest input) throws Exception {
        RawResponse response = this.query("CreateHlsDecryptionKey", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateHlsDecryptionKeyResponse.Builder responseBuilder = VodCreateHlsDecryptionKeyResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlayInfoWithLiveTimeShiftSceneResponse getPlayInfoWithLiveTimeShiftScene(VodGetPlayInfoWithLiveTimeShiftSceneRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfoWithLiveTimeShiftScene", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoWithLiveTimeShiftSceneResponse.Builder responseBuilder = VodGetPlayInfoWithLiveTimeShiftSceneResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUrlUploadResponse uploadMediaByUrl(VodUrlUploadRequest input) throws Exception {
        RawResponse response = this.post("UploadMediaByUrl", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUrlUploadResponse.Builder responseBuilder = VodUrlUploadResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodQueryUploadTaskInfoResponse queryUploadTaskInfo(VodQueryUploadTaskInfoRequest input) throws Exception {
        RawResponse response = this.query("QueryUploadTaskInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodQueryUploadTaskInfoResponse.Builder responseBuilder = VodQueryUploadTaskInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodApplyUploadInfoResponse applyUploadInfo(VodApplyUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("ApplyUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodApplyUploadInfoResponse.Builder responseBuilder = VodApplyUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCommitUploadInfoResponse commitUploadInfo(VodCommitUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("CommitUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCommitUploadInfoResponse.Builder responseBuilder = VodCommitUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaInfoResponse updateMediaInfo(VodUpdateMediaInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaInfoResponse.Builder responseBuilder = VodUpdateMediaInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaPublishStatusResponse updateMediaPublishStatus(VodUpdateMediaPublishStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaPublishStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaPublishStatusResponse.Builder responseBuilder = VodUpdateMediaPublishStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaStorageClassResponse updateMediaStorageClass(VodUpdateMediaStorageClassRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaStorageClass", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaStorageClassResponse.Builder responseBuilder = VodUpdateMediaStorageClassResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaInfosResponse getMediaInfos(VodGetMediaInfosRequest input) throws Exception {
        RawResponse response = this.query("GetMediaInfos", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaInfosResponse.Builder responseBuilder = VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetRecommendedPosterResponse getRecommendedPoster(VodGetRecommendedPosterRequest input) throws Exception {
        RawResponse response = this.query("GetRecommendedPoster", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetRecommendedPosterResponse.Builder responseBuilder = VodGetRecommendedPosterResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteMediaResponse deleteMedia(VodDeleteMediaRequest input) throws Exception {
        RawResponse response = this.query("DeleteMedia", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteMediaResponse.Builder responseBuilder = VodDeleteMediaResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteTranscodesResponse deleteTranscodes(VodDeleteTranscodesRequest input) throws Exception {
        RawResponse response = this.query("DeleteTranscodes", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteTranscodesResponse.Builder responseBuilder = VodDeleteTranscodesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaListResponse getMediaList(VodGetMediaListRequest input) throws Exception {
        RawResponse response = this.query("GetMediaList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaListResponse.Builder responseBuilder = VodGetMediaListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSubtitleInfoListResponse getSubtitleInfoList(VodGetSubtitleInfoListRequest input) throws Exception {
        RawResponse response = this.query("GetSubtitleInfoList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSubtitleInfoListResponse.Builder responseBuilder = VodGetSubtitleInfoListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleStatusResponse updateSubtitleStatus(VodUpdateSubtitleStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleStatusResponse.Builder responseBuilder = VodUpdateSubtitleStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleInfoResponse updateSubtitleInfo(VodUpdateSubtitleInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleInfoResponse.Builder responseBuilder = VodUpdateSubtitleInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreatePlaylistResponse createPlaylist(VodCreatePlaylistRequest input) throws Exception {
        RawResponse response = this.query("CreatePlaylist", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreatePlaylistResponse.Builder responseBuilder = VodCreatePlaylistResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlaylistsResponse getPlaylists(VodGetPlaylistsRequest input) throws Exception {
        RawResponse response = this.query("GetPlaylists", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlaylistsResponse.Builder responseBuilder = VodGetPlaylistsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdatePlaylistResponse updatePlaylist(VodUpdatePlaylistRequest input) throws Exception {
        RawResponse response = this.query("UpdatePlaylist", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdatePlaylistResponse.Builder responseBuilder = VodUpdatePlaylistResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeletePlaylistResponse deletePlaylist(VodDeletePlaylistRequest input) throws Exception {
        RawResponse response = this.query("DeletePlaylist", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeletePlaylistResponse.Builder responseBuilder = VodDeletePlaylistResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateVideoClassificationResponse createVideoClassification(VodCreateVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("CreateVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateVideoClassificationResponse.Builder responseBuilder = VodCreateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateVideoClassificationResponse updateVideoClassification(VodUpdateVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("UpdateVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateVideoClassificationResponse.Builder responseBuilder = VodUpdateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteVideoClassificationResponse deleteVideoClassification(VodDeleteVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("DeleteVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteVideoClassificationResponse.Builder responseBuilder = VodDeleteVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListVideoClassificationsResponse listVideoClassifications(VodListVideoClassificationsRequest input) throws Exception {
        RawResponse response = this.query("ListVideoClassifications", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListVideoClassificationsResponse.Builder responseBuilder = VodListVideoClassificationsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListSnapshotsResponse listSnapshots(VodListSnapshotsRequest input) throws Exception {
        RawResponse response = this.query("ListSnapshots", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListSnapshotsResponse.Builder responseBuilder = VodListSnapshotsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStartWorkflowResponse startWorkflow(VodStartWorkflowRequest input) throws Exception {
        RawResponse response = this.query("StartWorkflow", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStartWorkflowResponse.Builder responseBuilder = VodStartWorkflowResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodRetrieveTranscodeResultResponse retrieveTranscodeResult(VodRetrieveTranscodeResultRequest input) throws Exception {
        RawResponse response = this.query("RetrieveTranscodeResult", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodRetrieveTranscodeResultResponse.Builder responseBuilder = VodRetrieveTranscodeResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetWorkflowExecutionStatusResponse GetWorkflowExecution(VodGetWorkflowExecutionStatusRequest input) throws Exception {
        RawResponse response = this.query("GetWorkflowExecution", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetWorkflowExecutionStatusResponse.Builder responseBuilder = VodGetWorkflowExecutionStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateSpaceResponse createSpace(VodCreateSpaceRequest input) throws Exception {
        RawResponse response = this.query("CreateSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateSpaceResponse.Builder responseBuilder = VodCreateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListSpaceResponse listSpace(VodListSpaceRequest input) throws Exception {
        RawResponse response = this.query("ListSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListSpaceResponse.Builder responseBuilder = VodListSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSpaceDetailResponse getSpaceDetail(VodGetSpaceDetailRequest input) throws Exception {
        RawResponse response = this.query("GetSpaceDetail", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSpaceDetailResponse.Builder responseBuilder = VodGetSpaceDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSpaceUploadConfigResponse updateSpaceUploadConfig(VodUpdateSpaceUploadConfigRequest input) throws Exception {
        RawResponse response = this.query("UpdateSpaceUploadConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSpaceUploadConfigResponse.Builder responseBuilder = VodUpdateSpaceUploadConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodSpaceStorageDataResponse describeVodSpaceStorageData(VodDescribeVodSpaceStorageDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceStorageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodSpaceStorageDataResponse.Builder responseBuilder = VodDescribeVodSpaceStorageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStartDomainResponse startDomain(VodStartDomainRequest input) throws Exception {
        RawResponse response = this.query("StartDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStartDomainResponse.Builder responseBuilder = VodStartDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStopDomainResponse stopDomain(VodStopDomainRequest input) throws Exception {
        RawResponse response = this.query("StopDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStopDomainResponse.Builder responseBuilder = VodStopDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodAddDomainToSchedulerResponse addDomainToScheduler(VodAddDomainToSchedulerRequest input) throws Exception {
        RawResponse response = this.query("AddDomainToScheduler", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodAddDomainToSchedulerResponse.Builder responseBuilder = VodAddDomainToSchedulerResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodRemoveDomainFromSchedulerResponse removeDomainFromScheduler(VodRemoveDomainFromSchedulerRequest input) throws Exception {
        RawResponse response = this.query("RemoveDomainFromScheduler", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodRemoveDomainFromSchedulerResponse.Builder responseBuilder = VodRemoveDomainFromSchedulerResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainPlayRuleResponse updateDomainPlayRule(VodUpdateDomainPlayRuleRequestRequest input) throws Exception {
        RawResponse response = this.query("UpdateDomainPlayRule", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainPlayRuleResponse.Builder responseBuilder = VodUpdateDomainPlayRuleResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListDomainResponse listDomain(VodListDomainRequest input) throws Exception {
        RawResponse response = this.query("ListDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListDomainResponse.Builder responseBuilder = VodListDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateCdnRefreshTaskResponse createCdnRefreshTask(VodCreateCdnRefreshTaskRequest input) throws Exception {
        RawResponse response = this.query("CreateCDNRefreshTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateCdnRefreshTaskResponse.Builder responseBuilder = VodCreateCdnRefreshTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateCdnPreloadTaskResponse createCdnPreloadTask(VodCreateCdnPreloadTaskRequest input) throws Exception {
        RawResponse response = this.query("CreateCDNPreloadTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateCdnPreloadTaskResponse.Builder responseBuilder = VodCreateCdnPreloadTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTasksResponse listCdnTasks(VodListCdnTasksRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTasks", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTasksResponse.Builder responseBuilder = VodListCdnTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnAccessLogResponse listCdnAccessLog(VodListCdnAccessLogRequest input) throws Exception {
        RawResponse response = this.query("ListCdnAccessLog", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnAccessLogResponse.Builder responseBuilder = VodListCdnAccessLogResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTopAccessUrlResponse listCdnTopAccessUrl(VodListCdnTopAccessUrlRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTopAccessUrl", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTopAccessUrlResponse.Builder responseBuilder = VodListCdnTopAccessUrlResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodDomainBandwidthDataResponse describeVodDomainBandwidthData(VodDescribeVodDomainBandwidthDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodDomainBandwidthData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodDomainBandwidthDataResponse.Builder responseBuilder = VodDescribeVodDomainBandwidthDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnUsageData(VodListCdnUsageDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnUsageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnUsageDataDetailResponse listCdnUsageDataDetail(VodListCdnUsageDataDetailRequest input) throws Exception {
        RawResponse response = this.query("ListCdnUsageDataDetail", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnUsageDataDetailResponse.Builder responseBuilder = VodListCdnUsageDataDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnStatusData(VodListCdnStatusDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnStatusData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnStatusDataDetailResponse listCdnStatusDataDetail(VodListCdnStatusDataDetailRequest input) throws Exception {
        RawResponse response = this.query("ListCdnStatusDataDetail", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnStatusDataDetailResponse.Builder responseBuilder = VodListCdnStatusDataDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeIPInfoResponse describeIpInfo(VodDescribeIPInfoRequest input) throws Exception {
        RawResponse response = this.query("DescribeIpInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeIPInfoResponse.Builder responseBuilder = VodDescribeIPInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodDomainTrafficDataResponse describeVodDomainTrafficData(VodDescribeVodDomainTrafficDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodDomainTrafficData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodDomainTrafficDataResponse.Builder responseBuilder = VodDescribeVodDomainTrafficDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnPvData(VodListCdnPvDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnPvData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSubmitBlockTasksResponse submitBlockTasks(VodSubmitBlockTasksRequest input) throws Exception {
        RawResponse response = this.post("SubmitBlockTasks", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitBlockTasksResponse.Builder responseBuilder = VodSubmitBlockTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetContentBlockTasksResponse getContentBlockTasks(VodGetContentBlockTasksRequest input) throws Exception {
        RawResponse response = this.post("GetContentBlockTasks", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetContentBlockTasksResponse.Builder responseBuilder = VodGetContentBlockTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateDomainV2Response createDomain(VodCreateDomainV2Request input) throws Exception {
        RawResponse response = this.query("CreateDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateDomainV2Response.Builder responseBuilder = VodCreateDomainV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainExpireV2Response updateDomainExpire(VodUpdateDomainExpireV2Request input) throws Exception {
        RawResponse response = this.query("UpdateDomainExpire", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainExpireV2Response.Builder responseBuilder = VodUpdateDomainExpireV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public AddOrUpdateCertificateV2Response addOrUpdateCertificate(AddOrUpdateCertificateV2Request input) throws Exception {
        RawResponse response = this.post("AddOrUpdateCertificate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        AddOrUpdateCertificateV2Response.Builder responseBuilder = AddOrUpdateCertificateV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodAddCallbackSubscriptionResponse addCallbackSubscription(VodAddCallbackSubscriptionRequest input) throws Exception {
        RawResponse response = this.query("AddCallbackSubscription", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodAddCallbackSubscriptionResponse.Builder responseBuilder = VodAddCallbackSubscriptionResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSetCallbackEventResponse setCallbackEvent(VodSetCallbackEventRequest input) throws Exception {
        RawResponse response = this.query("SetCallbackEvent", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSetCallbackEventResponse.Builder responseBuilder = VodSetCallbackEventResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceTranscodeDataResponse describeVodSpaceTranscodeData(DescribeVodSpaceTranscodeDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceTranscodeData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceTranscodeDataResponse.Builder responseBuilder = DescribeVodSpaceTranscodeDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceSubtitleStatisDataResponse describeVodSpaceSubtitleStatisData(DescribeVodSpaceSubtitleStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceSubtitleStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceSubtitleStatisDataResponse.Builder responseBuilder = DescribeVodSpaceSubtitleStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSnapshotDataResponse describeVodSnapshotData(DescribeVodSnapshotDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSnapshotData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSnapshotDataResponse.Builder responseBuilder = DescribeVodSnapshotDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodEnhanceImageDataResponse describeVodEnhanceImageData(DescribeVodEnhanceImageDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodEnhanceImageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodEnhanceImageDataResponse.Builder responseBuilder = DescribeVodEnhanceImageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodPlayedStatisDataResponse describeVodPlayedStatisData(DescribeVodPlayedStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodPlayedStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodPlayedStatisDataResponse.Builder responseBuilder = DescribeVodPlayedStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodMostPlayedStatisDataResponse describeVodMostPlayedStatisData(DescribeVodMostPlayedStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodMostPlayedStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodMostPlayedStatisDataResponse.Builder responseBuilder = DescribeVodMostPlayedStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodRealtimeMediaDataResponse describeVodRealtimeMediaData(DescribeVodRealtimeMediaDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodRealtimeMediaData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodRealtimeMediaDataResponse.Builder responseBuilder = DescribeVodRealtimeMediaDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    static class Result {
        @JSONField(name="Result")
        public Integer result;

        Result() {
        }
    }

    static class VodGetDirectEditProgressResponse {
        @JSONField(name="ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name="Result")
        public Object result;

        VodGetDirectEditProgressResponse() {
        }
    }

    static class VodGetDirectEditResultResponse {
        @JSONField(name="ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name="Result")
        public List<Map<String, Object>> result;

        VodGetDirectEditResultResponse() {
        }
    }

    static class UploadPartResponse {
        private String checkSum;
        private String objectContentType;

        UploadPartResponse(String checkSum, String objectContentType) {
            this.checkSum = checkSum;
            this.objectContentType = objectContentType;
        }

        public static UploadPartResponseBuilder builder() {
            return new UploadPartResponseBuilder();
        }

        public String getCheckSum() {
            return this.checkSum;
        }

        public String getObjectContentType() {
            return this.objectContentType;
        }

        public void setCheckSum(String checkSum) {
            this.checkSum = checkSum;
        }

        public void setObjectContentType(String objectContentType) {
            this.objectContentType = objectContentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UploadPartResponse)) {
                return false;
            }
            UploadPartResponse other = (UploadPartResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$checkSum = this.getCheckSum();
            String other$checkSum = other.getCheckSum();
            if (this$checkSum == null ? other$checkSum != null : !this$checkSum.equals(other$checkSum)) {
                return false;
            }
            String this$objectContentType = this.getObjectContentType();
            String other$objectContentType = other.getObjectContentType();
            return !(this$objectContentType == null ? other$objectContentType != null : !this$objectContentType.equals(other$objectContentType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UploadPartResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $checkSum = this.getCheckSum();
            result = result * 59 + ($checkSum == null ? 43 : $checkSum.hashCode());
            String $objectContentType = this.getObjectContentType();
            result = result * 59 + ($objectContentType == null ? 43 : $objectContentType.hashCode());
            return result;
        }

        public String toString() {
            return "VodServiceImpl.UploadPartResponse(checkSum=" + this.getCheckSum() + ", objectContentType=" + this.getObjectContentType() + ")";
        }

        public static class UploadPartResponseBuilder {
            private String checkSum;
            private String objectContentType;

            UploadPartResponseBuilder() {
            }

            public UploadPartResponseBuilder checkSum(String checkSum) {
                this.checkSum = checkSum;
                return this;
            }

            public UploadPartResponseBuilder objectContentType(String objectContentType) {
                this.objectContentType = objectContentType;
                return this;
            }

            public UploadPartResponse build() {
                return new UploadPartResponse(this.checkSum, this.objectContentType);
            }

            public String toString() {
                return "VodServiceImpl.UploadPartResponse.UploadPartResponseBuilder(checkSum=" + this.checkSum + ", objectContentType=" + this.objectContentType + ")";
            }
        }
    }
}

