/*
 * Code Dx API
 * Code Dx provides a variety of REST APIs, allowing external applications and scripts to interface with core functionality. This guide documents the various REST resources provided by Code Dx.  ## Authentication  Authentication is a requirement when accessing API endpoints. There are two methods by which authentication may be performed.  ### API Keys  The primary method for authentication is passing an `API-Key` header containing a valid API key with all requests.  For example&#58;  `API-Key: 550e8400-e29b-41d4-a716-44665544000`  API keys may be generated by Code Dx admins. Once they are generated, in most cases, they behave like regular users. They will need to be assigned user roles for any projects they will be used with. Although it is possible to assign the *admin* [role](UserGuide.html#UserRolesConfiguration) to an API key, the recommendation is to avoid doing so unless absolutely necessary.  See the user guide for an overview about how to create and manage [API keys](UserGuide.html#APIKeysAdministration).  ### HTTP Basic Authentication  HTTP Basic authentication may be used to authenticate with the API as a regular user. This is accomplished by including an `Authorization` header containing a typical authorization credential.  ## Error Handling  ### Bad Requests  For API calls that accept input, invalid values will trigger an HTTP 400 Bad Request status code.  ### Server Errors  For any API call, if an unexpected error occurs, an HTTP 500 Internal Server Error status code will be returned. If an error message is available, the response will include a basic message body describing the error&#58;  ` {   \"error\": \"error message\" } `  The error property will contain a string message indicating the nature of the error.  ### Errors with Third-Party Applications  Sometimes Code Dx must communicate with third-party applications like JIRA, Git, and certain enterprise tools. Some users may have in-house versions of these with self-signed certificates which may not be \"trusted\". In these cases, the API will respond with an HTTP 502 BAD GATEWAY status. If this happens, refer to [Trusting Self-Signed Certificates](InstallGuide.html#TrustingSelfSignedCertificates) in the install guide.  ### API Unavailable  In special circumstances, particularly during the installation and update phases, the API will be unavailable. When the API is unavailable, all calls will return an HTTP 503 Service Unavailable status, and no actions or side effects will occur as a result of the calls.  ## Examples  Code Dx's API uses REST over HTTP. As such, you can use any language/utility that supports making HTTP requests to interact with the API. The examples below use <a href=\"https://curl.haxx.se/\" target=\"_blank\">curl</a>, a popular command-line utility, to do so.  First, you'll need to [generate an API Key](UserGuide.html#APIKeysAdministration). Second, while you can create projects through the API, these examples will assume that you've already created one. You'll need to know its project id number, which you can find by looking at the URL for the [Findings Page](UserGuide.html#Findings), which will end in a number.  **Note:** Many API endpoints require a JSON body in the request. Most JSON will contain double-quotes (`\"`) and spaces, which have special meaning when used on the command line. In order to ensure your JSON body is interpreted as a single argument, you must <a href=\"https://en.wikipedia.org/wiki/Escape_character\" target=\"_blank\">escape</a> it properly. For example, if you wanted to `POST` the following JSON body&#58;  ``` { \"name\": \"John Doe\" } ```  You would put a backslash (`\\`) before each double-quote (`\"`), and surround the whole thing with double-quotes&#58;  ``` \"{ \\\"name\\\": \\\"John Doe\\\" }\" ```  The outermost double-quotes tell the command-line interpreter that everything within them is to be treated as a single argument (as opposed to the usual space-separated behavior). The backslash before each inner double-quote tells the command-line interpreter that you mean the literal double-quote character, and not the end of the quoted argument.  In many *non-Windows* operating systems, you can also use a single-quote (`'`) to surround the argument, and skip the backslashes&#58;  ``` '{ \"name\": \"John Doe\" }' ```  The examples below will use the double-quotes and backslashes style, as it works on most (if not all) operating systems.  ### Running an Analysis  To start an analysis, you can run  ``` curl -F file1=@src.zip -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/analysis ```  Make sure you use your own values for the `src.zip` file, the API Key, the hostname for your Code Dx server, and the project id.  **Note:** This endpoint is not listed below due to a swagger limitation.  ### Retrieving Finding Data  There is a wide variety of data available for the findings of a project after running an analysis. Two examples are provided here.  ### Findings Table Data  You can retrieve the data that's used to populate the [findings table](UserGuide.html#FindingsTable)&#58;  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"sort\\\":{\\\"by\\\":\\\"id\\\",\\\"direction\\\":\\\"ascending\\\"},\\\"pagination\\\":{\\\"page\\\":1,\\\"perPage\\\":10}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/findings/table ```  Additional information about how to construct more useful filter and sort requests can be found in the documentation.  ### Finding Metadata  You can retrieve metadata for a finding, if you know the finding id. You can take the ID for a finding from the Findings Table&#58;  ``` curl -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/findings/<finding id> ```  ### Generating a Report  You can use the API to generate a PDF [report](UserGuide.html#GenerateReport).  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"config\\\":{\\\"summaryMode\\\":\\\"simple\\\",\\\"detailsMode\\\":\\\"simple\\\",\\\"includeResultDetails\\\":true,\\\"includeComments\\\":false}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/report/pdf ```  ## Generating a Client SDK  If you require a client SDK for Code Dx, you can generate one using [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen). Detailed instructions are available on the github page and our swagger spec can be found [here](swagger/swagger.json). 
 *
 * OpenAPI spec version: 3.5.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.codedx.client.model;

import java.util.Objects;
import com.codedx.client.model.Cwe;
import com.codedx.client.model.Descriptions;
import com.codedx.client.model.DetectionMethod;
import com.codedx.client.model.Element;
import com.codedx.client.model.FindingDescriptor;
import com.codedx.client.model.Issue;
import com.codedx.client.model.Location;
import com.codedx.client.model.Severity;
import com.codedx.client.model.ToolResult;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Finding
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-12-07T19:30:21.793Z")
public class Finding {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("projectId")
  private Integer projectId = null;

  @SerializedName("detectionMethod")
  private DetectionMethod detectionMethod = null;

  @SerializedName("descriptor")
  private FindingDescriptor descriptor = null;

  @SerializedName("location")
  private Location location = null;

  @SerializedName("severity")
  private Severity severity = null;

  @SerializedName("severityDefault")
  private Severity severityDefault = null;

  @SerializedName("severityOverride")
  private Severity severityOverride = null;

  @SerializedName("firstSeenOn")
  private String firstSeenOn = null;

  @SerializedName("cwe")
  private Cwe cwe = null;

  @SerializedName("element")
  private Element element = null;

  @SerializedName("status")
  private String status = null;

  @SerializedName("statusName")
  private String statusName = null;

  @SerializedName("triageTime")
  private String triageTime = null;

  @SerializedName("issue")
  private Issue issue = null;

  @SerializedName("descriptions")
  private Descriptions descriptions = null;

  @SerializedName("results")
  private List<ToolResult> results = null;

  public Finding id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public Finding projectId(Integer projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * Get projectId
   * @return projectId
  **/
  @ApiModelProperty(value = "")
  public Integer getProjectId() {
    return projectId;
  }

  public void setProjectId(Integer projectId) {
    this.projectId = projectId;
  }

  public Finding detectionMethod(DetectionMethod detectionMethod) {
    this.detectionMethod = detectionMethod;
    return this;
  }

   /**
   * Get detectionMethod
   * @return detectionMethod
  **/
  @ApiModelProperty(value = "")
  public DetectionMethod getDetectionMethod() {
    return detectionMethod;
  }

  public void setDetectionMethod(DetectionMethod detectionMethod) {
    this.detectionMethod = detectionMethod;
  }

  public Finding descriptor(FindingDescriptor descriptor) {
    this.descriptor = descriptor;
    return this;
  }

   /**
   * Get descriptor
   * @return descriptor
  **/
  @ApiModelProperty(value = "")
  public FindingDescriptor getDescriptor() {
    return descriptor;
  }

  public void setDescriptor(FindingDescriptor descriptor) {
    this.descriptor = descriptor;
  }

  public Finding location(Location location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(value = "")
  public Location getLocation() {
    return location;
  }

  public void setLocation(Location location) {
    this.location = location;
  }

  public Finding severity(Severity severity) {
    this.severity = severity;
    return this;
  }

   /**
   * Get severity
   * @return severity
  **/
  @ApiModelProperty(value = "")
  public Severity getSeverity() {
    return severity;
  }

  public void setSeverity(Severity severity) {
    this.severity = severity;
  }

  public Finding severityDefault(Severity severityDefault) {
    this.severityDefault = severityDefault;
    return this;
  }

   /**
   * Get severityDefault
   * @return severityDefault
  **/
  @ApiModelProperty(value = "")
  public Severity getSeverityDefault() {
    return severityDefault;
  }

  public void setSeverityDefault(Severity severityDefault) {
    this.severityDefault = severityDefault;
  }

  public Finding severityOverride(Severity severityOverride) {
    this.severityOverride = severityOverride;
    return this;
  }

   /**
   * Get severityOverride
   * @return severityOverride
  **/
  @ApiModelProperty(value = "")
  public Severity getSeverityOverride() {
    return severityOverride;
  }

  public void setSeverityOverride(Severity severityOverride) {
    this.severityOverride = severityOverride;
  }

  public Finding firstSeenOn(String firstSeenOn) {
    this.firstSeenOn = firstSeenOn;
    return this;
  }

   /**
   * Get firstSeenOn
   * @return firstSeenOn
  **/
  @ApiModelProperty(value = "")
  public String getFirstSeenOn() {
    return firstSeenOn;
  }

  public void setFirstSeenOn(String firstSeenOn) {
    this.firstSeenOn = firstSeenOn;
  }

  public Finding cwe(Cwe cwe) {
    this.cwe = cwe;
    return this;
  }

   /**
   * Get cwe
   * @return cwe
  **/
  @ApiModelProperty(value = "")
  public Cwe getCwe() {
    return cwe;
  }

  public void setCwe(Cwe cwe) {
    this.cwe = cwe;
  }

  public Finding element(Element element) {
    this.element = element;
    return this;
  }

   /**
   * Get element
   * @return element
  **/
  @ApiModelProperty(value = "")
  public Element getElement() {
    return element;
  }

  public void setElement(Element element) {
    this.element = element;
  }

  public Finding status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(value = "")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Finding statusName(String statusName) {
    this.statusName = statusName;
    return this;
  }

   /**
   * Get statusName
   * @return statusName
  **/
  @ApiModelProperty(value = "")
  public String getStatusName() {
    return statusName;
  }

  public void setStatusName(String statusName) {
    this.statusName = statusName;
  }

  public Finding triageTime(String triageTime) {
    this.triageTime = triageTime;
    return this;
  }

   /**
   * Get triageTime
   * @return triageTime
  **/
  @ApiModelProperty(value = "")
  public String getTriageTime() {
    return triageTime;
  }

  public void setTriageTime(String triageTime) {
    this.triageTime = triageTime;
  }

  public Finding issue(Issue issue) {
    this.issue = issue;
    return this;
  }

   /**
   * Get issue
   * @return issue
  **/
  @ApiModelProperty(value = "")
  public Issue getIssue() {
    return issue;
  }

  public void setIssue(Issue issue) {
    this.issue = issue;
  }

  public Finding descriptions(Descriptions descriptions) {
    this.descriptions = descriptions;
    return this;
  }

   /**
   * Get descriptions
   * @return descriptions
  **/
  @ApiModelProperty(value = "")
  public Descriptions getDescriptions() {
    return descriptions;
  }

  public void setDescriptions(Descriptions descriptions) {
    this.descriptions = descriptions;
  }

  public Finding results(List<ToolResult> results) {
    this.results = results;
    return this;
  }

  public Finding addResultsItem(ToolResult resultsItem) {
    if (this.results == null) {
      this.results = new ArrayList<ToolResult>();
    }
    this.results.add(resultsItem);
    return this;
  }

   /**
   * Get results
   * @return results
  **/
  @ApiModelProperty(value = "")
  public List<ToolResult> getResults() {
    return results;
  }

  public void setResults(List<ToolResult> results) {
    this.results = results;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Finding finding = (Finding) o;
    return Objects.equals(this.id, finding.id) &&
        Objects.equals(this.projectId, finding.projectId) &&
        Objects.equals(this.detectionMethod, finding.detectionMethod) &&
        Objects.equals(this.descriptor, finding.descriptor) &&
        Objects.equals(this.location, finding.location) &&
        Objects.equals(this.severity, finding.severity) &&
        Objects.equals(this.severityDefault, finding.severityDefault) &&
        Objects.equals(this.severityOverride, finding.severityOverride) &&
        Objects.equals(this.firstSeenOn, finding.firstSeenOn) &&
        Objects.equals(this.cwe, finding.cwe) &&
        Objects.equals(this.element, finding.element) &&
        Objects.equals(this.status, finding.status) &&
        Objects.equals(this.statusName, finding.statusName) &&
        Objects.equals(this.triageTime, finding.triageTime) &&
        Objects.equals(this.issue, finding.issue) &&
        Objects.equals(this.descriptions, finding.descriptions) &&
        Objects.equals(this.results, finding.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, projectId, detectionMethod, descriptor, location, severity, severityDefault, severityOverride, firstSeenOn, cwe, element, status, statusName, triageTime, issue, descriptions, results);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Finding {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    detectionMethod: ").append(toIndentedString(detectionMethod)).append("\n");
    sb.append("    descriptor: ").append(toIndentedString(descriptor)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    severity: ").append(toIndentedString(severity)).append("\n");
    sb.append("    severityDefault: ").append(toIndentedString(severityDefault)).append("\n");
    sb.append("    severityOverride: ").append(toIndentedString(severityOverride)).append("\n");
    sb.append("    firstSeenOn: ").append(toIndentedString(firstSeenOn)).append("\n");
    sb.append("    cwe: ").append(toIndentedString(cwe)).append("\n");
    sb.append("    element: ").append(toIndentedString(element)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusName: ").append(toIndentedString(statusName)).append("\n");
    sb.append("    triageTime: ").append(toIndentedString(triageTime)).append("\n");
    sb.append("    issue: ").append(toIndentedString(issue)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

