/*
 * Decompiled with CFR 0.152.
 */
package com.github.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class HttpHandler {
    private static HttpHandler instance = new HttpHandler();

    private HttpHandler() {
    }

    public static HttpHandler getInstance() {
        return instance;
    }

    public String getRequest(String url) {
        return this.executeRequest((HttpUriRequest)new HttpGet(url));
    }

    public String postRequest(String url, Map<String, String> parameters) {
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.setEntity((HttpEntity)HttpHandler.mapToEntity(parameters));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.executeRequest((HttpUriRequest)httpPost);
    }

    private String executeRequest(HttpUriRequest request) {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpResponse execute = client.execute(request);
            Header firstHeader = execute.getFirstHeader("Content-Encoding");
            HttpEntity response = execute.getEntity();
            InputStream inputStream = response.getContent();
            if (firstHeader != null && firstHeader.getValue() != null && firstHeader.getValue().equalsIgnoreCase("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            return this.streamToString(inputStream);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static UrlEncodedFormEntity mapToEntity(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (parameters == null) {
            throw new IllegalArgumentException("Invalid parameters unable map to Entity");
        }
        if (parameters.isEmpty()) {
            return null;
        }
        ArrayList<BasicNameValuePair> parametersList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> element : parameters.entrySet()) {
            BasicNameValuePair nameValuePair = new BasicNameValuePair(element.getKey(), element.getValue());
            parametersList.add(nameValuePair);
        }
        return new UrlEncodedFormEntity(parametersList, "UTF-8");
    }

    private String streamToString(InputStream is) throws IOException {
        int n;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        is.close();
        return writer.toString();
    }
}

