/*
 * Decompiled with CFR 0.152.
 */
package com.github.jobs.api;

import com.github.bean.Job;
import com.github.bean.Search;
import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GithubJobsApi {
    public static final String SUBSCRIPTION_EMAIL_PARAM = "email";
    public static final String SUBSCRIPTION_DESCRIPTION_PARAM = "description";
    public static final String SUBSCRIPTION_LOCATION_PARAM = "location";
    public static final String SUBSCRIPTION_FULL_TIME_PARAM = "full_time";
    public static final String SUBSCRIPTION_OK_PARAM = "ok";

    public static List<Job> search(Search search) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (search.getSearch() != null) {
            pairs.add(new NameValuePair("search", search.getSearch()));
        }
        if (search.getLocation() != null) {
            pairs.add(new NameValuePair(SUBSCRIPTION_LOCATION_PARAM, search.getLocation()));
        } else if (search.getLatitude() != 0.0 && search.getLongitude() != 0.0) {
            pairs.add(new NameValuePair("lat", String.valueOf(search.getLatitude())));
            pairs.add(new NameValuePair("long", String.valueOf(search.getLongitude())));
        }
        if (search.getPage() > 0) {
            pairs.add(new NameValuePair("page", String.valueOf(search.getPage())));
        }
        if (search.isFullTime()) {
            pairs.add(new NameValuePair(SUBSCRIPTION_FULL_TIME_PARAM, String.valueOf(search.isFullTime())));
        }
        try {
            String url = GithubJobsApi.createUrl("https://jobs.github.com/positions.json", pairs);
            String response = HttpRequest.get((CharSequence)url).acceptGzipEncoding().acceptJson().body();
            if (response == null) {
                throw new RuntimeException("Error calling API; it returned null.");
            }
            Gson gson = new Gson();
            JSONArray jsonArray = new JSONArray(response);
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                jobs.add((Job)gson.fromJson(object.toString(), Job.class));
            }
            return jobs;
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Job getJob(String id, boolean markdown) {
        String baseUrl = String.format("https://jobs.github.com/positions/%s.json", id);
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        if (markdown) {
            pairs.add(new NameValuePair("markdown", String.valueOf(markdown)));
        }
        try {
            String url = GithubJobsApi.createUrl(baseUrl, pairs);
            String response = HttpRequest.get((CharSequence)url).body();
            Gson gson = new Gson();
            return (Job)gson.fromJson(response, Job.class);
        }
        catch (URIException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean subscribe(String email, String description, String location, boolean fullTime) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(SUBSCRIPTION_EMAIL_PARAM, email);
        parameters.put(SUBSCRIPTION_DESCRIPTION_PARAM, description);
        parameters.put(SUBSCRIPTION_LOCATION_PARAM, location);
        parameters.put(SUBSCRIPTION_FULL_TIME_PARAM, String.valueOf(fullTime));
        String response = HttpRequest.post((CharSequence)"https://jobs.github.com/subscribe").part(SUBSCRIPTION_EMAIL_PARAM, email).part(SUBSCRIPTION_DESCRIPTION_PARAM, description).part(SUBSCRIPTION_LOCATION_PARAM, location).part(SUBSCRIPTION_FULL_TIME_PARAM, String.valueOf(fullTime)).body();
        return SUBSCRIPTION_OK_PARAM.equals(response);
    }

    private static String createUrl(String url, List<NameValuePair> pairs) throws URIException {
        GetMethod method = new GetMethod(url);
        NameValuePair[] nameValuePairs = pairs.toArray(new NameValuePair[pairs.size()]);
        method.setQueryString(nameValuePairs);
        return method.getURI().getEscapedURI();
    }
}

