/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.runner;

import com.codingapi.test.annotation.CheckMongoData;
import com.codingapi.test.annotation.Expected;
import com.codingapi.test.annotation.TestMethod;
import com.codingapi.test.runner.IMongoRunner;
import com.codingapi.test.xml.XmlInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class DefaultMongoRunner
implements IMongoRunner {
    private static final Logger log = LoggerFactory.getLogger(DefaultMongoRunner.class);

    @Override
    public void prepare(ApplicationContext applicationContext, XmlInfo xmlInfo) {
        MongoTemplate mongoTemplate = (MongoTemplate)applicationContext.getBean(MongoTemplate.class);
        for (Object object : xmlInfo.getList()) {
            Object res = mongoTemplate.save(object, xmlInfo.getName());
            log.info("mongodb->,rows:{}", res);
        }
    }

    @Override
    public void clear(ApplicationContext applicationContext, TestMethod testMethod) throws Exception {
        String[] collectionNames = testMethod.clearCollectionNames();
        if (collectionNames != null) {
            MongoTemplate mongoTemplate = (MongoTemplate)applicationContext.getBean(MongoTemplate.class);
            for (String collectionName : collectionNames) {
                mongoTemplate.dropCollection(collectionName);
                log.info("mysql drop collection->{}", (Object)collectionName);
            }
        }
    }

    @Override
    public void check(ApplicationContext applicationContext, TestMethod testMethod) throws Exception {
        for (CheckMongoData checkMongoData : testMethod.checkMongoData()) {
            String key = checkMongoData.primaryKey();
            String val = checkMongoData.primaryVal();
            Object pkval = val;
            if (checkMongoData.type().equals((Object)CheckMongoData.Type.INTEGER)) {
                pkval = Integer.parseInt(val);
            }
            if (checkMongoData.type().equals((Object)CheckMongoData.Type.LONG)) {
                pkval = Long.parseLong(val);
            }
            MongoTemplate mongoTemplate = (MongoTemplate)applicationContext.getBean(MongoTemplate.class);
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)key).is(pkval));
            List res = null;
            res = StringUtils.isEmpty((Object)checkMongoData.collection()) ? mongoTemplate.find(query, checkMongoData.bean()) : mongoTemplate.find(query, checkMongoData.bean(), checkMongoData.collection());
            log.info("mongo - check=> sql:{},res:{}", (Object)query, (Object)res);
            Expected[] expecteds = checkMongoData.expected();
            this.checkVal(res, expecteds, checkMongoData.desc());
        }
    }
}

