/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.xml;

import com.codingapi.test.xml.XmlInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class XmlUtils {
    public static <T> String create(XmlInfo xmlInfo) throws JsonProcessingException {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        xmlMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object val, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString("");
            }
        });
        String res = xmlMapper.writeValueAsString((Object)xmlInfo);
        return res;
    }

    public static <T> XmlInfo<T> parser(String xml) throws IOException, InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        XmlMapper xmlMapper = new XmlMapper();
        XmlInfo res = (XmlInfo)xmlMapper.readValue(xml, (TypeReference)new TypeReference<XmlInfo<LinkedHashMap<String, Object>>>(){});
        return XmlUtils.parser(res, Class.forName(res.getClassName()));
    }

    private static <T> XmlInfo<T> parser(XmlInfo<LinkedHashMap<String, Object>> res, Class<T> clazz) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        XmlInfo xmlInfo = new XmlInfo();
        BeanUtils.copyProperty(xmlInfo, (String)"initCmd", (Object)res.getInitCmd());
        BeanUtils.copyProperty(xmlInfo, (String)"dbType", (Object)((Object)res.getDbType()));
        BeanUtils.copyProperty(xmlInfo, (String)"name", (Object)res.getName());
        BeanUtils.copyProperty(xmlInfo, (String)"className", (Object)res.getClassName());
        for (Map map : res.getList()) {
            T t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.populate(t, (Map)map);
            xmlInfo.getList().add(t);
        }
        return xmlInfo;
    }
}

