/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Artifact;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GetArtifactRequest
extends GetRequest<Artifact> {
    private static final String ROUTE = "/api/codenav/artifact";

    public GetArtifactRequest(ServiceConnector connector, String artifactName, String codePack, String token) {
        super(connector, connector.getBase() + ROUTE, null, GetArtifactRequest.buildProps(artifactName, codePack), token);
    }

    private static Map<String, String> buildProps(String artifactName, String codePack) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("artifactName", artifactName);
        props.put("codePack", codePack);
        return props;
    }

    @Override
    @NotNull
    public Artifact parse(@NotNull String response) {
        Artifact artifact = null;
        try {
            artifact = (Artifact)new Gson().fromJson(response, Artifact.class);
        }
        catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        return artifact;
    }
}

