/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.connector;

import com.codota.service.client.CodotaResponse;
import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.client.requests.base.PutRequest;
import com.codota.service.client.requests.base.Request;
import com.codota.service.connector.ConnectorSettings;
import com.codota.service.connector.ServiceConnector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApacheServiceConnector
extends ServiceConnector {
    private static final int TIMEOUT_SECONDS = 30;
    private static final RequestConfig config = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
    private static final HttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    protected static ApacheServiceConnector instance;

    public ApacheServiceConnector(String base) {
        super(base);
    }

    public static ServiceConnector instance() {
        if (instance == null) {
            instance = new ApacheServiceConnector(ConnectorSettings.getDefaultBase());
        }
        return instance;
    }

    @Nullable
    public CodotaResponse getByURI(String uri, @Nullable String token) {
        String content;
        HttpResponse response;
        this.tracker.init(this.getClass());
        HttpGet request = new HttpGet(uri);
        this.addFrameworkHeaders((HttpRequest)request, token);
        this.tracker.connected();
        try {
            response = client.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            ConnectorSettings.LOG.warn("getByURI failed " + e);
            return null;
        }
        this.tracker.gotResponse();
        try {
            content = this.consumeResponse(response);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        CodotaResponse result = response.getStatusLine().getStatusCode() == 200 ? new CodotaResponse(content, 200) : (response.getStatusLine().getStatusCode() == 401 ? new CodotaResponse(null, 401) : new CodotaResponse(null, response.getStatusLine().getStatusCode()));
        this.tracker.finished();
        return result;
    }

    @Override
    @Nullable
    public CodotaResponse postJson(String route, @NotNull String jsonString, @Nullable String token) {
        HttpPost post = new HttpPost(route);
        post.addHeader("content-type", "application/json");
        CodotaResponse result = null;
        try {
            post.setEntity((HttpEntity)new StringEntity(jsonString));
            this.addFrameworkHeaders((HttpRequest)post, token);
            HttpResponse response = client.execute((HttpUriRequest)post);
            String content = this.consumeResponse(response);
            result = new CodotaResponse(content, response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            ConnectorSettings.LOG.warn("postJson failed " + e);
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public CodotaResponse put(PutRequest request) {
        HttpPut httpPut = new HttpPut();
        if (request.getBodyJsonString() != null) {
            httpPut.addHeader("content-type", "application/json");
            httpPut.setEntity((HttpEntity)new StringEntity(request.getBodyJsonString(), UTF8));
        }
        return this.httpEntityEnclosingRequestBase((HttpEntityEnclosingRequestBase)httpPut, request);
    }

    @Override
    public CodotaResponse post(Request request) {
        return this.httpEntityEnclosingRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(), request);
    }

    private CodotaResponse httpEntityEnclosingRequestBase(HttpEntityEnclosingRequestBase httpRequest, Request request) {
        CodotaResponse result = null;
        try {
            httpRequest.setURI(URI.create(this.getURI(request.getRoute(), "", request.getQueryParameters())));
            if (httpRequest.getEntity() == null) {
                this.addEncodedBodyAttributes(httpRequest, request.getBodyAttributes());
            }
            this.addFrameworkHeaders((HttpRequest)httpRequest, request.getToken());
            this.addRequestHeaders((HttpRequest)httpRequest, request);
            HttpResponse response = client.execute((HttpUriRequest)httpRequest);
            String content = this.consumeResponse(response);
            result = new CodotaResponse(content, response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            ConnectorSettings.LOG.warn(httpRequest.getMethod() + " failed " + e);
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public CodotaResponse get(GetRequest request) {
        try {
            return this.getByURI(this.getURI(request.getRoute(), request.getQuery(), request.getQueryParameters()), request.getToken());
        }
        catch (IOException e) {
            e.printStackTrace();
            ConnectorSettings.LOG.warn("get failed " + e);
            return null;
        }
    }

    private void addFrameworkHeaders(HttpRequest request, String token) {
        request.addHeader("User-Agent", "Codota IDE");
        if (token != null) {
            request.addHeader("authorization", "bearer " + token);
        }
        request.addHeader("origin", "https://intellij.codota.com");
        if (ConnectorSettings.getClientVersion() != null) {
            request.addHeader("apiversion", ConnectorSettings.getClientVersion());
        }
    }

    private void addRequestHeaders(HttpRequest httpRequest, Request request) {
        for (Map.Entry<String, String> headerEntry : request.getHeaderAttributes().entrySet()) {
            httpRequest.addHeader(headerEntry.getKey(), headerEntry.getValue());
        }
    }

    public void addEncodedBodyAttributes(HttpEntityEnclosingRequestBase request, Map<String, String> attributes) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            BasicNameValuePair bvp = new BasicNameValuePair(key, value);
            nameValuePairs.add(bvp);
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, UTF8));
    }

    @Override
    @Nullable
    public CodotaResponse post(String route, @NotNull Map<String, String> attributes, @Nullable String token) {
        HttpPost post = new HttpPost(route);
        CodotaResponse result = null;
        try {
            this.addEncodedBodyAttributes((HttpEntityEnclosingRequestBase)post, attributes);
            this.addFrameworkHeaders((HttpRequest)post, token);
            HttpResponse response = client.execute((HttpUriRequest)post);
            String content = this.consumeResponse(response);
            result = new CodotaResponse(content, response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            ConnectorSettings.LOG.warn("post failed " + e);
            e.printStackTrace();
        }
        return result;
    }

    public void close() {
    }
}

