/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client;

import com.codota.service.client.CodotaResponse;
import com.codota.service.client.requests.GetRequestEmptyResponse;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.UserInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthClient {
    protected static final Gson gson = new GsonBuilder().create();
    private static final String TOKEN_TEST = "/api/auth/user/tokentest?access_token=";
    private static final String USER_INFO = "/api/auth/user/tokentest";
    @Nullable
    protected String token;
    protected final ServiceConnector connector;

    public AuthClient(ServiceConnector connector) {
        this.connector = connector;
    }

    public void clearToken() {
        this.token = null;
        this.connector.clear();
    }

    public void setToken(@NotNull String token) {
        this.token = token;
        this.connector.clear();
    }

    public boolean isTokenValid(String query) {
        try {
            CodotaResponse response = this.connector.get(new GetRequestEmptyResponse(this.connector, this.connector.getBase() + TOKEN_TEST, null, query));
            return response != null && response.status == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    public UserInfo userInfo() {
        CodotaResponse response = this.connector.get(new GetRequestEmptyResponse(this.connector, this.connector.getBase() + USER_INFO, this.token));
        if (response != null && response.status == 200) {
            return this.parseUserInfoJson(response.content);
        }
        return UserInfo.UNKNOWN;
    }

    public UserInfo parseUserInfoJson(@NotNull String json) {
        UserInfo userInfo = UserInfo.UNKNOWN;
        try {
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse(json);
            userInfo = (UserInfo)gson.fromJson(root, UserInfo.class);
        }
        catch (IllegalStateException e) {
            System.err.println("json" + json);
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            System.err.println("json" + json);
            e.printStackTrace();
        }
        return userInfo;
    }
}

