/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client;

import com.codota.service.client.AuthClient;
import com.codota.service.client.CodotaConnectionException;
import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.requests.BoxRequest;
import com.codota.service.client.requests.SaveToBoxRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Snippet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class BoxClient
extends AuthClient {
    private static final Gson gson = new GsonBuilder().create();
    private static BoxClient instance;

    public BoxClient(ServiceConnector connector) {
        super(connector);
    }

    public static BoxClient client(ServiceConnector connector) {
        if (instance == null) {
            instance = new BoxClient(connector);
        }
        return instance;
    }

    public List<Snippet> getAllSnippets() throws IOException, CodotaHttpException, CodotaConnectionException {
        return (List)new BoxRequest(this.connector, this.token).run();
    }

    public String saveToBox(String title, String code, String description, List<String> tags) throws IOException, CodotaHttpException, CodotaConnectionException {
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("title", title);
        attribs.put("code", code);
        SaveToBoxRequest boxRequest = (SaveToBoxRequest)new SaveToBoxRequest(this.connector, this.token).withBodyAttributes(attribs);
        return (String)boxRequest.run();
    }
}

