/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.TextualMatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TextSearchRequest
extends GetRequest<List<TextualMatch>> {
    private static final String TEXT_SEARCH_ROUTE = "/api/search/source/";

    public TextSearchRequest(ServiceConnector connector, String term, String codePack, boolean all, String token) {
        super(connector, connector.getBase() + TEXT_SEARCH_ROUTE, term, TextSearchRequest.buildProps(codePack, all), token);
    }

    private static Map<String, String> buildProps(String codePack, boolean all) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("codePack", codePack);
        if (all) {
            props.put("all", "true");
        }
        return props;
    }

    @Override
    @NotNull
    public List<TextualMatch> parse(@NotNull String response) {
        TextualMatch[] result = new TextualMatch[]{};
        try {
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse(response);
            result = (TextualMatch[])gson.fromJson((JsonElement)root.getAsJsonObject().getAsJsonArray("files"), TextualMatch[].class);
        }
        catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        return Arrays.asList(result);
    }
}

