/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.pushapiclient;

import com.coveo.pushapiclient.AnySecurityIdentityBuilder;
import com.coveo.pushapiclient.SecurityIdentity;
import com.coveo.pushapiclient.SecurityIdentityBuilder;
import com.coveo.pushapiclient.SecurityIdentityType;
import java.util.Arrays;
import java.util.Objects;

public class GroupSecurityIdentityBuilder
implements SecurityIdentityBuilder {
    private final String[] identities;
    private final String securityProvider;

    public GroupSecurityIdentityBuilder(String[] identities, String securityProvider) {
        this.identities = identities;
        this.securityProvider = securityProvider;
    }

    public GroupSecurityIdentityBuilder(String identity, String securityProvider) {
        this(new String[]{identity}, securityProvider);
    }

    @Override
    public SecurityIdentity[] build() {
        return new AnySecurityIdentityBuilder(this.identities, SecurityIdentityType.GROUP, this.securityProvider).build();
    }

    public String[] getIdentities() {
        return this.identities;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public String toString() {
        return "GroupSecurityIdentityBuilder[identities=" + Arrays.toString(this.identities) + ", securityProvider='" + this.securityProvider + "']";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GroupSecurityIdentityBuilder that = (GroupSecurityIdentityBuilder)obj;
        return Arrays.equals(this.identities, that.identities) && Objects.equals(this.securityProvider, that.securityProvider);
    }

    public int hashCode() {
        int result = Objects.hash(this.securityProvider);
        result = 31 * result + Arrays.hashCode(this.identities);
        return result;
    }
}

