/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.pushapiclient;

import com.coveo.pushapiclient.CompressionType;
import com.coveo.pushapiclient.Environment;
import com.coveo.pushapiclient.FileContainer;
import com.coveo.pushapiclient.PlatformUrl;
import com.coveo.pushapiclient.PlatformUrlBuilder;
import com.coveo.pushapiclient.PushAPIStatus;
import com.coveo.pushapiclient.SecurityIdentityAliasModel;
import com.coveo.pushapiclient.SecurityIdentityBatchConfig;
import com.coveo.pushapiclient.SecurityIdentityDelete;
import com.coveo.pushapiclient.SecurityIdentityDeleteOptions;
import com.coveo.pushapiclient.SecurityIdentityModel;
import com.coveo.pushapiclient.SourceVisibility;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;

public class PlatformClient {
    private final String apiKey;
    private final String organizationId;
    private final HttpClient httpClient;
    private final PlatformUrl platformUrl;

    public PlatformClient(String apiKey, String organizationId) {
        this(apiKey, organizationId, new PlatformUrlBuilder().build());
    }

    public PlatformClient(String apiKey, String organizationId, PlatformUrl platformUrl) {
        this.apiKey = apiKey;
        this.organizationId = organizationId;
        this.httpClient = HttpClient.newHttpClient();
        this.platformUrl = platformUrl;
    }

    public PlatformClient(String apiKey, String organizationId, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.organizationId = organizationId;
        this.httpClient = httpClient;
        this.platformUrl = new PlatformUrlBuilder().build();
    }

    @Deprecated
    public PlatformClient(String apiKey, String organizationId, Environment environment) {
        this.apiKey = apiKey;
        this.organizationId = organizationId;
        this.httpClient = HttpClient.newHttpClient();
        this.platformUrl = new PlatformUrlBuilder().withEnvironment(environment).build();
    }

    public HttpResponse<String> createSource(final String name, final SourceVisibility sourceVisibility) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        String json = this.toJSON(new HashMap<String, Object>(){
            {
                this.put("sourceType", "PUSH");
                this.put("pushEnabled", true);
                this.put("name", name);
                this.put("sourceVisibility", sourceVisibility);
            }
        });
        HttpRequest request = HttpRequest.newBuilder().headers(headers).POST(HttpRequest.BodyPublishers.ofString(json)).uri(URI.create(this.getBaseSourceURL())).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> createOrUpdateSecurityIdentity(String securityProviderId, SecurityIdentityModel securityIdentityModel) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBaseProviderURL(securityProviderId) + "/permissions");
        String json = new Gson().toJson((Object)securityIdentityModel);
        HttpRequest request = HttpRequest.newBuilder().headers(headers).PUT(HttpRequest.BodyPublishers.ofString(json)).uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> createOrUpdateSecurityIdentityAlias(String securityProviderId, SecurityIdentityAliasModel securityIdentityAlias) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBaseProviderURL(securityProviderId) + "/mappings");
        String json = new Gson().toJson((Object)securityIdentityAlias);
        HttpRequest request = HttpRequest.newBuilder().headers(headers).PUT(HttpRequest.BodyPublishers.ofString(json)).uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> deleteSecurityIdentity(String securityProviderId, SecurityIdentityDelete securityIdentityToDelete) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBaseProviderURL(securityProviderId) + "/permissions");
        String json = new Gson().toJson((Object)securityIdentityToDelete);
        HttpRequest request = HttpRequest.newBuilder().headers(headers).method("DELETE", HttpRequest.BodyPublishers.ofString(json)).uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> deleteOldSecurityIdentities(String securityProviderId, SecurityIdentityDeleteOptions batchDelete) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBaseProviderURL(securityProviderId) + String.format("/permissions/olderthan?queueDelay=%s%s", batchDelete.getQueueDelay(), this.appendOrderingId(batchDelete.getOrderingId())));
        HttpRequest request = HttpRequest.newBuilder().headers(headers).DELETE().uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public String appendOrderingId(long orderingId) {
        if (orderingId > 0L) {
            return String.format("&orderingId=%s", orderingId);
        }
        return "";
    }

    public HttpResponse<String> manageSecurityIdentities(String securityProviderId, SecurityIdentityBatchConfig batchConfig) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBaseProviderURL(securityProviderId) + String.format("/permissions/batch?fileId=%s%s", batchConfig.getFileId(), this.appendOrderingId(batchConfig.getOrderingId())));
        HttpRequest request = HttpRequest.newBuilder().headers(headers).PUT(HttpRequest.BodyPublishers.noBody()).uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> pushDocument(String sourceId, String documentJSON, String documentId, CompressionType compressionType) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBasePushURL() + String.format("/sources/%s/documents?documentId=%s&compressionType=%s", sourceId, documentId, compressionType.toString()));
        HttpRequest request = HttpRequest.newBuilder().headers(headers).PUT(HttpRequest.BodyPublishers.ofString(documentJSON)).uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> deleteDocument(String sourceId, String documentId, Boolean deleteChildren) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBasePushURL() + String.format("/sources/%s/documents?documentId=%s&deleteChildren=%s", sourceId, documentId, deleteChildren));
        HttpRequest request = HttpRequest.newBuilder().headers(headers).DELETE().uri(uri).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> createFileContainer() throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBasePushURL() + "/files");
        HttpRequest request = HttpRequest.newBuilder().headers(headers).uri(uri).POST(HttpRequest.BodyPublishers.ofString("")).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> updateSourceStatus(String sourceId, PushAPIStatus status) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBasePushURL() + String.format("/sources/%s/status?statusType=%s", sourceId, status.toString()));
        HttpRequest request = HttpRequest.newBuilder().headers(headers).uri(uri).POST(HttpRequest.BodyPublishers.ofString("")).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> uploadContentToFileContainer(FileContainer fileContainer, String batchUpdateJson) throws IOException, InterruptedException {
        String[] headers = (String[])fileContainer.requiredHeaders.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).toArray(String[]::new);
        URI uri = URI.create(fileContainer.uploadUri);
        HttpRequest request = HttpRequest.newBuilder().headers(headers).uri(uri).PUT(HttpRequest.BodyPublishers.ofString(batchUpdateJson)).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> pushFileContainerContent(String sourceId, FileContainer fileContainer) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAuthorizationHeader(), this.getContentTypeApplicationJSONHeader());
        URI uri = URI.create(this.getBasePushURL() + String.format("/sources/%s/documents/batch?fileId=%s", sourceId, fileContainer.fileId));
        HttpRequest request = HttpRequest.newBuilder().headers(headers).uri(uri).PUT(HttpRequest.BodyPublishers.ofString("")).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> pushBinaryToFileContainer(FileContainer fileContainer, byte[] fileAsBytes) throws IOException, InterruptedException {
        String[] headers = this.getHeaders(this.getAes256Header(), this.getContentTypeApplicationOctetStreamHeader());
        URI uri = URI.create(fileContainer.uploadUri);
        HttpRequest request = HttpRequest.newBuilder().headers(headers).uri(uri).PUT(HttpRequest.BodyPublishers.ofByteArray(fileAsBytes)).build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private String getBaseSourceURL() {
        return String.format("%s/sources", this.getBasePlatformURL());
    }

    private String getBasePlatformURL() {
        return String.format("%s/rest/organizations/%s", this.platformUrl.getPlatformUrl(), this.organizationId);
    }

    private String getBasePushURL() {
        return String.format("%s/push/v1/organizations/%s", this.platformUrl.getApiUrl(), this.organizationId);
    }

    private String getBaseProviderURL(String providerId) {
        return String.format("%s/providers/%s", this.getBasePushURL(), providerId);
    }

    private String[] getHeaders(String[] ... headers) {
        String[] out = new String[]{};
        for (String[] header : headers) {
            out = (String[])Stream.concat(Arrays.stream(out), Arrays.stream(header)).toArray(String[]::new);
        }
        return out;
    }

    private String[] getAuthorizationHeader() {
        return new String[]{"Authorization", String.format("Bearer %s", this.apiKey)};
    }

    private String[] getContentTypeApplicationJSONHeader() {
        return new String[]{"Content-Type", "application/json", "Accept", "application/json"};
    }

    private String[] getAes256Header() {
        return new String[]{"x-amz-server-side-encryption", "AES256"};
    }

    private String[] getContentTypeApplicationOctetStreamHeader() {
        return new String[]{"Content-Type", "application/octet-stream"};
    }

    private String toJSON(HashMap<String, Object> hashMap) {
        return new Gson().toJson(hashMap, new TypeToken<HashMap<String, Object>>(){}.getType());
    }
}

