/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.pushapiclient;

import com.coveo.pushapiclient.Environment;
import com.coveo.pushapiclient.Region;

public class PlatformUrl {
    public static final Environment DEFAULT_ENVIRONMENT = Environment.PRODUCTION;
    public static final Region DEFAULT_REGION = Region.US;
    private final Environment environment;
    private final Region region;

    public PlatformUrl(Environment environment, Region region) {
        this.environment = environment;
        this.region = region;
    }

    public String getPlatformUrl() {
        return String.format("https://platform%s%s.cloud.coveo.com", this.getUrlEnvironment(), this.getUrlRegion());
    }

    public String getApiUrl() {
        return String.format("https://api%s%s.cloud.coveo.com", this.getUrlEnvironment(), this.getUrlRegion());
    }

    private String getUrlEnvironment() {
        return this.environment == DEFAULT_ENVIRONMENT ? "" : this.environment.getValue();
    }

    private String getUrlRegion() {
        return this.region == DEFAULT_REGION ? "" : String.format("-%s", this.region.getValue());
    }
}

