/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.pushapiclient;

import com.coveo.pushapiclient.BatchIdentity;
import com.coveo.pushapiclient.BatchUpdate;
import com.coveo.pushapiclient.CompressionType;
import com.coveo.pushapiclient.DocumentBuilder;
import com.coveo.pushapiclient.Environment;
import com.coveo.pushapiclient.FileContainer;
import com.coveo.pushapiclient.PlatformClient;
import com.coveo.pushapiclient.PlatformUrl;
import com.coveo.pushapiclient.PushAPIStatus;
import com.coveo.pushapiclient.SecurityIdentityAliasModel;
import com.coveo.pushapiclient.SecurityIdentityBatchConfig;
import com.coveo.pushapiclient.SecurityIdentityBatchResponse;
import com.coveo.pushapiclient.SecurityIdentityDelete;
import com.coveo.pushapiclient.SecurityIdentityDeleteOptions;
import com.coveo.pushapiclient.SecurityIdentityModel;
import com.coveo.pushapiclient.SourceVisibility;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.http.HttpResponse;

public class Source {
    PlatformClient platformClient;

    public Source(String apiKey, String organizationId) {
        this.platformClient = new PlatformClient(apiKey, organizationId);
    }

    public Source(String apiKey, String organizationId, PlatformUrl platformUrl) {
        this.platformClient = new PlatformClient(apiKey, organizationId, platformUrl);
    }

    @Deprecated
    public Source(String apiKey, String organizationId, Environment environment) {
        this.platformClient = new PlatformClient(apiKey, organizationId, environment);
    }

    public HttpResponse<String> create(String name, SourceVisibility sourceVisibility) throws IOException, InterruptedException {
        return this.platformClient.createSource(name, sourceVisibility);
    }

    public HttpResponse<String> createOrUpdateSecurityIdentity(String securityProviderId, SecurityIdentityModel securityIdentityModel) throws IOException, InterruptedException {
        return this.platformClient.createOrUpdateSecurityIdentity(securityProviderId, securityIdentityModel);
    }

    public HttpResponse<String> createOrUpdateSecurityIdentityAlias(String securityProviderId, SecurityIdentityAliasModel securityIdentityAliasModel) throws IOException, InterruptedException {
        return this.platformClient.createOrUpdateSecurityIdentityAlias(securityProviderId, securityIdentityAliasModel);
    }

    public HttpResponse<String> deleteSecurityIdentity(String securityProviderId, SecurityIdentityDelete securityIdentityDelete) throws IOException, InterruptedException {
        return this.platformClient.deleteSecurityIdentity(securityProviderId, securityIdentityDelete);
    }

    public HttpResponse<String> updateSourceStatus(String sourceId, PushAPIStatus status) throws IOException, InterruptedException {
        return this.platformClient.updateSourceStatus(sourceId, status);
    }

    public HttpResponse<String> deleteOldSecurityIdentities(String securityProviderId, SecurityIdentityDeleteOptions batchDelete) throws IOException, InterruptedException {
        return this.platformClient.deleteOldSecurityIdentities(securityProviderId, batchDelete);
    }

    public HttpResponse<String> manageSecurityIdentities(String securityProviderId, SecurityIdentityBatchConfig batchConfig) throws IOException, InterruptedException {
        return this.platformClient.manageSecurityIdentities(securityProviderId, batchConfig);
    }

    public HttpResponse<String> addOrUpdateDocument(String sourceId, DocumentBuilder docBuilder) throws IOException, InterruptedException {
        CompressionType compressionType = docBuilder.getDocument().compressedBinaryData != null ? docBuilder.getDocument().compressedBinaryData.getCompressionType() : CompressionType.UNCOMPRESSED;
        return this.platformClient.pushDocument(sourceId, docBuilder.marshal(), docBuilder.getDocument().uri, compressionType);
    }

    public HttpResponse<String> deleteDocument(String sourceId, String documentId, Boolean deleteChildren) throws IOException, InterruptedException {
        return this.platformClient.deleteDocument(sourceId, documentId, deleteChildren);
    }

    public HttpResponse<String> batchUpdateDocuments(String sourceId, BatchUpdate batchUpdate) throws IOException, InterruptedException {
        HttpResponse<String> resFileContainer = this.platformClient.createFileContainer();
        FileContainer fileContainer = (FileContainer)new Gson().fromJson(resFileContainer.body(), FileContainer.class);
        this.platformClient.uploadContentToFileContainer(fileContainer, new Gson().toJson((Object)batchUpdate.marshal()));
        return this.platformClient.pushFileContainerContent(sourceId, fileContainer);
    }

    public SecurityIdentityBatchResponse batchUpdateSecurityIdentities(String securityProviderId, BatchIdentity batchIdentity) throws IOException, InterruptedException {
        SecurityIdentityBatchResponse securityIdentityBatchResponse = new SecurityIdentityBatchResponse();
        HttpResponse<String> resFileContainer = this.platformClient.createFileContainer();
        FileContainer fileContainer = (FileContainer)new Gson().fromJson(resFileContainer.body(), FileContainer.class);
        String batchIdJson = new Gson().toJson((Object)batchIdentity.marshal());
        securityIdentityBatchResponse.s3Response = this.platformClient.uploadContentToFileContainer(fileContainer, batchIdJson);
        if (securityIdentityBatchResponse.s3Response.statusCode() >= 200 && securityIdentityBatchResponse.s3Response.statusCode() <= 299) {
            SecurityIdentityBatchConfig batchConfig = new SecurityIdentityBatchConfig(fileContainer.fileId, 0L);
            securityIdentityBatchResponse.batchResponse = this.manageSecurityIdentities(securityProviderId, batchConfig);
        }
        return securityIdentityBatchResponse;
    }

    public FileContainer createFileContainer() throws IOException, InterruptedException {
        HttpResponse<String> resFileContainer = this.platformClient.createFileContainer();
        return (FileContainer)new Gson().fromJson(resFileContainer.body(), FileContainer.class);
    }

    public HttpResponse<String> pushBinaryToFileContainer(FileContainer fileContainer, byte[] fileAsBytes) throws IOException, InterruptedException {
        return this.platformClient.pushBinaryToFileContainer(fileContainer, fileAsBytes);
    }
}

