/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.pushapiclient;

import com.coveo.pushapiclient.AnySecurityIdentityBuilder;
import com.coveo.pushapiclient.SecurityIdentity;
import com.coveo.pushapiclient.SecurityIdentityBuilder;
import com.coveo.pushapiclient.SecurityIdentityType;
import java.util.Arrays;
import java.util.Objects;

public class UserSecurityIdentityBuilder
implements SecurityIdentityBuilder {
    private final String[] identities;
    private final String securityProvider;

    public UserSecurityIdentityBuilder(String[] identities, String securityProvider) {
        this.identities = identities;
        this.securityProvider = securityProvider;
    }

    public UserSecurityIdentityBuilder(String identity, String securityProvider) {
        this(new String[]{identity}, securityProvider);
    }

    public UserSecurityIdentityBuilder(String identity) {
        this(new String[]{identity}, "Email Security Provider");
    }

    public UserSecurityIdentityBuilder(String[] identities) {
        this(identities, "Email Security Provider");
    }

    @Override
    public SecurityIdentity[] build() {
        return new AnySecurityIdentityBuilder(this.identities, SecurityIdentityType.USER, this.securityProvider).build();
    }

    public String[] getIdentities() {
        return this.identities;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public String toString() {
        return "UserSecurityIdentityBuilder[identities=" + Arrays.toString(this.identities) + ", securityProvider='" + this.securityProvider + "']";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserSecurityIdentityBuilder that = (UserSecurityIdentityBuilder)obj;
        return Arrays.equals(this.identities, that.identities) && Objects.equals(this.securityProvider, that.securityProvider);
    }

    public int hashCode() {
        int result = Objects.hash(this.securityProvider);
        result = 31 * result + Arrays.hashCode(this.identities);
        return result;
    }
}

