/*
 * Decompiled with CFR 0.152.
 */
package cats.syntax;

import cats.Alternative;
import cats.Applicative;
import cats.ApplicativeError;
import cats.Eval;
import cats.Now;
import cats.Show;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.EitherT$FromEitherPartiallyApplied$;
import cats.data.Ior;
import cats.data.Ior$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.kernel.Semigroup;
import cats.syntax.EitherOps;
import cats.syntax.EitherUtil$;
import java.io.Serializable;
import scala.$less$colon$less;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class EitherOps$ {
    public static final EitherOps$ MODULE$ = new EitherOps$();

    public final <A, B> void foreach$extension(Either<A, B> $this, Function1<B, BoxedUnit> f) {
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            BoxedUnit boxedUnit = f.apply(b);
        } else {
            throw new MatchError(either2);
        }
    }

    public final <BB, A, B> BB getOrElse$extension(Either<A, B> $this, Function0<BB> function0) {
        Object object;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            object = function0.apply();
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            object = b;
        } else {
            throw new MatchError(either2);
        }
        return object;
    }

    public final <C, BB, A, B> Either<C, BB> orElse$extension(Either<A, B> $this, Function0<Either<C, BB>> fallback) {
        Either<C, Object> either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            either2 = fallback.apply();
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            either2 = EitherUtil$.MODULE$.leftCast(right);
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <BB, A, B> Either<A, BB> recover$extension(Either<A, B> $this, PartialFunction<A, BB> pf) {
        Left left;
        Object a;
        Either either2 = $this;
        Either either3 = either2 instanceof Left && pf.isDefinedAt(a = (left = (Left)either2).value()) ? package$.MODULE$.Right().apply(pf.apply(a)) : $this;
        return either3;
    }

    public final <AA, BB, A, B> Either<AA, BB> recoverWith$extension(Either<A, B> $this, PartialFunction<A, Either<AA, BB>> pf) {
        Left left;
        Object a;
        Either either2 = $this;
        Either either3 = either2 instanceof Left && pf.isDefinedAt(a = (left = (Left)either2).value()) ? (Either)pf.apply(a) : $this;
        return either3;
    }

    public final <BB, A, B> BB valueOr$extension(Either<A, B> $this, Function1<A, BB> f) {
        Object object;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Object a = left.value();
            object = f.apply(a);
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            object = b;
        } else {
            throw new MatchError(either2);
        }
        return object;
    }

    public final <A, B> boolean forall$extension(Either<A, B> $this, Function1<B, Object> f) {
        boolean bl;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            bl = true;
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            bl = BoxesRunTime.unboxToBoolean(f.apply(b));
        } else {
            throw new MatchError(either2);
        }
        return bl;
    }

    public final <A, B> boolean exists$extension(Either<A, B> $this, Function1<B, Object> f) {
        boolean bl;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            bl = false;
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            bl = BoxesRunTime.unboxToBoolean(f.apply(b));
        } else {
            throw new MatchError(either2);
        }
        return bl;
    }

    public final <AA, A, B> Either<AA, B> ensure$extension(Either<A, B> $this, Function0<AA> onFailure, Function1<B, Object> f) {
        Either<A, B> either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            either2 = $this;
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            Object b = right.value();
            either2 = BoxesRunTime.unboxToBoolean(f.apply(b)) ? $this : package$.MODULE$.Left().apply(onFailure.apply());
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <AA, A, B> Either<AA, B> ensureOr$extension(Either<A, B> $this, Function1<B, AA> onFailure, Function1<B, Object> f) {
        Either<A, B> either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            either2 = $this;
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            Object b = right.value();
            either2 = BoxesRunTime.unboxToBoolean(f.apply(b)) ? $this : package$.MODULE$.Left().apply(onFailure.apply(b));
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <A, B> Ior<A, B> toIor$extension(Either<A, B> $this) {
        return Ior$.MODULE$.fromEither($this);
    }

    public final <A, B> Option<B> toOption$extension(Either<A, B> $this) {
        Option option2;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            option2 = None$.MODULE$;
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            option2 = new Some(b);
        } else {
            throw new MatchError(either2);
        }
        return option2;
    }

    public final <A, B> List<B> toList$extension(Either<A, B> $this) {
        List list2;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            list2 = package$.MODULE$.Nil();
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            list2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{b}));
        } else {
            throw new MatchError(either2);
        }
        return list2;
    }

    public final <A, B> Try<B> toTry$extension(Either<A, B> $this, $less$colon$less<A, Throwable> ev) {
        Try try_;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Object a = left.value();
            try_ = new Failure(ev.apply((A)a));
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            try_ = new Success(b);
        } else {
            throw new MatchError(either2);
        }
        return try_;
    }

    public final <A, B> Validated<A, B> toValidated$extension(Either<A, B> $this) {
        Validated<Object, Object> validated;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Object a = left.value();
            validated = Validated$.MODULE$.invalid(a);
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            validated = Validated$.MODULE$.valid(b);
        } else {
            throw new MatchError(either2);
        }
        return validated;
    }

    public final <AA, A, B> Validated<NonEmptyList<AA>, B> toValidatedNel$extension(Either<A, B> $this) {
        Validated<NonEmptyList<Object>, Object> validated;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Object a = left.value();
            validated = Validated$.MODULE$.invalidNel(a);
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            validated = Validated$.MODULE$.valid(b);
        } else {
            throw new MatchError(either2);
        }
        return validated;
    }

    public final <AA, BB, A, B> Either<AA, BB> withValidated$extension(Either<A, B> $this, Function1<Validated<A, B>, Validated<AA, BB>> f) {
        return f.apply(this.toValidated$extension($this)).toEither();
    }

    public final <F, A, B> F to$extension(Either<A, B> $this, Alternative<F> F) {
        Object f;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            f = F.empty();
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            f = F.pure(b);
        } else {
            throw new MatchError(either2);
        }
        return f;
    }

    public final <C, D, A, B> Either<C, D> bimap$extension(Either<A, B> $this, Function1<A, C> fa, Function1<B, D> fb) {
        Either either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            Object a = left.value();
            either2 = package$.MODULE$.Left().apply(fa.apply(a));
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            Object b = right.value();
            either2 = package$.MODULE$.Right().apply(fb.apply(b));
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <C, A, B> Either<A, C> map$extension(Either<A, B> $this, Function1<B, C> f) {
        Either either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            either2 = EitherUtil$.MODULE$.rightCast(left);
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            Object b = right.value();
            either2 = package$.MODULE$.Right().apply(f.apply(b));
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <AA, C, Z, A, B> Eval<Either<AA, Z>> map2Eval$extension(Either<A, B> $this, Eval<Either<AA, C>> fc, Function2<B, C, Z> f) {
        Eval eval;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            eval = new Now<Either<AA, Z>>(EitherUtil$.MODULE$.rightCast(left));
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            eval = fc.map((Function1<Either, Either> & Serializable)x$1 -> x$1.map((Function1<Object, Object> & Serializable)x$2 -> f.apply(b, x$2)));
        } else {
            throw new MatchError(either2);
        }
        return eval;
    }

    public final <C, A, B> Either<C, B> leftMap$extension(Either<A, B> $this, Function1<A, C> f) {
        Either either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            Object a = left.value();
            either2 = package$.MODULE$.Left().apply(f.apply(a));
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            either2 = EitherUtil$.MODULE$.leftCast(right);
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <AA, D, A, B> Either<AA, D> flatMap$extension(Either<A, B> $this, Function1<B, Either<AA, D>> f) {
        Either<Object, Object> either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            either2 = EitherUtil$.MODULE$.rightCast(left);
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            Object b = right.value();
            either2 = f.apply(b);
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <C, BB, A, B> Either<C, BB> leftFlatMap$extension(Either<A, B> $this, Function1<A, Either<C, BB>> f) {
        Either<C, Object> either2;
        Either<A, B> either3 = $this;
        if (either3 instanceof Left) {
            Left left = (Left)either3;
            Object a = left.value();
            either2 = f.apply(a);
        } else if (either3 instanceof Right) {
            Right right = (Right)either3;
            either2 = EitherUtil$.MODULE$.leftCast(right);
        } else {
            throw new MatchError(either3);
        }
        return either2;
    }

    public final <AA, BB, A, B> int compare$extension(Either<A, B> $this, Either<AA, BB> that, Order<AA> AA, Order<BB> BB) {
        int n;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            int n2;
            Left left = (Left)either2;
            Object a1 = left.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                Left left2 = (Left)either3;
                Object a2 = left2.value();
                n2 = AA.compare(a1, a2);
            } else if (either3 instanceof Right) {
                n2 = -1;
            } else {
                throw new MatchError(either3);
            }
            n = n2;
        } else if (either2 instanceof Right) {
            int n3;
            Right right = (Right)either2;
            Object b1 = right.value();
            Either<AA, BB> either4 = that;
            if (either4 instanceof Left) {
                n3 = 1;
            } else if (either4 instanceof Right) {
                Right right2 = (Right)either4;
                Object b2 = right2.value();
                n3 = BB.compare(b1, b2);
            } else {
                throw new MatchError(either4);
            }
            n = n3;
        } else {
            throw new MatchError(either2);
        }
        return n;
    }

    public final <AA, BB, A, B> double partialCompare$extension(Either<A, B> $this, Either<AA, BB> that, PartialOrder<AA> AA, PartialOrder<BB> BB) {
        double d;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            double d2;
            Left left = (Left)either2;
            Object a1 = left.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                Left left2 = (Left)either3;
                Object a2 = left2.value();
                d2 = AA.partialCompare(a1, a2);
            } else if (either3 instanceof Right) {
                d2 = -1.0;
            } else {
                throw new MatchError(either3);
            }
            d = d2;
        } else if (either2 instanceof Right) {
            double d3;
            Right right = (Right)either2;
            Object b1 = right.value();
            Either<AA, BB> either4 = that;
            if (either4 instanceof Left) {
                d3 = 1.0;
            } else if (either4 instanceof Right) {
                Right right2 = (Right)either4;
                Object b2 = right2.value();
                d3 = BB.partialCompare(b1, b2);
            } else {
                throw new MatchError(either4);
            }
            d = d3;
        } else {
            throw new MatchError(either2);
        }
        return d;
    }

    public final <AA, BB, A, B> boolean $eq$eq$eq$extension(Either<A, B> $this, Either<AA, BB> that, Eq<AA> AA, Eq<BB> BB) {
        boolean bl;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            boolean bl2;
            Left left = (Left)either2;
            Object a1 = left.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                Left left2 = (Left)either3;
                Object a2 = left2.value();
                bl2 = AA.eqv(a1, a2);
            } else if (either3 instanceof Right) {
                bl2 = false;
            } else {
                throw new MatchError(either3);
            }
            bl = bl2;
        } else if (either2 instanceof Right) {
            boolean bl3;
            Right right = (Right)either2;
            Object b1 = right.value();
            Either<AA, BB> either4 = that;
            if (either4 instanceof Left) {
                bl3 = false;
            } else if (either4 instanceof Right) {
                Right right2 = (Right)either4;
                Object b2 = right2.value();
                bl3 = BB.eqv(b1, b2);
            } else {
                throw new MatchError(either4);
            }
            bl = bl3;
        } else {
            throw new MatchError(either2);
        }
        return bl;
    }

    public final <F, AA, D, A, B> F traverse$extension(Either<A, B> $this, Function1<B, F> f, Applicative<F> F) {
        F f2;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            f2 = F.pure(EitherUtil$.MODULE$.rightCast(left));
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            f2 = F.map(f.apply(b), (Function1<Object, Right> & Serializable)x$3 -> package$.MODULE$.Right().apply(x$3));
        } else {
            throw new MatchError(either2);
        }
        return f2;
    }

    public final <C, A, B> C foldLeft$extension(Either<A, B> $this, C c, Function2<C, B, C> f) {
        C c2;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            c2 = c;
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            c2 = f.apply(c, b);
        } else {
            throw new MatchError(either2);
        }
        return c2;
    }

    public final <C, A, B> Eval<C> foldRight$extension(Either<A, B> $this, Eval<C> lc, Function2<B, Eval<C>, Eval<C>> f) {
        Eval<C> eval;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            eval = lc;
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            eval = f.apply(b, lc);
        } else {
            throw new MatchError(either2);
        }
        return eval;
    }

    public final <AA, BB, A, B> Either<AA, BB> combine$extension(Either<A, B> $this, Either<AA, BB> that, Semigroup<BB> BB) {
        Left left;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left2;
            left = left2 = (Left)either2;
        } else if (either2 instanceof Right) {
            Either either3;
            Right right = (Right)either2;
            Object b1 = right.value();
            Either<AA, BB> either4 = that;
            if (either4 instanceof Left) {
                Left left3;
                either3 = left3 = (Left)either4;
            } else if (either4 instanceof Right) {
                Right right2 = (Right)either4;
                Object b2 = right2.value();
                either3 = package$.MODULE$.Right().apply(BB.combine(b1, b2));
            } else {
                throw new MatchError(either4);
            }
            left = either3;
        } else {
            throw new MatchError(either2);
        }
        return left;
    }

    public final <AA, BB, A, B> String show$extension(Either<A, B> $this, Show<AA> AA, Show<BB> BB) {
        String string2;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Object a = left.value();
            string2 = new StringBuilder(6).append("Left(").append(AA.show(a)).append(")").toString();
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            string2 = new StringBuilder(7).append("Right(").append(BB.show(b)).append(")").toString();
        } else {
            throw new MatchError(either2);
        }
        return string2;
    }

    public final <AA, BB, C, A, B> Either<AA, C> ap$extension(Either<A, B> $this, Either<AA, Function1<BB, C>> that) {
        return that.flatMap((Function1<Function1, Either> & Serializable)f -> $this.map(f));
    }

    public final <F, A, B> EitherT<F, A, B> toEitherT$extension(Either<A, B> $this, Applicative<F> evidence$1) {
        return EitherT$FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), $this, evidence$1);
    }

    public final <AA, A, B> Either<Object, B> toEitherNec$extension(Either<A, B> $this) {
        return this.leftMap$extension($this, (Function1<Object, Object> & Serializable)a -> cats.data.package$.MODULE$.NonEmptyChain().one(a));
    }

    public final <AA, A, B> Either<Object, B> toEitherNes$extension(Either<A, B> $this, Order<AA> O2) {
        return this.leftMap$extension($this, (Function1<Object, Object> & Serializable)x$4 -> cats.data.package$.MODULE$.NonEmptySet().one(x$4, O2));
    }

    public final <AA, A, B> Either<NonEmptyList<AA>, B> toEitherNel$extension(Either<A, B> $this) {
        return this.leftMap$extension($this, (Function1<Object, NonEmptyList> & Serializable)head -> NonEmptyList$.MODULE$.one(head));
    }

    public final <F, A, B> F raiseOrPure$extension(Either<A, B> $this, ApplicativeError<F, A> ev) {
        return ev.fromEither($this);
    }

    public final <F, A, B> F liftTo$extension(Either<A, B> $this, ApplicativeError<F, ? super A> F) {
        return F.fromEither($this);
    }

    public final <A, B> int hashCode$extension(Either<A, B> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A, B> boolean equals$extension(Either<A, B> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof EitherOps)) return false;
        boolean bl = true;
        if (!bl) return false;
        Either either2 = x$1 == null ? null : ((EitherOps)x$1).cats$syntax$EitherOps$$eab();
        Either<A, B> either3 = $this;
        Either either4 = either2;
        if (either3 != null) {
            if (!either3.equals(either4)) return false;
            return true;
        }
        if (either4 == null) return true;
        return false;
    }

    private EitherOps$() {
    }
}

