/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.javaapi.data.codegen.HasCommands;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CommandsSubmission {
    private String applicationId;
    private String commandId;
    private List<@NonNull ? extends HasCommands> commands;
    private Optional<String> workflowId;
    private List<@NonNull String> actAs;
    private List<@NonNull String> readAs;
    private Optional<Instant> minLedgerTimeAbs;
    private Optional<Duration> minLedgerTimeRel;
    private Optional<Duration> deduplicationTime;
    private Optional<String> accessToken;

    protected CommandsSubmission(String applicationId, String commandId, List<@NonNull ? extends HasCommands> commands, List<@NonNull String> actAs, List<@NonNull String> readAs, Optional<String> workflowId, Optional<Instant> minLedgerTimeAbs, Optional<Duration> minLedgerTimeRel, Optional<Duration> deduplicationTime, Optional<String> accessToken) {
        this.workflowId = workflowId;
        this.applicationId = applicationId;
        this.commandId = commandId;
        this.actAs = actAs;
        this.readAs = readAs;
        this.minLedgerTimeAbs = minLedgerTimeAbs;
        this.minLedgerTimeRel = minLedgerTimeRel;
        this.deduplicationTime = deduplicationTime;
        this.commands = commands;
        this.accessToken = accessToken;
    }

    public static CommandsSubmission create(String applicationId, String commandId, List<@NonNull ? extends HasCommands> commands) {
        return new CommandsSubmission(applicationId, commandId, commands, Collections.emptyList(), Collections.emptyList(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Optional<String> getWorkflowId() {
        return this.workflowId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public List<String> getActAs() {
        return Collections.unmodifiableList(this.actAs);
    }

    public List<String> getReadAs() {
        return Collections.unmodifiableList(this.readAs);
    }

    public Optional<Instant> getMinLedgerTimeAbs() {
        return this.minLedgerTimeAbs;
    }

    public Optional<Duration> getMinLedgerTimeRel() {
        return this.minLedgerTimeRel;
    }

    public Optional<Duration> getDeduplicationTime() {
        return this.deduplicationTime;
    }

    public List<? extends HasCommands> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public Optional<String> getAccessToken() {
        return this.accessToken;
    }

    public CommandsSubmission withWorkflowId(String workflowId) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, this.actAs, this.readAs, Optional.of(workflowId), this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withActAs(String actAs) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, List.of(actAs), this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withActAs(List<@NonNull String> actAs) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withReadAs(List<@NonNull String> readAs) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, this.actAs, readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withMinLedgerTimeAbs(Optional<Instant> minLedgerTimeAbs) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, this.actAs, this.readAs, this.workflowId, minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withMinLedgerTimeRel(Optional<Duration> minLedgerTimeRel) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withDeduplicationTime(Optional<Duration> deduplicationTime) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withCommands(List<@NonNull ? extends HasCommands> commands) {
        return new CommandsSubmission(this.applicationId, this.commandId, commands, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, this.accessToken);
    }

    public CommandsSubmission withAccessToken(Optional<String> accessToken) {
        return new CommandsSubmission(this.applicationId, this.commandId, this.commands, this.actAs, this.readAs, this.workflowId, this.minLedgerTimeAbs, this.minLedgerTimeRel, this.deduplicationTime, accessToken);
    }
}

