/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandCompletionServiceOuterClass;
import com.daml.ledger.javaapi.data.LedgerOffset;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class CompletionStreamRequest {
    private final String ledgerId;
    private final String applicationId;
    private final Set<String> parties;
    private final Optional<LedgerOffset> offset;

    public static CompletionStreamRequest fromProto(CommandCompletionServiceOuterClass.CompletionStreamRequest request) {
        String ledgerId = request.getLedgerId();
        String applicationId = request.getApplicationId();
        HashSet<String> parties = new HashSet<String>(request.getPartiesList());
        LedgerOffset offset = LedgerOffset.fromProto(request.getOffset());
        return new CompletionStreamRequest(ledgerId, applicationId, parties, offset);
    }

    public CommandCompletionServiceOuterClass.CompletionStreamRequest toProto() {
        CommandCompletionServiceOuterClass.CompletionStreamRequest.Builder protoBuilder = CommandCompletionServiceOuterClass.CompletionStreamRequest.newBuilder().setLedgerId(this.ledgerId).setApplicationId(this.applicationId).addAllParties(this.parties);
        this.offset.ifPresent(offset -> protoBuilder.setOffset(offset.toProto()));
        return protoBuilder.build();
    }

    public String toString() {
        return "CompletionStreamRequest{ledgerId='" + this.ledgerId + "', applicationId='" + this.applicationId + "', parties=" + this.parties + ", offset=" + this.offset + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionStreamRequest that = (CompletionStreamRequest)o;
        return Objects.equals(this.ledgerId, that.ledgerId) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.parties, that.parties) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.ledgerId, this.applicationId, this.parties, this.offset);
    }

    public String getLedgerId() {
        return this.ledgerId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Set<String> getParties() {
        return this.parties;
    }

    @Deprecated
    public LedgerOffset getOffset() {
        return this.offset.orElse(null);
    }

    public Optional<LedgerOffset> getLedgerOffset() {
        return this.offset;
    }

    public CompletionStreamRequest(String ledgerId, String applicationId, Set<String> parties) {
        this.ledgerId = ledgerId;
        this.applicationId = applicationId;
        this.parties = parties;
        this.offset = Optional.empty();
    }

    public CompletionStreamRequest(String ledgerId, String applicationId, Set<String> parties, LedgerOffset offset) {
        this.ledgerId = ledgerId;
        this.applicationId = applicationId;
        this.parties = parties;
        this.offset = Optional.of(offset);
    }
}

