/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.EventOuterClass;
import com.daml.ledger.javaapi.data.ContractMetadata;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.TreeEvent;
import com.daml.ledger.javaapi.data.Value;
import com.google.protobuf.Any;
import com.google.protobuf.StringValue;
import com.google.rpc.Status;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CreatedEvent
implements Event,
TreeEvent {
    private final @NonNull List<@NonNull String> witnessParties;
    private final String eventId;
    private final Identifier templateId;
    private final String contractId;
    private final DamlRecord arguments;
    private final @NonNull Any createArgumentsBlob;
    private final @NonNull ContractMetadata contractMetadata;
    private final @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> interfaceViews;
    private final @NonNull Map<@NonNull Identifier, @NonNull Status> failedInterfaceViews;
    private final Optional<String> agreementText;
    private final Optional<Value> contractKey;
    private final @NonNull Set<@NonNull String> signatories;
    private final @NonNull Set<@NonNull String> observers;

    public CreatedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull String eventId, @NonNull Identifier templateId, @NonNull String contractId, @NonNull DamlRecord arguments, @NonNull Any createArgumentsBlob, @NonNull ContractMetadata contractMetadata, @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> interfaceViews, @NonNull Map<@NonNull Identifier, @NonNull Status> failedInterfaceViews, @NonNull Optional<String> agreementText, @NonNull Optional<Value> contractKey, @NonNull Collection<@NonNull String> signatories, @NonNull Collection<@NonNull String> observers) {
        this.witnessParties = List.copyOf(witnessParties);
        this.eventId = eventId;
        this.templateId = templateId;
        this.contractId = contractId;
        this.arguments = arguments;
        this.createArgumentsBlob = createArgumentsBlob;
        this.contractMetadata = contractMetadata;
        this.interfaceViews = Map.copyOf(interfaceViews);
        this.failedInterfaceViews = Map.copyOf(failedInterfaceViews);
        this.agreementText = agreementText;
        this.contractKey = contractKey;
        this.signatories = Set.copyOf(signatories);
        this.observers = Set.copyOf(observers);
    }

    @Deprecated
    public CreatedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull String eventId, @NonNull Identifier templateId, @NonNull String contractId, @NonNull DamlRecord arguments, @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> interfaceViews, @NonNull Map<@NonNull Identifier, @NonNull Status> failedInterfaceViews, @NonNull Optional<String> agreementText, @NonNull Optional<Value> contractKey, @NonNull Collection<@NonNull String> signatories, @NonNull Collection<@NonNull String> observers) {
        this(witnessParties, eventId, templateId, contractId, arguments, Any.getDefaultInstance(), ContractMetadata.Empty(), interfaceViews, failedInterfaceViews, agreementText, contractKey, signatories, observers);
    }

    @Deprecated
    public CreatedEvent(@NonNull List<@NonNull String> witnessParties, @NonNull String eventId, @NonNull Identifier templateId, @NonNull String contractId, @NonNull DamlRecord arguments, @NonNull Optional<String> agreementText, @NonNull Optional<Value> contractKey, @NonNull Collection<@NonNull String> signatories, @NonNull Collection<@NonNull String> observers) {
        this(witnessParties, eventId, templateId, contractId, arguments, Any.getDefaultInstance(), ContractMetadata.Empty(), Collections.emptyMap(), Collections.emptyMap(), agreementText, contractKey, signatories, observers);
    }

    @Override
    public @NonNull List<@NonNull String> getWitnessParties() {
        return this.witnessParties;
    }

    @Override
    public @NonNull String getEventId() {
        return this.eventId;
    }

    @Override
    public @NonNull Identifier getTemplateId() {
        return this.templateId;
    }

    @Override
    public @NonNull String getContractId() {
        return this.contractId;
    }

    public @NonNull DamlRecord getArguments() {
        return this.arguments;
    }

    public Any getCreateArgumentsBlob() {
        return this.createArgumentsBlob;
    }

    public ContractMetadata getContractMetadata() {
        return this.contractMetadata;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull DamlRecord> getInterfaceViews() {
        return this.interfaceViews;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Status> getFailedInterfaceViews() {
        return this.failedInterfaceViews;
    }

    public @NonNull Optional<String> getAgreementText() {
        return this.agreementText;
    }

    public @NonNull Optional<Value> getContractKey() {
        return this.contractKey;
    }

    public @NonNull Set<@NonNull String> getSignatories() {
        return this.signatories;
    }

    public @NonNull Set<@NonNull String> getObservers() {
        return this.observers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatedEvent that = (CreatedEvent)o;
        return Objects.equals(this.witnessParties, that.witnessParties) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.templateId, that.templateId) && Objects.equals(this.contractId, that.contractId) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.createArgumentsBlob, that.createArgumentsBlob) && Objects.equals(this.contractMetadata, that.contractMetadata) && Objects.equals(this.interfaceViews, that.interfaceViews) && Objects.equals(this.failedInterfaceViews, that.failedInterfaceViews) && Objects.equals(this.agreementText, that.agreementText) && Objects.equals(this.contractKey, that.contractKey) && Objects.equals(this.signatories, that.signatories) && Objects.equals(this.observers, that.observers);
    }

    public int hashCode() {
        return Objects.hash(this.witnessParties, this.eventId, this.templateId, this.contractId, this.arguments, this.createArgumentsBlob, this.contractMetadata, this.interfaceViews, this.failedInterfaceViews, this.agreementText, this.contractKey, this.signatories, this.observers);
    }

    public String toString() {
        return "CreatedEvent{witnessParties=" + this.witnessParties + ", eventId='" + this.eventId + "', templateId=" + this.templateId + ", contractId='" + this.contractId + "', arguments=" + this.arguments + ", createArgumentsBlob=" + this.createArgumentsBlob + ", contractMetadata=" + this.contractMetadata + ", interfaceViews=" + this.interfaceViews + ", failedInterfaceViews=" + this.failedInterfaceViews + ", agreementText='" + this.agreementText + "', contractKey=" + this.contractKey + ", signatories=" + this.signatories + ", observers=" + this.observers + "}";
    }

    public  @NonNull EventOuterClass.CreatedEvent toProto() {
        EventOuterClass.CreatedEvent.Builder builder = EventOuterClass.CreatedEvent.newBuilder().setContractId(this.getContractId()).setCreateArguments(this.getArguments().toProtoRecord()).setCreateArgumentsBlob(this.createArgumentsBlob).setMetadata(this.contractMetadata.toProto()).addAllInterfaceViews(Stream.concat(CreatedEvent.toProtoInterfaceViews(this.interfaceViews, (b, dr) -> b.setViewValue(dr.toProtoRecord())), CreatedEvent.toProtoInterfaceViews(this.failedInterfaceViews, (b, status) -> b.setViewStatus((Status)status))).collect(Collectors.toUnmodifiableList())).setEventId(this.getEventId()).setTemplateId(this.getTemplateId().toProto()).addAllWitnessParties(this.getWitnessParties()).addAllSignatories(this.getSignatories()).addAllObservers(this.getObservers());
        this.agreementText.ifPresent(a -> builder.setAgreementText(StringValue.of(a)));
        this.contractKey.ifPresent(a -> builder.setContractKey(a.toProto()));
        return builder.build();
    }

    private static <V> Stream<EventOuterClass.InterfaceView> toProtoInterfaceViews(Map<Identifier, V> views, BiFunction<EventOuterClass.InterfaceView.Builder, V, EventOuterClass.InterfaceView.Builder> addV) {
        return views.entrySet().stream().map(e -> ((EventOuterClass.InterfaceView.Builder)addV.apply(EventOuterClass.InterfaceView.newBuilder().setInterfaceId(((Identifier)e.getKey()).toProto()), e.getValue())).build());
    }

    public static CreatedEvent fromProto(EventOuterClass.CreatedEvent createdEvent) {
        Map<Boolean, List<EventOuterClass.InterfaceView>> splitInterfaceViews = createdEvent.getInterfaceViewsList().stream().collect(Collectors.partitioningBy(EventOuterClass.InterfaceView::hasViewValue));
        return new CreatedEvent(createdEvent.getWitnessPartiesList(), createdEvent.getEventId(), Identifier.fromProto(createdEvent.getTemplateId()), createdEvent.getContractId(), DamlRecord.fromProto(createdEvent.getCreateArguments()), createdEvent.getCreateArgumentsBlob(), ContractMetadata.fromProto(createdEvent.getMetadata()), splitInterfaceViews.get(true).stream().collect(Collectors.toUnmodifiableMap(iv -> Identifier.fromProto(iv.getInterfaceId()), iv -> DamlRecord.fromProto(iv.getViewValue()))), splitInterfaceViews.get(false).stream().collect(Collectors.toUnmodifiableMap(iv -> Identifier.fromProto(iv.getInterfaceId()), EventOuterClass.InterfaceView::getViewStatus)), createdEvent.hasAgreementText() ? Optional.of(createdEvent.getAgreementText().getValue()) : Optional.empty(), createdEvent.hasContractKey() ? Optional.of(Value.fromProto(createdEvent.getContractKey())) : Optional.empty(), createdEvent.getSignatoriesList(), createdEvent.getObserversList());
    }
}

