/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionFilterOuterClass;
import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Filter;
import com.daml.ledger.javaapi.data.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class InclusiveFilter
extends Filter {
    private Set<Identifier> templateIds;
    private Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceIds;

    @Deprecated
    public InclusiveFilter(@NonNull Set<@NonNull Identifier> templateIds) {
        this(templateIds, Collections.emptyMap());
    }

    public InclusiveFilter(@NonNull Set<@NonNull Identifier> templateIds, @NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> interfaceIds) {
        this.templateIds = templateIds;
        this.interfaceIds = interfaceIds;
    }

    public static InclusiveFilter ofTemplateIds(@NonNull Set<@NonNull Identifier> templateIds) {
        return new InclusiveFilter(templateIds, Collections.emptyMap());
    }

    public @NonNull Set<@NonNull Identifier> getTemplateIds() {
        return this.templateIds;
    }

    public @NonNull Map<@NonNull Identifier, @NonNull Filter.Interface> getInterfaceIds() {
        return this.interfaceIds;
    }

    @Override
    public TransactionFilterOuterClass.Filters toProto() {
        ArrayList<ValueOuterClass.Identifier> templateIds = new ArrayList<ValueOuterClass.Identifier>(this.templateIds.size());
        for (Identifier identifier : this.templateIds) {
            templateIds.add(identifier.toProto());
        }
        TransactionFilterOuterClass.InclusiveFilters inclusiveFilter = TransactionFilterOuterClass.InclusiveFilters.newBuilder().addAllTemplateIds(templateIds).addAllInterfaceFilters(this.interfaceIds.entrySet().stream().map(idFilt -> ((Filter.Interface)idFilt.getValue()).toProto((Identifier)idFilt.getKey())).collect(Collectors.toUnmodifiableList())).build();
        return TransactionFilterOuterClass.Filters.newBuilder().setInclusive(inclusiveFilter).build();
    }

    public static InclusiveFilter fromProto(TransactionFilterOuterClass.InclusiveFilters inclusiveFilters) {
        HashSet<Identifier> templateIds = new HashSet<Identifier>(inclusiveFilters.getTemplateIdsCount());
        for (ValueOuterClass.Identifier templateId : inclusiveFilters.getTemplateIdsList()) {
            templateIds.add(Identifier.fromProto(templateId));
        }
        Map<Identifier, Filter.Interface> interfaceIds = inclusiveFilters.getInterfaceFiltersList().stream().collect(Collectors.toUnmodifiableMap(ifFilt -> Identifier.fromProto(ifFilt.getInterfaceId()), Filter.Interface::fromProto, Filter.Interface::merge));
        return new InclusiveFilter(templateIds, interfaceIds);
    }

    public String toString() {
        return "InclusiveFilter{templateIds=" + this.templateIds + ", interfaceIds=" + this.interfaceIds + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusiveFilter that = (InclusiveFilter)o;
        return Objects.equals(this.templateIds, that.templateIds) && Objects.equals(this.interfaceIds, that.interfaceIds);
    }

    public int hashCode() {
        return Objects.hash(this.templateIds, this.interfaceIds);
    }
}

