/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import com.daml.ledger.javaapi.data.Value;
import java.math.BigDecimal;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Numeric
extends Value {
    private final BigDecimal value;

    public Numeric(@NonNull BigDecimal value) {
        this.value = value;
    }

    public static Numeric fromProto(String numeric) {
        return new Numeric(new BigDecimal(numeric));
    }

    @Override
    public ValueOuterClass.Value toProto() {
        return ValueOuterClass.Value.newBuilder().setNumeric(this.value.toPlainString()).build();
    }

    public @NonNull BigDecimal getValue() {
        return this.value;
    }

    public String toString() {
        return "Numeric{value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Numeric numeric = (Numeric)o;
        return Objects.equals(this.value, numeric.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

