/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.CommandsSubmission;
import com.daml.ledger.javaapi.data.codegen.HasCommands;
import com.google.protobuf.Duration;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SubmitCommandsRequest {
    private final String workflowId;
    private final String applicationId;
    private final String commandId;
    private final String party;
    private final List<String> actAs;
    private final List<String> readAs;
    private final Optional<Instant> minLedgerTimeAbsolute;
    private final Optional<java.time.Duration> minLedgerTimeRelative;
    private final Optional<java.time.Duration> deduplicationTime;
    private final Optional<String> submissionId;
    private final List<Command> commands;

    public SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        this(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, commands);
    }

    public SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String submissionId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        this(workflowId, applicationId, commandId, Arrays.asList(party), Arrays.asList(new String[0]), minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.of(submissionId), commands);
    }

    public SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        this(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.empty(), commands);
    }

    public SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String submissionId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        this(workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.of(submissionId), commands);
    }

    private SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull Optional<String> submissionId, @NonNull List<@NonNull Command> commands) {
        if (actAs.size() == 0) {
            throw new IllegalArgumentException("actAs must have at least one element");
        }
        this.workflowId = workflowId;
        this.applicationId = applicationId;
        this.commandId = commandId;
        this.party = actAs.get(0);
        this.actAs = List.copyOf(actAs);
        this.readAs = List.copyOf(readAs);
        this.minLedgerTimeAbsolute = minLedgerTimeAbsolute;
        this.minLedgerTimeRelative = minLedgerTimeRelative;
        this.deduplicationTime = deduplicationTime;
        this.submissionId = submissionId;
        this.commands = commands;
    }

    public static SubmitCommandsRequest fromProto(CommandsOuterClass.Commands commands) {
        String workflowId = commands.getWorkflowId();
        String applicationId = commands.getApplicationId();
        String commandId = commands.getCommandId();
        String party = commands.getParty();
        ProtocolStringList actAs = commands.getActAsList();
        ProtocolStringList readAs = commands.getReadAsList();
        Optional<Instant> minLedgerTimeAbs = commands.hasMinLedgerTimeAbs() ? Optional.of(Instant.ofEpochSecond(commands.getMinLedgerTimeAbs().getSeconds(), commands.getMinLedgerTimeAbs().getNanos())) : Optional.empty();
        Optional<java.time.Duration> minLedgerTimeRel = commands.hasMinLedgerTimeRel() ? Optional.of(java.time.Duration.ofSeconds(commands.getMinLedgerTimeRel().getSeconds(), commands.getMinLedgerTimeRel().getNanos())) : Optional.empty();
        Optional<java.time.Duration> deduplicationPeriod = Optional.empty();
        switch (commands.getDeduplicationPeriodCase()) {
            case DEDUPLICATION_DURATION: {
                Duration d = commands.getDeduplicationDuration();
                deduplicationPeriod = Optional.of(java.time.Duration.ofSeconds(d.getSeconds(), d.getNanos()));
                break;
            }
            case DEDUPLICATION_TIME: {
                Duration t2 = commands.getDeduplicationTime();
                deduplicationPeriod = Optional.of(java.time.Duration.ofSeconds(t2.getSeconds(), t2.getNanos()));
                break;
            }
        }
        String submissionId = commands.getSubmissionId();
        ArrayList<Command> listOfCommands = new ArrayList<Command>(commands.getCommandsCount());
        for (CommandsOuterClass.Command command : commands.getCommandsList()) {
            listOfCommands.add(Command.fromProtoCommand(command));
        }
        if (!actAs.contains(party)) {
            actAs.add(0, party);
        }
        return new SubmitCommandsRequest(workflowId, applicationId, commandId, actAs, (List<String>)readAs, minLedgerTimeAbs, minLedgerTimeRel, deduplicationPeriod, submissionId.isEmpty() ? Optional.empty() : Optional.of(submissionId), listOfCommands);
    }

    private static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull Optional<String> submissionId, @NonNull List<@NonNull Command> commands) {
        if (actAs.size() == 0) {
            throw new IllegalArgumentException("actAs must have at least one element");
        }
        List commandsConverted = commands.stream().map(Command::toProtoCommand).collect(Collectors.toList());
        CommandsOuterClass.Commands.Builder builder = CommandsOuterClass.Commands.newBuilder().setLedgerId(ledgerId).setWorkflowId(workflowId).setApplicationId(applicationId).setCommandId(commandId).setParty(actAs.get(0)).addAllActAs(actAs).addAllReadAs(readAs).addAllCommands(commandsConverted);
        minLedgerTimeAbsolute.ifPresent(abs -> builder.setMinLedgerTimeAbs(Timestamp.newBuilder().setSeconds(abs.getEpochSecond()).setNanos(abs.getNano())));
        minLedgerTimeRelative.ifPresent(rel -> builder.setMinLedgerTimeRel(Duration.newBuilder().setSeconds(rel.getSeconds()).setNanos(rel.getNano())));
        deduplicationTime.ifPresent(dedup -> {
            CommandsOuterClass.Commands.Builder unused2 = builder.setDeduplicationTime(Duration.newBuilder().setSeconds(dedup.getSeconds()).setNanos(dedup.getNano()));
        });
        submissionId.ifPresent(builder::setSubmissionId);
        return builder.build();
    }

    private static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull Optional<String> submissionId, @NonNull CommandsSubmission submission) {
        if (submission.getActAs().size() == 0) {
            throw new IllegalArgumentException("actAs must have at least one element");
        }
        List<Command> commands = HasCommands.toCommands(submission.getCommands());
        List commandsConverted = commands.stream().map(Command::toProtoCommand).collect(Collectors.toList());
        CommandsOuterClass.Commands.Builder builder = CommandsOuterClass.Commands.newBuilder().setLedgerId(ledgerId).setApplicationId(submission.getApplicationId()).setCommandId(submission.getCommandId()).setParty(submission.getActAs().get(0)).addAllActAs(submission.getActAs()).addAllReadAs(submission.getReadAs()).addAllCommands(commandsConverted);
        submission.getMinLedgerTimeAbs().ifPresent(abs -> builder.setMinLedgerTimeAbs(Timestamp.newBuilder().setSeconds(abs.getEpochSecond()).setNanos(abs.getNano())));
        submission.getMinLedgerTimeRel().ifPresent(rel -> builder.setMinLedgerTimeRel(Duration.newBuilder().setSeconds(rel.getSeconds()).setNanos(rel.getNano())));
        submission.getDeduplicationTime().ifPresent(dedup -> {
            CommandsOuterClass.Commands.Builder unused2 = builder.setDeduplicationTime(Duration.newBuilder().setSeconds(dedup.getSeconds()).setNanos(dedup.getNano()));
        });
        submission.getWorkflowId().ifPresent(builder::setWorkflowId);
        submissionId.ifPresent(builder::setSubmissionId);
        return builder.build();
    }

    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull CommandsSubmission submission) {
        return SubmitCommandsRequest.toProto(ledgerId, submission.getWorkflowId().orElse(""), submission.getApplicationId(), submission.getCommandId(), submission.getActAs(), submission.getReadAs(), submission.getMinLedgerTimeAbs(), submission.getMinLedgerTimeRel(), submission.getDeduplicationTime(), Optional.empty(), HasCommands.toCommands(submission.getCommands()));
    }

    @Deprecated
    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return SubmitCommandsRequest.toProto(ledgerId, workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.empty(), commands);
    }

    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String submissionId, @NonNull CommandsSubmission submission) {
        return SubmitCommandsRequest.toProto(ledgerId, submission.getWorkflowId().orElse(""), submission.getApplicationId(), submission.getCommandId(), submission.getActAs(), submission.getReadAs(), submission.getMinLedgerTimeAbs(), submission.getMinLedgerTimeRel(), submission.getDeduplicationTime(), Optional.of(submissionId), HasCommands.toCommands(submission.getCommands()));
    }

    @Deprecated
    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String submissionId, @NonNull List<@NonNull String> actAs, @NonNull List<@NonNull String> readAs, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        return SubmitCommandsRequest.toProto(ledgerId, workflowId, applicationId, commandId, actAs, readAs, minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.of(submissionId), commands);
    }

    @Deprecated
    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String submissionId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        ArrayList<String> empty_read_as = new ArrayList<String>();
        ArrayList<String> act_as = new ArrayList<String>();
        act_as.add(party);
        return SubmitCommandsRequest.toProto(ledgerId, workflowId, applicationId, commandId, act_as, empty_read_as, minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.of(submissionId), commands);
    }

    @Deprecated
    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        ArrayList<String> empty_read_as = new ArrayList<String>();
        ArrayList<String> act_as = new ArrayList<String>();
        act_as.add(party);
        return SubmitCommandsRequest.toProto(ledgerId, workflowId, applicationId, commandId, act_as, empty_read_as, minLedgerTimeAbsolute, minLedgerTimeRelative, deduplicationTime, Optional.empty(), commands);
    }

    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull String getApplicationId() {
        return this.applicationId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull String getParty() {
        return this.party;
    }

    public @NonNull List<String> getActAs() {
        return this.actAs;
    }

    public @NonNull List<String> getReadAs() {
        return this.readAs;
    }

    public @NonNull Optional<Instant> getMinLedgerTimeAbsolute() {
        return this.minLedgerTimeAbsolute;
    }

    public @NonNull Optional<java.time.Duration> getMinLedgerTimeRelative() {
        return this.minLedgerTimeRelative;
    }

    public @NonNull Optional<java.time.Duration> getDeduplicationTime() {
        return this.deduplicationTime;
    }

    public @NonNull Optional<String> getSubmissionId() {
        return this.submissionId;
    }

    public @NonNull List<@NonNull Command> getCommands() {
        return this.commands;
    }

    public String toString() {
        return "SubmitCommandsRequest{workflowId='" + this.workflowId + "', applicationId='" + this.applicationId + "', commandId='" + this.commandId + "', party='" + this.party + "', minLedgerTimeAbs=" + this.minLedgerTimeAbsolute + ", minLedgerTimeRel=" + this.minLedgerTimeRelative + ", deduplicationTime=" + this.deduplicationTime + ", submissionId=" + this.submissionId + ", commands=" + this.commands + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitCommandsRequest submitCommandsRequest1 = (SubmitCommandsRequest)o;
        return Objects.equals(this.workflowId, submitCommandsRequest1.workflowId) && Objects.equals(this.applicationId, submitCommandsRequest1.applicationId) && Objects.equals(this.commandId, submitCommandsRequest1.commandId) && Objects.equals(this.party, submitCommandsRequest1.party) && Objects.equals(this.actAs, submitCommandsRequest1.actAs) && Objects.equals(this.readAs, submitCommandsRequest1.readAs) && Objects.equals(this.minLedgerTimeAbsolute, submitCommandsRequest1.minLedgerTimeAbsolute) && Objects.equals(this.minLedgerTimeRelative, submitCommandsRequest1.minLedgerTimeRelative) && Objects.equals(this.deduplicationTime, submitCommandsRequest1.deduplicationTime) && Objects.equals(this.submissionId, submitCommandsRequest1.submissionId) && Objects.equals(this.commands, submitCommandsRequest1.commands);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.applicationId, this.commandId, this.party, this.actAs, this.readAs, this.minLedgerTimeAbsolute, this.minLedgerTimeRelative, this.deduplicationTime, this.submissionId, this.commands);
    }
}

