/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionOuterClass;
import com.daml.ledger.javaapi.data.Event;
import com.daml.ledger.javaapi.data.WorkflowEvent;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Transaction
implements WorkflowEvent {
    private final String transactionId;
    private final String commandId;
    private final String workflowId;
    private final Instant effectiveAt;
    private final List<Event> events;
    private final String offset;

    public Transaction(@NonNull String transactionId, @NonNull String commandId, @NonNull String workflowId, @NonNull Instant effectiveAt, @NonNull List<@NonNull Event> events, @NonNull String offset) {
        this.transactionId = transactionId;
        this.commandId = commandId;
        this.workflowId = workflowId;
        this.effectiveAt = effectiveAt;
        this.events = events;
        this.offset = offset;
    }

    public static Transaction fromProto(TransactionOuterClass.Transaction transaction) {
        String transactionId = transaction.getTransactionId();
        String commandId = transaction.getCommandId();
        Instant effectiveAt = Instant.ofEpochSecond(transaction.getEffectiveAt().getSeconds(), transaction.getEffectiveAt().getNanos());
        String workflowId = transaction.getWorkflowId();
        List<Event> events = transaction.getEventsList().stream().map(Event::fromProtoEvent).collect(Collectors.toList());
        String offset = transaction.getOffset();
        return new Transaction(transactionId, commandId, workflowId, effectiveAt, events, offset);
    }

    public TransactionOuterClass.Transaction toProto() {
        return TransactionOuterClass.Transaction.newBuilder().setTransactionId(this.transactionId).setCommandId(this.commandId).setEffectiveAt(Timestamp.newBuilder().setSeconds(this.effectiveAt.getEpochSecond()).setNanos(this.effectiveAt.getNano()).build()).addAllEvents(this.events.stream().map(Event::toProtoEvent).collect(Collectors.toList())).setOffset(this.offset).build();
    }

    public @NonNull String getTransactionId() {
        return this.transactionId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull Instant getEffectiveAt() {
        return this.effectiveAt;
    }

    public @NonNull List<Event> getEvents() {
        return this.events;
    }

    public @NonNull String getOffset() {
        return this.offset;
    }

    @Override
    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public String toString() {
        return "Transaction{transactionId='" + this.transactionId + "', commandId='" + this.commandId + "', workflowId='" + this.workflowId + "', effectiveAt=" + this.effectiveAt + ", events=" + this.events + ", offset='" + this.offset + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.commandId, that.commandId) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.effectiveAt, that.effectiveAt) && Objects.equals(this.events, that.events) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.commandId, this.workflowId, this.effectiveAt, this.events, this.offset);
    }
}

