/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.codegen.Choice;
import com.daml.ledger.javaapi.data.codegen.ContractId;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import com.daml.ledger.javaapi.data.codegen.ValueDecoder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class ContractCompanion<Ct, Id, Data>
extends ContractTypeCompanion<Ct, Id, Data, Data> {
    protected final Function<DamlRecord, Data> fromValue;

    public static <Data> ValueDecoder<Data> valueDecoder(final ContractCompanion<?, ? extends ContractId<Data>, Data> companion) {
        return new ValueDecoder<Data>(){

            @Override
            public Data decode(Value value) {
                DamlRecord record = value.asRecord().orElseThrow(() -> new IllegalArgumentException("Contracts must be constructed from Records"));
                return companion.fromValue.apply(record);
            }

            @Override
            public ContractId<Data> fromContractId(String contractId) {
                return (ContractId)companion.newContractId.apply(contractId);
            }
        };
    }

    protected ContractCompanion(String templateClassName, Identifier templateId, Function<String, Id> newContractId, Function<DamlRecord, Data> fromValue, List<Choice<Data, ?, ?>> choices) {
        super(templateId, templateClassName, newContractId, choices);
        this.fromValue = fromValue;
    }

    public static final class WithKey<Ct, Id, Data, Key>
    extends ContractCompanion<Ct, Id, Data> {
        private final NewContract<Ct, Id, Data, Key> newContract;
        private final Function<Value, Key> keyFromValue;

        public WithKey(String templateClassName, Identifier templateId, Function<String, Id> newContractId, Function<DamlRecord, Data> fromValue, NewContract<Ct, Id, Data, Key> newContract, List<Choice<Data, ?, ?>> choices, Function<Value, Key> keyFromValue) {
            super(templateClassName, templateId, newContractId, fromValue, choices);
            this.newContract = newContract;
            this.keyFromValue = keyFromValue;
        }

        public Ct fromIdAndRecord(String contractId, DamlRecord record$, Optional<String> agreementText, Optional<Key> key, Set<String> signatories, Set<String> observers) {
            Object id2 = this.newContractId.apply(contractId);
            Object data = this.fromValue.apply(record$);
            return this.newContract.newContract(id2, data, agreementText, key, signatories, observers);
        }

        @Override
        public Ct fromCreatedEvent(CreatedEvent event) {
            return this.fromIdAndRecord(event.getContractId(), event.getArguments(), event.getAgreementText(), event.getContractKey().map(this.keyFromValue), event.getSignatories(), event.getObservers());
        }

        @FunctionalInterface
        public static interface NewContract<Ct, Id, Data, Key> {
            public Ct newContract(Id var1, Data var2, Optional<String> var3, Optional<Key> var4, Set<String> var5, Set<String> var6);
        }
    }

    public static final class WithoutKey<Ct, Id, Data>
    extends ContractCompanion<Ct, Id, Data> {
        private final NewContract<Ct, Id, Data> newContract;

        public WithoutKey(String templateClassName, Identifier templateId, Function<String, Id> newContractId, Function<DamlRecord, Data> fromValue, NewContract<Ct, Id, Data> newContract, List<Choice<Data, ?, ?>> choices) {
            super(templateClassName, templateId, newContractId, fromValue, choices);
            this.newContract = newContract;
        }

        public Ct fromIdAndRecord(String contractId, DamlRecord record$, Optional<String> agreementText, Set<String> signatories, Set<String> observers) {
            Object id2 = this.newContractId.apply(contractId);
            Object data = this.fromValue.apply(record$);
            return this.newContract.newContract(id2, data, agreementText, signatories, observers);
        }

        @Override
        public Ct fromCreatedEvent(CreatedEvent event) {
            return this.fromIdAndRecord(event.getContractId(), event.getArguments(), event.getAgreementText(), event.getSignatories(), event.getObservers());
        }

        @FunctionalInterface
        public static interface NewContract<Ct, Id, Data> {
            public Ct newContract(Id var1, Data var2, Optional<String> var3, Set<String> var4, Set<String> var5);
        }
    }
}

