/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.Contract;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.codegen.ContractCompanion;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ContractDecoder {
    private final Map<Identifier, ? extends ContractCompanion<? extends com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ?>> companions;

    public ContractDecoder(Iterable<? extends ContractCompanion<? extends com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ?>> companions) {
        this.companions = StreamSupport.stream(companions.spliterator(), false).collect(Collectors.toMap(c -> c.TEMPLATE_ID, Function.identity()));
    }

    public com.daml.ledger.javaapi.data.codegen.Contract<?, ?> fromCreatedEvent(CreatedEvent event) throws IllegalArgumentException {
        Identifier templateId = event.getTemplateId();
        ContractCompanion<com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ?> companion = this.getContractCompanion(templateId).orElseThrow(() -> new IllegalArgumentException("No template found for identifier " + templateId));
        return (com.daml.ledger.javaapi.data.codegen.Contract)companion.fromCreatedEvent(event);
    }

    public Optional<? extends ContractCompanion<? extends com.daml.ledger.javaapi.data.codegen.Contract<?, ?>, ?, ?>> getContractCompanion(Identifier templateId) {
        return Optional.ofNullable(this.companions.get(templateId));
    }

    public Optional<Function<CreatedEvent, Contract>> getDecoder(Identifier templateId) {
        return Optional.ofNullable(this.companions.get(templateId)).map(companion -> companion::fromCreatedEvent);
    }
}

