/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data.codegen;

import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.DamlRecord;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.codegen.Choice;
import com.daml.ledger.javaapi.data.codegen.Contract;
import com.daml.ledger.javaapi.data.codegen.ContractTypeCompanion;
import com.daml.ledger.javaapi.data.codegen.ContractWithInterfaceView;
import com.daml.ledger.javaapi.data.codegen.ValueDecoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class InterfaceCompanion<I, Id, View>
extends ContractTypeCompanion<Contract<Id, View>, Id, I, View> {
    public final ValueDecoder<View> valueDecoder;

    protected InterfaceCompanion(String templateClassName, Identifier templateId, Function<String, Id> newContractId, ValueDecoder<View> valueDecoder, List<Choice<I, ?, ?>> choices) {
        super(templateId, templateClassName, newContractId, choices);
        this.valueDecoder = valueDecoder;
    }

    private Contract<Id, View> fromIdAndRecord(String contractId, Map<Identifier, DamlRecord> interfaceViews, Optional<String> agreementText, Set<String> signatories, Set<String> observers) throws IllegalArgumentException {
        Optional<DamlRecord> maybeRecord = Optional.ofNullable(interfaceViews.get(this.TEMPLATE_ID));
        Optional<DamlRecord> maybeFailedRecord = Optional.ofNullable(interfaceViews.get(this.TEMPLATE_ID));
        Object id2 = this.newContractId.apply(contractId);
        return maybeRecord.map(record -> {
            View view = this.valueDecoder.decode((Value)record);
            return new ContractWithInterfaceView<Object, View>(this, id2, view, agreementText, signatories, observers);
        }).orElseThrow(() -> maybeFailedRecord.map(record -> new IllegalArgumentException("Failed interface view for " + this.TEMPLATE_ID)).orElseThrow(() -> new IllegalArgumentException("interface view of " + this.TEMPLATE_ID + " not found.")));
    }

    @Override
    public final Contract<Id, View> fromCreatedEvent(CreatedEvent event) throws IllegalArgumentException {
        return this.fromIdAndRecord(event.getContractId(), event.getInterfaceViews(), event.getAgreementText(), event.getSignatories(), event.getObservers());
    }
}

