/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.codegen.ValueDecoder;
import com.daml.lf.codegen.TypeWithContext;
import com.daml.lf.codegen.backend.java.JavaEscaper$;
import com.daml.lf.codegen.backend.java.inner.FieldInfo;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.ToValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.TrackLineage$;
import com.daml.lf.codegen.backend.java.inner.VariantConstructorClass$;
import com.daml.lf.codegen.backend.java.inner.VariantRecordClass$;
import com.daml.lf.codegen.backend.java.inner.VariantValueDecodersMethods$;
import com.daml.lf.codegen.backend.java.inner.package$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.typesig.DataType;
import com.daml.lf.typesig.DefDataType;
import com.daml.lf.typesig.PackageSignature;
import com.daml.lf.typesig.Record;
import com.daml.lf.typesig.TypeCon;
import com.daml.lf.typesig.TypeConName;
import com.daml.lf.typesig.Variant;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariantClass$
implements StrictLogging {
    public static final VariantClass$ MODULE$ = new VariantClass$();
    private static Logger logger;

    static {
        StrictLogging.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Tuple2<TypeSpec, List<TypeSpec>> generate(ClassName variantClassName, String subPackage, IndexedSeq<String> typeArguments, Variant<com.daml.lf.typesig.Type> variant, TypeWithContext typeWithContext, Object packagePrefixes) {
        return (Tuple2)TrackLineage$.MODULE$.of("variant", typeWithContext.name(), (Function0<Tuple2> & Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Start");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            IndexedSeq<FieldInfo> constructorInfo = package$.MODULE$.getFieldsWithTypes(variant.fields(), packagePrefixes);
            TypeSpec variantType = TypeSpec.classBuilder(variantClassName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).superclass(typeArguments.isEmpty() ? ParameterizedTypeName.get(ClassName.get(com.daml.ledger.javaapi.data.codegen.Variant.class), variantClassName) : ClassName.get(Object.class)).addTypeVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)typeArguments.map((Function1<String, TypeVariableName> & Serializable)x$1 -> TypeVariableName.get(x$1))).asJava()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).build()).addMethod(MODULE$.generateAbstractToValueSpec(typeArguments)).addMethod(MODULE$.generateDeprecatedFromValue(typeArguments, variantClassName)).addMethod(MODULE$.generateValueDecoder(typeArguments, constructorInfo, variantClassName)).addMethods(CollectionConverters$.MODULE$.SeqHasAsJava(VariantValueDecodersMethods$.MODULE$.apply(typeArguments, variant, typeWithContext, subPackage, packagePrefixes)).asJava()).addField(package$.MODULE$.createPackageIdField(typeWithContext.interface().packageId())).build();
            List<TypeSpec> constructors2 = MODULE$.generateConstructorClasses(typeArguments, variant, typeWithContext, variantClassName, packagePrefixes);
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("End");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Tuple2<TypeSpec, List<TypeSpec>>(variantType, constructors2);
        });
    }

    private MethodSpec generateAbstractToValueSpec(IndexedSeq<String> typeArgs) {
        return MethodSpec.methodBuilder("toValue").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameters(CollectionConverters$.MODULE$.SeqHasAsJava(ToValueExtractorParameters$.MODULE$.generate(typeArgs)).asJava()).returns((Type)((Object)com.daml.ledger.javaapi.data.Variant.class)).build();
    }

    private MethodSpec.Builder initFromValueBuilder(TypeName t2, String methodName) {
        return MethodSpec.methodBuilder(methodName).addModifiers(Modifier.STATIC, Modifier.PUBLIC).returns(t2);
    }

    private CodeBlock variantExtractor(TypeName t2) {
        return CodeBlock.of("$T variant$$ = value$$.asVariant().orElseThrow(() -> new IllegalArgumentException($S))", com.daml.ledger.javaapi.data.Variant.class, new StringBuilder(53).append("Expected Variant to build an instance of the Variant ").append(t2).toString());
    }

    private CodeBlock.Builder switchOnConstructor(CodeBlock.Builder builder, IndexedSeq<FieldInfo> constructors2, ClassName variant, Function1<String, CodeBlock> useValueDecoder) {
        BoxedUnit boxedUnit;
        String constructorsAsString = ((IterableOnceOps)constructors2.map((Function1<FieldInfo, String> & Serializable)x$1 -> x$1.damlName())).mkString("[", ", ", "]");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating switch on constructors {} for {}", new Object[]{constructorsAsString, variant});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        constructors2.foreach((Function1<FieldInfo, CodeBlock.Builder> & Serializable)constructorInfo -> builder.beginControlFlow("if ($S.equals(variant$$.getConstructor()))", constructorInfo.damlName()).addStatement((CodeBlock)useValueDecoder.apply(new StringBuilder(12).append("valueDecoder").append(constructorInfo.javaName()).toString())).endControlFlow());
        return builder.addStatement("throw new IllegalArgumentException($S)", new StringBuilder(82).append("Found unknown constructor variant$.getConstructor() for variant ").append(variant).append(", expected one of ").append(constructorsAsString).toString());
    }

    private MethodSpec generateParameterizedValueDecoder(ParameterizedTypeName variant, IndexedSeq<FieldInfo> constructors2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating valueDecoder static method for {}", (Object)variant);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().forall((Function1<TypeName, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(VariantClass$.$anonfun$generateParameterizedValueDecoder$1(x$2))), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(38).append("All type arguments of ").append(variant$2.rawType).append(" must be generic").toString());
        ParameterizedTypeName returnType = ParameterizedTypeName.get(ClassName.get(ValueDecoder.class), variant);
        MethodSpec.Builder builder = this.initFromValueBuilder(returnType, "valueDecoder");
        builder.beginControlFlow("return $L ->", "value$");
        FromValueExtractorParameters typeVariablesExtractorParameters = FromValueExtractorParameters$.MODULE$.generate(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().map((Function1<TypeName, String> & Serializable)x$3 -> x$3.toString())).toIndexedSeq());
        builder.addTypeVariables(CollectionConverters$.MODULE$.SeqHasAsJava(typeVariablesExtractorParameters.typeVariables()).asJava());
        builder.addParameters(CollectionConverters$.MODULE$.SeqHasAsJava(typeVariablesExtractorParameters.valueDecoderParameterSpecs()).asJava());
        CodeBlock.Builder decodeValueCodeBuilder = CodeBlock.builder();
        decodeValueCodeBuilder.addStatement("$L", this.variantExtractor(variant.rawType));
        CodeBlock extractors = CodeBlock.join(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().map((Function1<TypeName, CodeBlock> & Serializable)t2 -> CodeBlock.of("$L", new StringBuilder(9).append("fromValue").append(t2).toString()))).asJava(), ",$W");
        this.switchOnConstructor(decodeValueCodeBuilder, constructors2, variant.rawType, (Function1<String, CodeBlock> & Serializable)valueDecoder -> CodeBlock.of("return $L($L).decode(variant$$)", valueDecoder, extractors));
        return builder.addCode(decodeValueCodeBuilder.build()).endControlFlow("", new Object[0]).build();
    }

    private MethodSpec generateConcreteValueDecoder(ClassName t2, IndexedSeq<FieldInfo> constructors2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating valueDecoder static method for {}", (Object)t2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParameterizedTypeName returnType = ParameterizedTypeName.get(ClassName.get(ValueDecoder.class), t2);
        MethodSpec.Builder builder = this.initFromValueBuilder(returnType, "valueDecoder").beginControlFlow("return $L ->", "value$");
        CodeBlock.Builder decodeValueCodeBuilder = CodeBlock.builder().addStatement("$L", this.variantExtractor(t2));
        this.switchOnConstructor(decodeValueCodeBuilder, constructors2, t2, (Function1<String, CodeBlock> & Serializable)valueDecoder -> CodeBlock.of("return $L().decode(variant$$)", valueDecoder));
        return builder.addCode(decodeValueCodeBuilder.build()).endControlFlow("", new Object[0]).build();
    }

    private MethodSpec generateDeprecatedFromValue(IndexedSeq<String> typeArguments, ClassName variantClassName) {
        TypeName typeName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArguments);
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            return this.generateDeprecatedConcreteFromValue(className);
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            return this.generateDeprecatedParameterizedFromValue(parameterizedTypeName);
        }
        throw new IllegalArgumentException("Required either ClassName or ParameterizedTypeName");
    }

    private MethodSpec generateDeprecatedConcreteFromValue(ClassName t2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating depreacted fromValue static method for {}", (Object)t2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.initFromValueBuilder(t2, "fromValue").addParameter((Type)((Object)Value.class), "value$", new Modifier[0]).addAnnotation(Deprecated.class).addJavadoc("@deprecated since Daml $L; $L", "2.5.0", "use {@code valueDecoder} instead").addStatement("$L", this.variantExtractor(t2)).addStatement("return valueDecoder().decode($L)", "value$").build();
    }

    private MethodSpec generateDeprecatedParameterizedFromValue(ParameterizedTypeName variant) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating deprecated fromValue static method for {}", (Object)variant);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().forall((Function1<TypeName, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(VariantClass$.$anonfun$generateDeprecatedParameterizedFromValue$1(x$4))), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(38).append("All type arguments of ").append(variant$3.rawType).append(" must be generic").toString());
        MethodSpec.Builder builder = this.initFromValueBuilder(variant, "fromValue").addParameter((Type)((Object)Value.class), "value$", new Modifier[0]);
        FromValueExtractorParameters typeVariablesExtractorParameters = FromValueExtractorParameters$.MODULE$.generate(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().map((Function1<TypeName, String> & Serializable)x$5 -> x$5.toString())).toIndexedSeq());
        builder.addTypeVariables(CollectionConverters$.MODULE$.SeqHasAsJava(typeVariablesExtractorParameters.typeVariables()).asJava()).addParameters(CollectionConverters$.MODULE$.SeqHasAsJava(typeVariablesExtractorParameters.functionParameterSpecs()).asJava()).addAnnotation(Deprecated.class).addJavadoc("@deprecated since Daml $L; $L", "2.5.0", "use {@code valueDecoder} instead");
        CodeBlock fromValueParams = CodeBlock.join(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)typeVariablesExtractorParameters.functionParameterSpecs().map((Function1<ParameterSpec, CodeBlock> & Serializable)param2 -> CodeBlock.of("$T.fromFunction($N)", ValueDecoder.class, param2))).asJava(), ",$W");
        CodeBlock typeParameterList = CodeBlock.join(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(variant.typeArguments).asScala().map((Function1<TypeName, CodeBlock> & Serializable)param2 -> CodeBlock.of("$T", param2))).asJava(), ",$W");
        CodeBlock classStaticAccessor = CodeBlock.of("$T.<$L>", variant.rawType, typeParameterList);
        builder.addStatement("return $LvalueDecoder($L).decode($L)", classStaticAccessor, fromValueParams, "value$");
        return builder.build();
    }

    private MethodSpec generateValueDecoder(IndexedSeq<String> typeArguments, IndexedSeq<FieldInfo> constructorInfo, ClassName variantClassName) {
        TypeName typeName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArguments);
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            return this.generateConcreteValueDecoder(className, constructorInfo);
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            return this.generateParameterizedValueDecoder(parameterizedTypeName, constructorInfo);
        }
        throw new IllegalArgumentException("Required either ClassName or ParameterizedTypeName");
    }

    private List<TypeSpec> generateConstructorClasses(IndexedSeq<String> typeArgs, Variant<com.daml.lf.typesig.Type> variant, TypeWithContext typeWithContext, ClassName variantClassName, Object packagePrefixes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating inner classes");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuffer innerClasses = new ArrayBuffer();
        HashSet variantRecords = new HashSet();
        TypeName fullVariantClassName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArgs);
        package$.MODULE$.getFieldsWithTypes(variant.fields(), packagePrefixes).foreach((Function1<FieldInfo, Object> & Serializable)fieldInfo -> {
            BoxedUnit boxedUnit;
            Ref.Identifier id2;
            TypeCon typeCon;
            TypeConName typeConName;
            FieldInfo fieldInfo2 = fieldInfo;
            if (fieldInfo2 == null) {
                throw new MatchError(fieldInfo2);
            }
            String damlName = fieldInfo2.damlName();
            com.daml.lf.typesig.Type damlType = fieldInfo2.damlType();
            String javaName = fieldInfo2.javaName();
            Tuple3<String, com.daml.lf.typesig.Type, String> tuple3 = new Tuple3<String, com.daml.lf.typesig.Type, String>(damlName, damlType, javaName);
            String damlName2 = tuple3._1();
            com.daml.lf.typesig.Type damlType2 = tuple3._2();
            String javaName2 = tuple3._3();
            com.daml.lf.typesig.Type type = damlType2;
            if (type instanceof TypeCon && (typeConName = (typeCon = (TypeCon)type).name()) != null && package$.MODULE$.isVariantRecord(typeWithContext, damlName2, id2 = typeConName.identifier())) {
                return BoxesRunTime.boxToBoolean(variantRecords.add(damlName2));
            }
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("{} is trivial", (Object)damlName2);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return innerClasses.$plus$eq(VariantConstructorClass$.MODULE$.generate(typeWithContext.interface().packageId(), fullVariantClassName, typeArgs, damlName2, javaName2, damlType2, packagePrefixes));
        });
        typeWithContext.typesLineages().map((Function1<TypeWithContext, Object> & Serializable)child -> {
            if (variantRecords.contains(child.name())) {
                PackageSignature.TypeDecl.Normal normal;
                DefDataType<com.daml.lf.typesig.Type, com.daml.lf.typesig.Type> defDataType;
                Some some;
                PackageSignature.TypeDecl typeDecl;
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{} is a variant record", (Object)child.name());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option<PackageSignature.TypeDecl> option2 = child.type().typ();
                if (option2 instanceof Some && (typeDecl = (PackageSignature.TypeDecl)(some = (Some)option2).value()) instanceof PackageSignature.TypeDecl.Normal && (defDataType = (normal = (PackageSignature.TypeDecl.Normal)typeDecl).type()) != null) {
                    ImmArray.ImmArraySeq<String> typeVars = defDataType.typeVars();
                    DataType<com.daml.lf.typesig.Type, com.daml.lf.typesig.Type> record = defDataType.dataType();
                    if (record instanceof Record) {
                        Record record2 = (Record)record;
                        return (ArrayBuffer)innerClasses.$plus$eq(VariantRecordClass$.MODULE$.generate(typeWithContext.interface().packageId(), (IndexedSeq)typeVars.map((Function1<String, String> & Serializable)s2 -> JavaEscaper$.MODULE$.escapeString((String)s2)), package$.MODULE$.getFieldsWithTypes(record2.fields(), packagePrefixes), child.name(), fullVariantClassName, packagePrefixes));
                    }
                }
                String c = new StringBuilder(1).append(typeWithContext.name()).append(".").append(child.name()).toString();
                throw new IllegalArgumentException(new StringBuilder(55).append("Underlying type of constructor ").append(c).append(" is not Record (found: ").append(option2).append(")").toString());
            }
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("{} is an unrelated inner type", (Object)child.name());
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return innerClasses.toList();
    }

    public static final /* synthetic */ boolean $anonfun$generateParameterizedValueDecoder$1(TypeName x$2) {
        return x$2 instanceof TypeVariableName;
    }

    public static final /* synthetic */ boolean $anonfun$generateDeprecatedParameterizedFromValue$1(TypeName x$4) {
        return x$4 instanceof TypeVariableName;
    }

    private VariantClass$() {
    }
}

