/*
 * Decompiled with CFR 0.152.
 */
package com.docspring.auth;

import com.docspring.auth.OAuthFlow;
import com.docspring.auth.OAuthOkHttpClient;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;

public class OAuth
implements Interceptor {
    private volatile String accessToken;
    private OAuthClient oauthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;
    private AccessTokenListener accessTokenListener;

    public OAuth(OkHttpClient client, OAuthClientRequest.TokenRequestBuilder requestBuilder) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthOkHttpClient(client));
        this.tokenRequestBuilder = requestBuilder;
    }

    public OAuth(OAuthClientRequest.TokenRequestBuilder requestBuilder) {
        this(new OkHttpClient(), requestBuilder);
    }

    public OAuth(OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(OAuthClientRequest.tokenLocation((String)tokenUrl).setScope(scopes));
        this.setFlow(flow);
        this.authenticationRequestBuilder = OAuthClientRequest.authorizationLocation((String)authorizationUrl);
    }

    public void setFlow(OAuthFlow flow) {
        switch (flow) {
            case accessCode: 
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryingIntercept(chain, true);
    }

    private Response retryingIntercept(Interceptor.Chain chain, boolean updateTokenAndRetryOnAuthorizationFailure) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        if (this.getAccessToken() == null) {
            this.updateAccessToken(null);
        }
        if (this.getAccessToken() != null) {
            OAuthClientRequest oAuthRequest;
            Request.Builder rb = request.newBuilder();
            String requestAccessToken = new String(this.getAccessToken());
            try {
                oAuthRequest = new OAuthBearerClientRequest(request.url().toString()).setAccessToken(requestAccessToken).buildHeaderMessage();
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            for (Map.Entry header : oAuthRequest.getHeaders().entrySet()) {
                rb.addHeader((String)header.getKey(), (String)header.getValue());
            }
            rb.url(oAuthRequest.getLocationUri());
            Response response = chain.proceed(rb.build());
            if (response != null && (response.code() == 401 || response.code() == 403) && updateTokenAndRetryOnAuthorizationFailure) {
                try {
                    if (this.updateAccessToken(requestAccessToken)) {
                        response.body().close();
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception e) {
                    response.body().close();
                    throw e;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    public synchronized boolean updateAccessToken(String requestAccessToken) throws IOException {
        if (this.getAccessToken() == null || this.getAccessToken().equals(requestAccessToken)) {
            try {
                OAuthJSONAccessTokenResponse accessTokenResponse = this.oauthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
                if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
                    this.setAccessToken(accessTokenResponse.getAccessToken());
                    if (this.accessTokenListener != null) {
                        this.accessTokenListener.notify((BasicOAuthToken)accessTokenResponse.getOAuthToken());
                    }
                    return !this.getAccessToken().equals(requestAccessToken);
                }
                return false;
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            catch (OAuthProblemException e) {
                throw new IOException(e);
            }
        }
        return true;
    }

    public void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        this.accessTokenListener = accessTokenListener;
    }

    public synchronized String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthenticationRequestBuilder() {
        return this.authenticationRequestBuilder;
    }

    public void setAuthenticationRequestBuilder(OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public static interface AccessTokenListener {
        public void notify(BasicOAuthToken var1);
    }
}

