/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.Array;
import com.ejlchina.okhttps.Mapper;
import com.ejlchina.okhttps.XmlMapper;
import com.ejlchina.okhttps.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class XmlArray
implements Array {
    private String[] nameKeys;
    private String[] valueKeys;
    private List<Element> list;

    public XmlArray(String[] nameKeys, String[] valueKeys, List<Element> list) {
        this.nameKeys = nameKeys;
        this.valueKeys = valueKeys;
        this.list = list;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Mapper getMapper(int index) {
        if (index < this.list.size()) {
            return new XmlMapper(this.nameKeys, this.valueKeys, this.list.get(index));
        }
        return null;
    }

    public Array getArray(int index) {
        if (index < this.list.size()) {
            Element node = this.list.get(index);
            return new XmlArray(this.nameKeys, this.valueKeys, XmlUtils.children(node));
        }
        return null;
    }

    public boolean getBool(int index) {
        if (index < this.list.size()) {
            String value = XmlUtils.value(this.list.get(index), this.valueKeys);
            return XmlUtils.toBoolean(value);
        }
        return false;
    }

    public int getInt(int index) {
        if (index < this.list.size()) {
            String value = XmlUtils.value(this.list.get(index), this.valueKeys);
            return XmlUtils.toInt(value);
        }
        return 0;
    }

    public long getLong(int index) {
        if (index < this.list.size()) {
            String value = XmlUtils.value(this.list.get(index), this.valueKeys);
            return XmlUtils.toLong(value);
        }
        return 0L;
    }

    public float getFloat(int index) {
        if (index < this.list.size()) {
            String value = XmlUtils.value(this.list.get(index), this.valueKeys);
            return XmlUtils.toFloat(value);
        }
        return 0.0f;
    }

    public double getDouble(int index) {
        if (index < this.list.size()) {
            String value = XmlUtils.value(this.list.get(index), this.valueKeys);
            return XmlUtils.toDouble(value);
        }
        return 0.0;
    }

    public String getString(int index) {
        if (index < this.list.size()) {
            return XmlUtils.value(this.list.get(index), this.valueKeys);
        }
        return null;
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < this.list.size(); ++i) {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.list.get(i)), new StreamResult(baos));
                if (i >= this.list.size() - 1) continue;
                baos.write(10);
            }
            return baos.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

