/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.Array;
import com.ejlchina.okhttps.Mapper;
import com.ejlchina.okhttps.XmlArray;
import com.ejlchina.okhttps.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlMapper
implements Mapper {
    private final String[] nameKeys;
    private final String[] valueKeys;
    private final Element element;
    private List<Element> children;

    public XmlMapper(String[] nameKeys, String[] valueKeys, Element element) {
        this.nameKeys = nameKeys;
        this.valueKeys = valueKeys;
        this.element = element;
    }

    public int size() {
        NamedNodeMap attrs = this.element.getAttributes();
        return this.children().size() + attrs.getLength();
    }

    public boolean isEmpty() {
        NamedNodeMap attrs = this.element.getAttributes();
        return attrs.getLength() == 0 && this.children().size() == 0;
    }

    public Mapper getMapper(String key) {
        Element child = XmlUtils.findElement(this.children(), this.nameKeys, key);
        if (child != null) {
            return new XmlMapper(this.nameKeys, this.valueKeys, child);
        }
        return null;
    }

    public Array getArray(String key) {
        List<Element> children = XmlUtils.findElements(this.children(), this.nameKeys, key);
        if (children.size() > 1) {
            return new XmlArray(this.nameKeys, this.valueKeys, children);
        }
        if (children.size() == 1) {
            Element element = children.get(0);
            return new XmlArray(this.nameKeys, this.valueKeys, XmlUtils.children(element));
        }
        return null;
    }

    public boolean getBool(String key) {
        return XmlUtils.toBoolean(this.getString(key));
    }

    public int getInt(String key) {
        return XmlUtils.toInt(this.getString(key));
    }

    public long getLong(String key) {
        return XmlUtils.toLong(this.getString(key));
    }

    public float getFloat(String key) {
        return XmlUtils.toFloat(this.getString(key));
    }

    public double getDouble(String key) {
        return XmlUtils.toDouble(this.getString(key));
    }

    public String getString(String key) {
        String value = this.element.getAttribute(key);
        if (!XmlUtils.isBlank(value)) {
            return value;
        }
        Element ele = XmlUtils.findElement(this.children(), this.nameKeys, key);
        if (ele != null) {
            return XmlUtils.value(ele, this.valueKeys);
        }
        return null;
    }

    public boolean has(String key) {
        return this.getString(key) != null;
    }

    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            set.add(attr.getName());
        }
        List<Element> nodes = this.children();
        for (Element node : nodes) {
            set.add(node.getNodeName());
            for (String nameKey : this.nameKeys) {
                String key = node.getAttribute(nameKey);
                if (XmlUtils.isBlank(key)) continue;
                set.add(key);
            }
        }
        return set;
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.element), new StreamResult(baos));
            return baos.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Element> children() {
        Element element = this.element;
        synchronized (element) {
            if (this.children == null) {
                this.children = XmlUtils.children(this.element);
            }
        }
        return this.children;
    }
}

