/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.okhttps.Array;
import com.ejlchina.okhttps.ConvertProvider;
import com.ejlchina.okhttps.Deserializer;
import com.ejlchina.okhttps.Mapper;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.XmlArray;
import com.ejlchina.okhttps.XmlMapper;
import com.ejlchina.okhttps.XmlUtils;
import com.ejlchina.okhttps.internal.HttpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlMsgConvertor
implements MsgConvertor,
ConvertProvider {
    private String[] nameKeys = new String[]{"name", "key"};
    private String[] valueKeys = new String[]{"value"};
    private boolean serializeFormatted = false;
    private Deserializer deserializer;
    private DocumentBuilderFactory dbFactory;

    public XmlMsgConvertor() {
        this(new Deserializer(), DocumentBuilderFactory.newInstance());
    }

    public XmlMsgConvertor(Deserializer deserializer, DocumentBuilderFactory dbFactory) {
        this.deserializer = deserializer;
        this.dbFactory = dbFactory;
    }

    public String mediaType() {
        return "application/xml";
    }

    private Element parseElement(InputStream in, Charset charset) {
        DocumentBuilder builder;
        try {
            builder = this.dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new HttpException("DocumentBuilderFactory \u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        try {
            InputSource source = new InputSource(in);
            source.setEncoding(charset.name());
            return builder.parse(source).getDocumentElement();
        }
        catch (IOException | SAXException e) {
            throw new HttpException("XML \u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
    }

    public Mapper toMapper(InputStream in, Charset charset) {
        Element root = this.parseElement(in, charset);
        return new XmlMapper(this.nameKeys, this.valueKeys, root);
    }

    public Array toArray(InputStream in, Charset charset) {
        Element root = this.parseElement(in, charset);
        return new XmlArray(this.nameKeys, this.valueKeys, XmlUtils.children(root));
    }

    public byte[] serialize(Object object, Charset charset) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)this.serializeFormatted);
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            return writer.toString().getBytes(charset);
        }
        catch (JAXBException e) {
            throw new HttpException("XML \u5e8f\u5217\u5316\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        return (T)this.deserializer.deserialize(this.toMapper(in, charset), type);
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        Array array = this.toArray(in, charset);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            list.add(this.deserializer.deserialize(array.getMapper(i), type));
        }
        return list;
    }

    public MsgConvertor getConvertor() {
        return new XmlMsgConvertor();
    }

    public String[] getNameKeys() {
        return this.nameKeys;
    }

    public void setNameKeys(String[] nameKeys) {
        this.nameKeys = nameKeys;
    }

    public String[] getValueKeys() {
        return this.valueKeys;
    }

    public void setValueKeys(String[] valueKeys) {
        this.valueKeys = valueKeys;
    }

    public Deserializer getDeserializer() {
        return this.deserializer;
    }

    public void setDeserializer(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    public DocumentBuilderFactory getDbFactory() {
        return this.dbFactory;
    }

    public void setDbFactory(DocumentBuilderFactory dbFactory) {
        this.dbFactory = dbFactory;
    }

    public boolean isSerializeFormatted() {
        return this.serializeFormatted;
    }

    public void setSerializeFormatted(boolean serializeFormatted) {
        this.serializeFormatted = serializeFormatted;
    }
}

