/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk;

import com.fangcloud.sdk.ProgressInputStream;
import com.fangcloud.sdk.ProgressOutputStream;
import com.fangcloud.sdk.YfyAppInfo;
import com.fangcloud.sdk.YfyArg;
import com.fangcloud.sdk.YfyHost;
import com.fangcloud.sdk.YfyProgressListener;
import com.fangcloud.sdk.YfyRefreshListener;
import com.fangcloud.sdk.YfyRequestConfig;
import com.fangcloud.sdk.YfyRequestUtil;
import com.fangcloud.sdk.api.collab.YfyCollabRequest;
import com.fangcloud.sdk.api.comment.YfyCommentRequest;
import com.fangcloud.sdk.api.file.YfyFile;
import com.fangcloud.sdk.api.file.YfyFileRequest;
import com.fangcloud.sdk.api.folder.YfyFolderRequest;
import com.fangcloud.sdk.api.item.YfyItemRequest;
import com.fangcloud.sdk.api.share_link.YfyShareLinkRequest;
import com.fangcloud.sdk.api.trash.YfyTrashRequest;
import com.fangcloud.sdk.api.user.YfyUserRequest;
import com.fangcloud.sdk.auth.YfyAuthFinish;
import com.fangcloud.sdk.exception.BadResponseException;
import com.fangcloud.sdk.exception.InvalidTokenException;
import com.fangcloud.sdk.exception.JsonReadException;
import com.fangcloud.sdk.exception.NeedAuthorizationException;
import com.fangcloud.sdk.exception.NetworkIOException;
import com.fangcloud.sdk.exception.YfyException;
import com.fangcloud.sdk.http.HttpRequestor;
import com.fangcloud.sdk.util.IOUtil;
import com.fangcloud.sdk.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class YfyClient<K> {
    private final YfyFileRequest fileRequest;
    private final YfyUserRequest userRequest;
    private final YfyFolderRequest folderRequest;
    private final YfyItemRequest itemRequest;
    private final YfyShareLinkRequest shareLinkRequest;
    private final YfyCollabRequest collabRequest;
    private final YfyCommentRequest commentRequest;
    private final YfyTrashRequest trashRequest;
    private K key;
    private volatile String accessToken;
    private volatile String refreshToken;
    private boolean autoRefresh;
    private YfyRefreshListener<K> refreshListener;
    private volatile long lastRefresh;
    private final ReadWriteLock refreshLock;
    private final YfyRequestConfig requestConfig;
    private final YfyHost host;

    public YfyClient(K key, YfyRequestConfig requestConfig, String accessToken, String refreshToken, YfyRefreshListener<K> refreshListener) {
        YfyInternalClient internalClient = new YfyInternalClient();
        if (accessToken == null) {
            throw new NullPointerException("access token");
        }
        this.fileRequest = new YfyFileRequest(internalClient);
        this.userRequest = new YfyUserRequest(internalClient);
        this.folderRequest = new YfyFolderRequest(internalClient);
        this.itemRequest = new YfyItemRequest(internalClient);
        this.shareLinkRequest = new YfyShareLinkRequest(internalClient);
        this.collabRequest = new YfyCollabRequest(internalClient);
        this.commentRequest = new YfyCommentRequest(internalClient);
        this.trashRequest = new YfyTrashRequest(internalClient);
        this.requestConfig = requestConfig;
        this.host = YfyAppInfo.getHost();
        this.refreshLock = new ReentrantReadWriteLock();
        this.key = key;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        if (refreshToken != null && refreshListener != null) {
            this.autoRefresh = true;
            this.refreshListener = refreshListener;
        }
    }

    public YfyClient(K key, YfyRequestConfig requestConfig, String accessToken, String refreshToken) {
        this(key, requestConfig, accessToken, refreshToken, null);
    }

    public YfyClient(YfyRequestConfig requestConfig, String accessToken) {
        this(null, requestConfig, accessToken, null);
    }

    public YfyFileRequest files() {
        return this.fileRequest;
    }

    public YfyUserRequest users() {
        return this.userRequest;
    }

    public YfyFolderRequest folders() {
        return this.folderRequest;
    }

    public YfyItemRequest items() {
        return this.itemRequest;
    }

    public YfyShareLinkRequest shareLinks() {
        return this.shareLinkRequest;
    }

    public YfyCollabRequest collabs() {
        return this.collabRequest;
    }

    public YfyTrashRequest trashs() {
        return this.trashRequest;
    }

    public YfyCommentRequest comments() {
        return this.commentRequest;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        if (autoRefresh) {
            if (this.refreshToken == null) {
                throw new NullPointerException("refresh token");
            }
            if (this.refreshListener == null) {
                throw new NullPointerException("refresh listener");
            }
        }
        this.autoRefresh = autoRefresh;
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws NeedAuthorizationException {
        if (this.refreshToken == null) {
            throw new IllegalStateException("refresh token is null,can't refresh");
        }
        this.refreshLock.writeLock().lock();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", this.refreshToken);
        try {
            YfyAuthFinish finish = YfyRequestUtil.doPostInAuth(this.requestConfig, this.host.getAuth(), "oauth/token", params, YfyAuthFinish.class);
            this.accessToken = finish.getAccessToken();
            this.refreshToken = finish.getRefreshToken();
            this.lastRefresh = System.currentTimeMillis();
            this.refreshListener.onTokenRefreshed(this.key, this.accessToken, this.refreshToken, finish.getExpiresIn());
        }
        catch (YfyException ex) {
            if (ex instanceof InvalidTokenException) {
                throw new NeedAuthorizationException("The user need authorization again");
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
    }

    private static interface RetriableExecution<T> {
        public T execute(boolean var1) throws YfyException;
    }

    public class YfyInternalClient {
        private static final String USER_AGENT_ID = "OfficialFangcloudJavaSDK";
        private static final String BOUNDARY = "--WebKitFormBoundaryPjbcBBB6fBCxfBFq";
        private static final String BOUNDARY_STR = "----WebKitFormBoundaryPjbcBBB6fBCxfBFq";

        public boolean canRefresh() {
            return YfyClient.this.autoRefresh && YfyClient.this.refreshToken != null;
        }

        public YfyHost getHost() {
            return YfyClient.this.host;
        }

        public <T> T doGet(final String path, final Object[] listParams, final Map<String, String> mapParams, final Class<T> tClass) throws YfyException {
            return this.executeRetriable(new RetriableExecution<T>(){

                @Override
                public T execute(boolean isRefresh) throws YfyException {
                    List headers = YfyInternalClient.this.addApiHeaders(isRefresh);
                    return YfyRequestUtil.doGetNoAuth(YfyClient.this.requestConfig, YfyClient.this.host.getApi(), String.format(path, listParams), mapParams, headers, tClass);
                }
            });
        }

        public InputStream doDownload(final String downloadUrl, boolean needToken, final YfyProgressListener progressListener) throws YfyException {
            if (needToken) {
                return this.executeRetriable(new RetriableExecution<InputStream>(){

                    @Override
                    public InputStream execute(boolean isRefresh) throws YfyException {
                        List headers = YfyInternalClient.this.addApiHeaders(isRefresh);
                        return YfyInternalClient.this.doDownload(downloadUrl, headers, progressListener);
                    }
                });
            }
            return this.doDownload(downloadUrl, YfyRequestUtil.addDownloadCustomHeader(new ArrayList<HttpRequestor.Header>()), progressListener);
        }

        public InputStream doDownload(String downloadUrl, List<HttpRequestor.Header> headers, YfyProgressListener progressListener) throws YfyException {
            try {
                HttpRequestor.Response response = YfyClient.this.requestConfig.getHttpRequestor().doGet(downloadUrl, headers);
                if (response.getStatusCode() != 200) {
                    throw YfyRequestUtil.unexpectedStatus(response);
                }
                if (progressListener != null) {
                    return new ProgressInputStream(response.getBody(), progressListener, response.getContentLength());
                }
                return response.getBody();
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
            catch (JsonReadException ex) {
                throw new BadResponseException("Bad JSON in response : " + ex.getMessage(), ex);
            }
        }

        public <T> T doPost(final String path, final Object[] listParams, final YfyArg arg, final Class<T> tClass) throws YfyException {
            return this.executeRetriable(new RetriableExecution<T>(){

                @Override
                public T execute(boolean isRefresh) throws YfyException {
                    List headers = YfyInternalClient.this.addApiHeaders(isRefresh);
                    return YfyRequestUtil.doPostNoAuth(YfyClient.this.requestConfig, YfyClient.this.host.getApi(), String.format(path, listParams), arg, headers, tClass);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public YfyFile doUpload(String uploadUrl, InputStream fileStream, long fileSize, YfyProgressListener progressListener) throws YfyException {
            ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
            headers.add(new HttpRequestor.Header("Content-Type", "multipart/form-data; boundary=--WebKitFormBoundaryPjbcBBB6fBCxfBFq"));
            HttpRequestor.Uploader uploader = YfyClient.this.requestConfig.getHttpRequestor().startPostWithStreaming(uploadUrl, headers);
            try {
                OutputStream outputStream = uploader.getBody();
                if (progressListener != null) {
                    outputStream = new ProgressOutputStream(outputStream, progressListener, fileSize);
                }
                this.writeMultipartData(outputStream, fileStream);
                YfyFile yfyFile = YfyRequestUtil.finishResponse(uploader.finish(), YfyFile.class);
                uploader.close();
                return yfyFile;
            }
            catch (Throwable throwable) {
                try {
                    uploader.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NetworkIOException(ex);
                }
            }
        }

        private void writeMultipartData(OutputStream outputStream, InputStream fileStream) throws IOException {
            StringBuilder sb = new StringBuilder(BOUNDARY_STR);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data; name=\"file\"; filename=\"\"\r\n");
            sb.append("Content-Type: application/octet-stream");
            sb.append("\r\n\r\n");
            outputStream.write(StringUtil.stringToUtf8(sb.toString()));
            try {
                IOUtil.copyStreamToStream(fileStream, outputStream);
                outputStream.write(StringUtil.stringToUtf8("\r\n----WebKitFormBoundaryPjbcBBB6fBCxfBFq--"));
            }
            catch (IOUtil.ReadException ex) {
                throw ex.getCause();
            }
            finally {
                outputStream.close();
            }
        }

        private List<HttpRequestor.Header> addApiHeaders(boolean isRefresh) throws NeedAuthorizationException {
            ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
            YfyRequestUtil.addAuthHeader(headers, this.lockAccessToken(isRefresh));
            YfyRequestUtil.addApiCustomHeader(headers, USER_AGENT_ID);
            return headers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String lockAccessToken(boolean isRefresh) throws NeedAuthorizationException {
            if (isRefresh) {
                YfyClient.this.refreshLock.writeLock().lock();
                try {
                    if (this.isRefreshJustNow()) return YfyClient.this.accessToken;
                    YfyClient.this.refresh();
                    return YfyClient.this.accessToken;
                }
                finally {
                    YfyClient.this.refreshLock.writeLock().unlock();
                }
            } else {
                YfyClient.this.refreshLock.readLock().lock();
                YfyClient.this.refreshLock.readLock().unlock();
            }
            return YfyClient.this.accessToken;
        }

        private boolean isRefreshJustNow() {
            return System.currentTimeMillis() - YfyClient.this.lastRefresh < 600000L;
        }

        private <T> T executeRetriable(RetriableExecution<T> execution) throws YfyException {
            int maxRetries = 1;
            int retries = 0;
            boolean isRefresh = false;
            while (true) {
                try {
                    return execution.execute(isRefresh);
                }
                catch (YfyException ex) {
                    if (ex instanceof InvalidTokenException && this.canRefresh()) {
                        if (retries < maxRetries) {
                            ++retries;
                            isRefresh = true;
                            continue;
                        }
                        throw new NeedAuthorizationException("The user need authorization again");
                    }
                    throw ex;
                }
                break;
            }
        }
    }
}

