/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.collab;

import com.fangcloud.sdk.YfyBaseClient;
import com.fangcloud.sdk.api.AccessibleByTypeEnum;
import com.fangcloud.sdk.api.CollabRoleEnum;
import com.fangcloud.sdk.api.SuccessResult;
import com.fangcloud.sdk.api.collab.InviteCollabArg;
import com.fangcloud.sdk.api.collab.UpdateCollabArg;
import com.fangcloud.sdk.api.collab.YfyCollab;
import com.fangcloud.sdk.exception.YfyException;

public class YfyCollabRequest {
    private static final String COLLAB_PATH = "api/v2/collab/";
    private static final String COLLAB_INFO_PATH = "api/v2/collab/%s/info";
    private static final String INVITE_COLLAB_PATH = "api/v2/collab/invite";
    private static final String UPDATE_COLLAB_PATH = "api/v2/collab/%s/update";
    private static final String DELETE_COLLAB_PATH = "api/v2/collab/%s/delete";
    private final YfyBaseClient.YfyInternalClient client;

    public YfyCollabRequest(YfyBaseClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyCollab getCollab(long collabId) throws YfyException {
        String[] params = new String[]{String.valueOf(collabId)};
        return this.getCollab(params);
    }

    private YfyCollab getCollab(String[] params) throws YfyException {
        return this.client.doGet(COLLAB_INFO_PATH, params, null, YfyCollab.class);
    }

    public YfyCollab inviteCollab(long folderId, AccessibleByTypeEnum accessibleByType, long accessibleById, CollabRoleEnum collabRole, String invitationMessage) throws YfyException {
        return this.inviteCollab(new InviteCollabArg(folderId, accessibleByType.getType(), accessibleById, collabRole.getRole(), invitationMessage));
    }

    private YfyCollab inviteCollab(InviteCollabArg inviteCollabArg) throws YfyException {
        return this.client.doPost(INVITE_COLLAB_PATH, null, inviteCollabArg, YfyCollab.class);
    }

    public YfyCollab updateCollab(long collabId, CollabRoleEnum collabRole) throws YfyException {
        String[] params = new String[]{String.valueOf(collabId)};
        return this.updateCollab(params, new UpdateCollabArg(collabRole.getRole()));
    }

    private YfyCollab updateCollab(String[] params, UpdateCollabArg updateCollabArg) throws YfyException {
        return this.client.doPost(UPDATE_COLLAB_PATH, params, updateCollabArg, YfyCollab.class);
    }

    public SuccessResult deleteCollab(long collabId) throws YfyException {
        String[] params = new String[]{String.valueOf(collabId)};
        return this.deleteCollab(params);
    }

    private SuccessResult deleteCollab(String[] params) throws YfyException {
        return this.client.doPost(DELETE_COLLAB_PATH, params, null, SuccessResult.class);
    }
}

