/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.auth;

import com.fangcloud.sdk.YfyAppInfo;
import com.fangcloud.sdk.YfyRequestConfig;
import com.fangcloud.sdk.YfyRequestUtil;
import com.fangcloud.sdk.auth.YfyAuthFinish;
import com.fangcloud.sdk.exception.YfyException;
import com.fangcloud.sdk.util.StringUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class YfyEnterpriseAuth {
    private static final SecureRandom RAND = new SecureRandom();
    private final YfyRequestConfig requestConfig;
    private Map<String, Object> headers;
    private Key key;

    public YfyEnterpriseAuth(YfyRequestConfig requestConfig, final String kid, Key key) {
        if (requestConfig == null) {
            throw new NullPointerException("requestConfig");
        }
        if (kid == null) {
            throw new NullPointerException("kid");
        }
        this.requestConfig = requestConfig;
        this.headers = new HashMap<String, Object>(){
            {
                this.put("alg", "RS256");
                this.put("typ", "JWT");
                this.put("kid", kid);
            }
        };
        this.key = key;
    }

    public YfyAuthFinish getEnterpriseToken(long enterpriseId, int expirationTimeSeconds) throws YfyException {
        DefaultClaims claims = new DefaultClaims();
        claims.put((Object)"yifangyun_sub_type", (Object)"enterprise");
        claims.setSubject(String.valueOf(enterpriseId));
        claims.setExpiration(this.getExpirationTimeSecondsInTheFuture(expirationTimeSeconds));
        claims.setIssuedAt(new Date());
        claims.setId(this.getGeneratedJwtId(16));
        final String compactJws = Jwts.builder().setHeader(this.headers).setClaims((Claims)claims).signWith(SignatureAlgorithm.RS256, this.key).compact();
        return YfyRequestUtil.doPostInAuth(this.requestConfig, YfyAppInfo.getHost().getAuth(), "oauth/token", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("grant_type", "jwt");
                this.put("assertion", compactJws);
            }
        }, YfyAuthFinish.class);
    }

    public YfyAuthFinish getEnterpriseToken(long enterpriseId) throws YfyException {
        return this.getEnterpriseToken(enterpriseId, 60);
    }

    public YfyAuthFinish getUserToken(long userId, int expirationTimeSeconds) throws YfyException {
        DefaultClaims claims = new DefaultClaims();
        claims.put((Object)"yifangyun_sub_type", (Object)"user");
        claims.setSubject(String.valueOf(userId));
        claims.setExpiration(this.getExpirationTimeSecondsInTheFuture(expirationTimeSeconds));
        claims.setIssuedAt(new Date());
        claims.setId(this.getGeneratedJwtId(16));
        final String compactJws = Jwts.builder().setHeader(this.headers).setClaims((Claims)claims).signWith(SignatureAlgorithm.RS256, this.key).compact();
        return YfyRequestUtil.doPostInAuth(this.requestConfig, YfyAppInfo.getHost().getAuth(), "oauth/token", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("grant_type", "jwt");
                this.put("assertion", compactJws);
            }
        }, YfyAuthFinish.class);
    }

    public YfyAuthFinish getUserToken(long userId) throws YfyException {
        return this.getUserToken(userId, 60);
    }

    private Date getExpirationTimeSecondsInTheFuture(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    private String getGeneratedJwtId(int numberOfBytes) {
        byte[] csrf = new byte[numberOfBytes];
        RAND.nextBytes(csrf);
        return StringUtil.urlSafeBase64Encode(csrf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadPrivateKey(InputStream fileStream) throws Exception {
        String privateKeyPEM;
        try (InputStreamReader reader = new InputStreamReader(fileStream);){
            StringBuilder stringBuilder = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(2048);
            while (((Reader)reader).read(buffer) != -1) {
                buffer.flip();
                stringBuilder.append(buffer);
                buffer.clear();
            }
            privateKeyPEM = stringBuilder.toString();
        }
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] privateKeyDER = Base64.decodeBase64((String)privateKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyDER));
        return privateKey;
    }
}

