/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.BillRequest;
import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Bills {
    private String ERROR = "Error processing request, please check logs";

    public Response runTransaction(BillRequest billRequest) {
        return Optional.of(Utility.post(Properties.getProperty("BILL_BASE"), billRequest.toString(), ChargeTypes.BILLS, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runBulkTransaction(List<BillRequest> billRequests) {
        return Optional.of(Utility.post(Properties.getProperty("BULK_BILL_ENDPOINT"), billRequests.toString(), ChargeTypes.BILLS, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response getStatus(String reference) {
        return Optional.of(Utility.get(Properties.getProperty("BILL_BASE") + "/" + reference, ChargeTypes.BILLS, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse getBills(String from, String to) {
        return Optional.of(Utility.get(Properties.getProperty("BILL_BASE") + "/?from=" + from + "&to=" + to, ChargeTypes.BILLS, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response validateBillService(String item_code, String code, String customer) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("code", code));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("customer", customer));
        return Optional.of(Utility.get(Properties.getProperty("VALIDATE_BILL_SERVICE_ENDPOINT") + item_code + "/validate", ChargeTypes.BILLS, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse getCategories(Optional<Integer> airtime, Optional<Integer> data_bundle, Optional<Integer> power, Optional<Integer> internet, Optional<Integer> toll, Optional<Integer> cable, Optional<String> biller_code) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        airtime.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("airtime", s.toString())));
        data_bundle.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("data_bundle", s.toString())));
        power.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("power", s.toString())));
        internet.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("internet", s.toString())));
        toll.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("toll", s.toString())));
        cable.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("cable", s.toString())));
        biller_code.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("biller_code", s)));
        return Optional.of(Utility.get(Properties.getProperty("BILL_CATEGORY_ENDPOINT"), ChargeTypes.BILLS, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

