/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.client;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.Verb;
import com.flutterwave.metric.Metric;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class Client {
    public static String runTransaction(String url, String request, Verb type, ChargeTypes chargeType, List<NameValuePair> nameValuePairs) {
        StringBuilder result = new StringBuilder();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        Metric.send(chargeType);
        try {
            String line;
            if (nameValuePairs != null) {
                URI uri = new URIBuilder(url).addParameters(nameValuePairs).build();
                url = uri.toString();
            }
            System.out.println(url);
            CloseableHttpResponse closeableHttpResponse = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Verb.POST -> Client.setValues((HttpUriRequest)new HttpPost(url), client, request, type);
                case Verb.GET -> Client.setValues((HttpUriRequest)new HttpGet(url), client, request, type);
                case Verb.PUT -> Client.setValues((HttpUriRequest)new HttpPut(url), client, request, type);
                case Verb.DELETE -> Client.setValues((HttpUriRequest)new HttpDelete(url), client, request, type);
            };
            BufferedReader rd = new BufferedReader(new InputStreamReader(closeableHttpResponse.getEntity().getContent()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static CloseableHttpResponse setValues(HttpUriRequest httpUriRequest, CloseableHttpClient client, String request, Verb type) throws IOException {
        httpUriRequest.setHeader("Authorization", "Bearer " + System.getProperty("secretKey"));
        httpUriRequest.setHeader("Content-Type", "application/json");
        if (request != null) {
            StringEntity entity = new StringEntity(request);
            entity.setContentType(type.toString());
            if (type == Verb.POST) {
                HttpPost post = (HttpPost)httpUriRequest;
                post.setEntity((HttpEntity)entity);
                return client.execute((HttpUriRequest)post);
            }
            if (type == Verb.PUT) {
                HttpPut put = (HttpPut)httpUriRequest;
                put.setEntity((HttpEntity)entity);
                return client.execute((HttpUriRequest)put);
            }
        }
        return client.execute(httpUriRequest);
    }
}

