/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.PreAuthCommands;
import com.flutterwave.bean.PreAuthorizationRequest;
import com.flutterwave.bean.Response;
import com.flutterwave.services.Charge;
import java.math.BigDecimal;
import java.util.Optional;
import org.json.JSONObject;

public class PreAuthorization
extends Charge {
    public Response runTransaction(PreAuthorizationRequest preAuthorizationRequest) {
        return this.runTransaction(preAuthorizationRequest.toString(), ChargeTypes.CARD, true, Optional.empty());
    }

    public Response runCaptureTransaction(String flw_ref, BigDecimal amount) {
        return this.runTransaction(new JSONObject().put("amount", (Object)amount).toString(), ChargeTypes.CARD, true, Optional.of("/" + flw_ref + "/" + String.valueOf((Object)PreAuthCommands.capture)));
    }

    public Response runPaypalCaptureTransaction(String flw_ref) {
        return this.runTransaction(new JSONObject().put("flw_ref", (Object)flw_ref).toString(), ChargeTypes.CARD, true, Optional.of("/paypal-capture"));
    }

    public Response runVoidTransaction(String flw_ref) {
        return this.runTransaction(null, ChargeTypes.CARD, true, Optional.of("/" + flw_ref + "/" + PreAuthCommands.voId.toString().toLowerCase()));
    }

    public Response runPaypalVoidTransaction(String flw_ref) {
        return this.runTransaction(null, ChargeTypes.CARD, true, Optional.of("/" + flw_ref + "/paypal-void"));
    }

    public Response runRefundTransaction(String flw_ref, BigDecimal amount) {
        return this.runTransaction(new JSONObject().put("amount", (Object)amount).toString(), ChargeTypes.CARD, true, Optional.of("/" + flw_ref + "/" + String.valueOf((Object)PreAuthCommands.refund)));
    }
}

