/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.bean.Verb;
import com.flutterwave.client.Client;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Subscriptions {
    private String ERROR = "Error processing request, please check logs";

    public ListResponse getAllSubscriptions(Optional<String> email, Optional<Integer> transaction_id, Optional<Integer> plan, Optional<String> subscribed_from, Optional<String> subscribed_to, Optional<String> next_due_from, Optional<String> next_due_to, Optional<String> page, Optional<String> status) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        email.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("email", s)));
        transaction_id.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("transaction_id", s.toString())));
        plan.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("plan", s.toString())));
        subscribed_from.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("subscribed_from", s)));
        subscribed_to.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("subscribed_to", s)));
        next_due_from.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("next_due_from", s)));
        next_due_to.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("next_due_to", s)));
        page.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", s)));
        status.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("status", s)));
        return Optional.ofNullable(Client.runTransaction(Properties.getProperty("SUBSCRIPTION_BASE"), null, Verb.GET, ChargeTypes.SUBSCRIPTION, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response activateSubscription(int id) {
        return Optional.of(Utility.put(Properties.getProperty("SUBSCRIPTION_BASE") + "/" + id + "/activate", null, ChargeTypes.SUBSCRIPTION, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response deactivateSubscription(int id) {
        return Optional.of(Utility.put(Properties.getProperty("SUBSCRIPTION_BASE") + "/" + id + "/cancel", null, ChargeTypes.SUBSCRIPTION, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

