/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Transactions {
    private String ERROR = "Error processing request, please check logs";

    public Response runVerifyTransaction(int id) {
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/verify", ChargeTypes.VERIFY_TRANSACTION, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runGetTransactions(Optional<String> from, Optional<String> to, Optional<String> page, Optional<String> customer_email, Optional<String> status, Optional<String> tx_ref, Optional<String> customer_fullname, Optional<String> currency) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        from.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("from", (String)from.get())));
        to.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("to", (String)to.get())));
        page.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", (String)page.get())));
        customer_email.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("customer_email", (String)customer_email.get())));
        status.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("status", (String)status.get())));
        tx_ref.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("tx_ref", (String)tx_ref.get())));
        customer_fullname.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("customer_fullname", (String)customer_fullname.get())));
        currency.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("currency", (String)currency.get())));
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT"), ChargeTypes.GET_TRANSACTION, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetTransactionsFees(BigDecimal amount, String currency) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("amount", amount.toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("currency", currency));
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + "/fee", ChargeTypes.GET_TRANSACTION, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runResendWebhook(int id, Optional<Integer> wait) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        wait.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("wait", wait.toString())));
        return Optional.of(Utility.post(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/resend-hook", null, ChargeTypes.GET_TRANSACTION, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runViewTimeline(int id) {
        return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/events", ChargeTypes.GET_TRANSACTION, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public class Refunds {
        public ListResponse runGet(Optional<String> from, Optional<String> to, Optional<String> status, Optional<String> currency, Optional<String> id) {
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            from.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("from", (String)from.get())));
            to.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("to", (String)to.get())));
            currency.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("currency", (String)currency.get())));
            id.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("id", (String)id.get())));
            status.ifPresent(String2 -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("status", (String)status.get())));
            return Optional.of(Utility.get(Properties.getProperty("REFUND_ENDPOINT"), ChargeTypes.REFUND, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(Transactions.this.ERROR));
        }

        public Response runRefund(int id, Optional<BigDecimal> amount) {
            return Optional.of(Utility.post(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/refund", new JSONObject().put("amount", amount).toString(), ChargeTypes.REFUND, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(Transactions.this.ERROR));
        }

        public Response runGetDetails(int id) {
            return Optional.of(Utility.get(Properties.getProperty("VERIFY_TRANSACTION_ENDPOINT") + id + "/refund", ChargeTypes.REFUND, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(Transactions.this.ERROR));
        }
    }
}

