/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.Response;
import com.flutterwave.bean.Verb;
import com.flutterwave.client.Client;
import com.flutterwave.utility.Properties;
import java.util.Optional;

public class ValidateCharge {
    private String otp;
    private String flw_ref;
    private String type;
    private String ERROR = "Error processing request, please check logs";

    public ValidateCharge(String otp, String flw_ref, Optional<ChargeTypes> type) {
        this.otp = otp;
        this.flw_ref = flw_ref;
        type.ifPresent(chargeTypes -> {
            this.type = String.valueOf(chargeTypes);
        });
    }

    public Response runTransaction() {
        return Optional.ofNullable(Client.runTransaction(Properties.getProperty("VALIDATE_CHARGE_ENDPOINT"), this.toString(), Verb.POST, ChargeTypes.VALIDATE_CHARGE, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public String toString() {
        String value = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            value = objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getOtp() {
        return this.otp;
    }

    public String getFlw_ref() {
        return this.flw_ref;
    }

    public String getType() {
        return this.type;
    }

    public String getERROR() {
        return this.ERROR;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    public void setFlw_ref(String flw_ref) {
        this.flw_ref = flw_ref;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setERROR(String ERROR) {
        this.ERROR = ERROR;
    }

    public ValidateCharge() {
    }
}

