/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.Actions;
import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.FundVirtualCardRequest;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.bean.VirtualCardRequest;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class VirtualCard {
    private String ERROR = "Error processing request, please check logs";

    public Response runCreateVirtualCard(VirtualCardRequest virtualCardRequest) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_CARD_BASE"), virtualCardRequest.toString(), ChargeTypes.VIRTUAL_CARD, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runGetAllVirtualCards() {
        return Optional.of(Utility.get(Properties.getProperty("VIRTUAL_CARD_BASE"), ChargeTypes.VIRTUAL_CARD, null)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetVirtualCard(String id) {
        return Optional.of(Utility.get(Properties.getProperty("VIRTUAL_CARD_BASE") + "/" + id, ChargeTypes.VIRTUAL_CARD, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runFundVirtualCard(String id, FundVirtualCardRequest fundVirtualCardRequest) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_CARD_BASE") + "/" + id + "/fund", fundVirtualCardRequest.toString(), ChargeTypes.VIRTUAL_CARD, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runWithdrawVirtualCard(String id, BigDecimal amount) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_CARD_BASE") + "/" + id + "/withdraw", new JSONObject().put("amount", (Object)amount).toString(), ChargeTypes.VIRTUAL_CARD, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runStatusVirtualCard(String id, Actions actions) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_CARD_BASE") + "/" + id + "status/" + actions.name(), null, ChargeTypes.VIRTUAL_CARD, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runTerminateVirtualCard(String id) {
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_CARD_BASE") + "/" + id + "terminate", null, ChargeTypes.VIRTUAL_CARD, null)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public ListResponse runGetTransactions(String id, String from, String to, Integer index, Integer size) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("from", from));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("to", to));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("index", index.toString()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("size", size.toString()));
        return Optional.of(Utility.post(Properties.getProperty("VIRTUAL_CARD_BASE") + "/" + id, null, ChargeTypes.VIRTUAL_CARD, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

