/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.ClusterOptions;
import com.foundationdb.Database;
import com.foundationdb.DefaultDisposableImpl;
import com.foundationdb.Disposable;
import com.foundationdb.FDBException;
import com.foundationdb.FutureDatabase;
import com.foundationdb.OptionConsumer;
import java.util.concurrent.Executor;

public class Cluster
extends DefaultDisposableImpl
implements Disposable {
    private Executor executor;
    private ClusterOptions options;

    protected Cluster(long l, Executor executor) {
        super(l);
        this.executor = executor;
        this.options = new ClusterOptions(new OptionConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOption(int n, byte[] byArray) {
                Cluster.this.pointerReadLock.lock();
                try {
                    Cluster.this.Cluster_setOption(Cluster.this.getPtr(), n, byArray);
                }
                finally {
                    Cluster.this.pointerReadLock.unlock();
                }
            }
        });
    }

    public ClusterOptions options() {
        return this.options;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database openDatabase(byte[] byArray) throws FDBException {
        FutureDatabase futureDatabase = null;
        this.pointerReadLock.lock();
        try {
            futureDatabase = new FutureDatabase(this.Cluster_createDatabase(this.getPtr(), byArray), this.executor);
        }
        finally {
            this.pointerReadLock.unlock();
        }
        return (Database)futureDatabase.get();
    }

    @Override
    protected void disposeInternal(long l) {
        this.Cluster_dispose(l);
    }

    private native void Cluster_dispose(long var1);

    private native long Cluster_createDatabase(long var1, byte[] var3);

    private native void Cluster_setOption(long var1, int var3, byte[] var4) throws FDBException;
}

