/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.Disposable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class DefaultDisposableImpl
implements Disposable {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock pointerReadLock = this.rwl.readLock();
    private boolean disposed = false;
    private long cPtr;

    public DefaultDisposableImpl() {
    }

    public DefaultDisposableImpl(long l) {
        this.cPtr = l;
        if (this.cPtr == 0L) {
            this.disposed = true;
        }
    }

    public boolean isDisposed() {
        assert (this.rwl.getReadHoldCount() > 0);
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.rwl.writeLock().lock();
        long l = 0L;
        try {
            if (this.disposed) {
                return;
            }
            l = this.cPtr;
            this.cPtr = 0L;
            this.disposed = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.disposeInternal(l);
    }

    protected long getPtr() {
        assert (this.rwl.getReadHoldCount() > 0);
        if (this.disposed) {
            throw new IllegalStateException("Cannot access disposed object");
        }
        return this.cPtr;
    }

    protected abstract void disposeInternal(long var1);
}

