/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.FDBException;
import com.foundationdb.async.AbstractFuture;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.Executor;

abstract class NativeFuture<T>
extends AbstractFuture<T> {
    protected final long cPtr;
    private final Object valueLock = new Object();
    private boolean valueSet = false;
    private T value;
    FutureChannel blockChannel = new FutureChannel();

    protected NativeFuture(long l, Executor executor) {
        super(executor);
        this.cPtr = l;
    }

    @Override
    protected void registerSingleCallback(Runnable runnable) {
        if (this.isDone()) {
            runnable.run();
        } else {
            this.Future_registerCallback(this.cPtr, runnable);
        }
    }

    @Override
    public void blockInterruptibly() throws InterruptedException {
        if (this.isDone()) {
            return;
        }
        this.blockChannel.blockUntilReady();
    }

    @Override
    public void blockUntilReady() {
        this.Future_blockUntilReady(this.cPtr);
    }

    @Override
    public boolean isDone() {
        return this.Future_isReady(this.cPtr);
    }

    @Override
    public boolean isError() {
        int n = this.Future_getError(this.cPtr).getCode();
        if (n == 1102) {
            throw new RuntimeException("");
        }
        return n != 0 && n != 2015 && n != 1102;
    }

    @Override
    public FDBException getError() {
        FDBException fDBException = this.Future_getError(this.cPtr);
        int n = fDBException.getCode();
        if (n == 2015) {
            throw new IllegalStateException("Future not ready");
        }
        if (n == 1102 || n == 0) {
            throw new IllegalStateException("Future set to value, not error");
        }
        return fDBException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T getIfDone() {
        Object object;
        block10: {
            try {
                object = this.getIfDone_internal();
                Object object2 = this.valueLock;
                synchronized (object2) {
                    this.value = object;
                    this.valueSet = true;
                }
                this.Future_releaseMemory(this.cPtr);
            }
            catch (FDBException fDBException) {
                if (fDBException.getCode() == 2015) {
                    throw new IllegalStateException("Future not ready");
                }
                if (fDBException.getCode() == 1102) break block10;
                throw fDBException;
            }
        }
        object = this.valueLock;
        synchronized (object) {
            if (!this.valueSet) {
                throw new IllegalStateException("Future value accessed after disposal");
            }
            return this.value;
        }
    }

    abstract T getIfDone_internal() throws FDBException;

    @Override
    public void cancel() {
        this.Future_cancel(this.cPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.Future_releaseMemory(this.cPtr);
        Object object = this.valueLock;
        synchronized (object) {
            this.value = null;
            this.valueSet = false;
        }
    }

    protected void finalize() throws Throwable {
        this.Future_dispose(this.cPtr);
    }

    private native void Future_registerCallback(long var1, Runnable var3);

    private native void Future_blockUntilReady(long var1);

    private native boolean Future_isReady(long var1);

    private native void Future_dispose(long var1);

    private native void Future_cancel(long var1);

    private native void Future_releaseMemory(long var1);

    protected native FDBException Future_getError(long var1);

    private final class FutureChannel
    extends AbstractInterruptibleChannel {
        private FutureChannel() {
        }

        @Override
        protected void implCloseChannel() throws IOException {
            NativeFuture.this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void blockUntilReady() throws InterruptedException {
            boolean bl = false;
            try {
                this.begin();
                NativeFuture.this.Future_blockUntilReady(NativeFuture.this.cPtr);
                bl = true;
            }
            finally {
                try {
                    this.end(bl);
                }
                catch (AsynchronousCloseException asynchronousCloseException) {
                    throw new InterruptedException();
                }
            }
        }
    }
}

