/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb;

import com.foundationdb.Database;
import com.foundationdb.Disposable;
import com.foundationdb.FDBException;
import com.foundationdb.MutationType;
import com.foundationdb.Range;
import com.foundationdb.ReadTransaction;
import com.foundationdb.TransactionContext;
import com.foundationdb.TransactionOptions;
import com.foundationdb.async.Cancellable;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.PartialFunction;
import com.foundationdb.async.PartialFuture;

public interface Transaction
extends Cancellable,
Disposable,
ReadTransaction,
TransactionContext {
    public ReadTransaction snapshot();

    public void setReadVersion(long var1);

    public void addReadConflictRange(byte[] var1, byte[] var2);

    public void addReadConflictKey(byte[] var1);

    public void addWriteConflictRange(byte[] var1, byte[] var2);

    public void addWriteConflictKey(byte[] var1);

    public void set(byte[] var1, byte[] var2);

    public void clear(byte[] var1);

    public void clear(byte[] var1, byte[] var2);

    public void clear(Range var1);

    @Deprecated
    public void clearRangeStartsWith(byte[] var1);

    public void mutate(MutationType var1, byte[] var2, byte[] var3);

    public TransactionOptions options();

    public Future<Void> commit();

    public Long getCommittedVersion();

    public Future<Void> onError(RuntimeException var1);

    public PartialFuture<Void> onError(Exception var1);

    public void reset();

    @Override
    public void cancel();

    public Future<Void> watch(byte[] var1) throws FDBException;

    public Database getDatabase();

    @Override
    public <T> T run(Function<? super Transaction, T> var1);

    @Override
    public <T> T run(PartialFunction<? super Transaction, T> var1) throws Exception;

    @Override
    public <T> Future<T> runAsync(Function<? super Transaction, Future<T>> var1);

    @Override
    public <T> PartialFuture<T> runAsync(PartialFunction<? super Transaction, ? extends PartialFuture<T>> var1);
}

