/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.async;

import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.ReadyPartialFuture;
import java.util.concurrent.Executor;

public class ReadyFuture<T>
extends ReadyPartialFuture<T>
implements Future<T> {
    public static final Future<Void> DONE = new ReadyFuture<Void>((Void)null);

    public ReadyFuture(T t) {
        super(t);
    }

    public ReadyFuture(Error error) {
        super(error);
    }

    public ReadyFuture(RuntimeException runtimeException) {
        super(runtimeException);
    }

    public ReadyFuture(T t, Executor executor) {
        super(t, executor);
    }

    public ReadyFuture(Error error, Executor executor) {
        super(error, executor);
    }

    public ReadyFuture(RuntimeException runtimeException, Executor executor) {
        super(runtimeException, executor);
    }

    @Override
    public T get() {
        try {
            return super.get();
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw (RuntimeException)throwable;
        }
    }

    @Override
    public T getInterruptibly() {
        return this.get();
    }

    @Override
    public <V> Future<V> map(Function<? super T, V> function) {
        try {
            V v = function.apply(this.get());
            return new ReadyFuture<V>(v, this.executor);
        }
        catch (RuntimeException runtimeException) {
            return new ReadyFuture<T>(runtimeException, this.executor);
        }
    }

    @Override
    public <V> Future<V> flatMap(Function<? super T, Future<V>> function) {
        try {
            return function.apply(this.get());
        }
        catch (RuntimeException runtimeException) {
            return new ReadyFuture<T>(runtimeException, this.executor);
        }
    }

    @Override
    public Future<T> rescueRuntime(Function<? super RuntimeException, Future<T>> function) {
        if (!this.isError()) {
            return new ReadyFuture<T>(this.get(), this.executor);
        }
        try {
            Throwable throwable = this.getError();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return function.apply((RuntimeException)throwable);
        }
        catch (RuntimeException runtimeException) {
            return new ReadyFuture<T>(runtimeException, this.executor);
        }
    }
}

