/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.tuple;

import com.foundationdb.Range;
import com.foundationdb.tuple.ByteArrayUtil;
import com.foundationdb.tuple.TupleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Tuple
implements Comparable<Tuple>,
Iterable<Object> {
    private List<Object> elements;

    private Tuple(List<? extends Object> list, Object object) {
        this(new LinkedList<Object>(list));
        this.elements.add(object);
    }

    private Tuple(List<? extends Object> list) {
        this.elements = new ArrayList<Object>(list);
    }

    public Tuple addObject(Object object) {
        if (!(object == null || object instanceof String || object instanceof byte[] || object instanceof Number)) {
            throw new IllegalArgumentException("Parameter type (" + object.getClass().getName() + ") not recognized");
        }
        return new Tuple(this.elements, object);
    }

    public Tuple add(String string) {
        return new Tuple(this.elements, string);
    }

    public Tuple add(long l) {
        return new Tuple(this.elements, l);
    }

    public Tuple add(byte[] byArray) {
        return new Tuple(this.elements, byArray);
    }

    public Tuple add(byte[] byArray, int n, int n2) {
        return new Tuple(this.elements, Arrays.copyOfRange(byArray, n, n + n2));
    }

    public Tuple addAll(List<? extends Object> list) {
        ArrayList<? extends Object> arrayList = new ArrayList<Object>(list.size() + this.elements.size());
        arrayList.addAll(this.elements);
        arrayList.addAll(list);
        return new Tuple(arrayList);
    }

    public Tuple addAll(Tuple tuple) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.size() + tuple.size());
        arrayList.addAll(this.elements);
        arrayList.addAll(tuple.peekItems());
        return new Tuple(arrayList);
    }

    public byte[] pack() {
        return TupleUtil.pack(this.elements);
    }

    public List<Object> getItems() {
        return new ArrayList<Object>(this.elements);
    }

    private List<Object> peekItems() {
        return this.elements;
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.elements).iterator();
    }

    public Tuple() {
        this.elements = new LinkedList<Object>();
    }

    public static Tuple fromBytes(byte[] byArray) {
        return Tuple.fromBytes(byArray, 0, byArray.length);
    }

    public static Tuple fromBytes(byte[] byArray, int n, int n2) {
        Tuple tuple = new Tuple();
        tuple.elements = TupleUtil.unpack(byArray, n, n2);
        return tuple;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public long getLong(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            throw new NullPointerException("Number types in Tuples may not be null");
        }
        return (Long)object;
    }

    public byte[] getBytes(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        return (byte[])object;
    }

    public String getString(int n) {
        Object object = this.elements.get(n);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public Object get(int n) {
        return this.elements.get(n);
    }

    public Tuple popFront() {
        if (this.elements.size() == 0) {
            throw new IllegalStateException("Tuple contains no elements");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.elements.size() - 1);
        for (int i = 1; i < this.elements.size(); ++i) {
            arrayList.add(this.elements.get(i));
        }
        return new Tuple(arrayList);
    }

    public Tuple popBack() {
        if (this.elements.size() == 0) {
            throw new IllegalStateException("Tuple contains no elements");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.elements.size() - 1);
        for (int i = 0; i < this.elements.size() - 1; ++i) {
            arrayList.add(this.elements.get(i));
        }
        return new Tuple(arrayList);
    }

    public Range range() {
        byte[] byArray = this.pack();
        return new Range(ByteArrayUtil.join(byArray, {0}), ByteArrayUtil.join(byArray, {-1}));
    }

    @Override
    public int compareTo(Tuple tuple) {
        return ByteArrayUtil.compareUnsigned(this.pack(), tuple.pack());
    }

    public int hashCode() {
        return Arrays.hashCode(this.pack());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Tuple) {
            return Arrays.equals(this.pack(), ((Tuple)object).pack());
        }
        return false;
    }

    public static Tuple fromItems(Iterable<? extends Object> iterable) {
        Tuple tuple = new Tuple();
        for (Object object : iterable) {
            tuple = tuple.addObject(object);
        }
        return tuple;
    }

    public static Tuple fromList(List<? extends Object> list) {
        return new Tuple(list);
    }

    public static Tuple from(Object ... objectArray) {
        return Tuple.fromList(Arrays.asList(objectArray));
    }

    static void main(String[] stringArray) {
        for (int n : new int[]{10, 100, 1000, 10000, 100000, 1000000}) {
            Tuple.createTuple(n);
        }
        Object object = new Tuple();
        object = ((Tuple)object).add(Long.MAX_VALUE);
        object = ((Tuple)object).add(0x7FFFFFFFFFFFFFFEL);
        object = ((Tuple)object).add(0x7FFFFFFFFFFFFFFDL);
        object = ((Tuple)object).add(1L);
        object = ((Tuple)object).add(0L);
        object = ((Tuple)object).add(-1L);
        object = ((Tuple)object).add(-9223372036854775806L);
        object = ((Tuple)object).add(-9223372036854775807L);
        object = ((Tuple)object).add(Long.MIN_VALUE);
        object = ((Tuple)object).add("foo");
        byte[] byArray = ((Tuple)object).pack();
        System.out.println("Packed: " + ByteArrayUtil.printable(byArray));
        List<Object> list = Tuple.fromBytes(byArray).getItems();
        for (Object object2 : list) {
            System.out.println(" -> type: (" + object2.getClass().getName() + "): " + object2);
        }
    }

    private static Tuple createTuple(int n) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new byte[]{99});
        }
        long l = System.currentTimeMillis();
        Tuple tuple = Tuple.fromList(arrayList);
        tuple.pack();
        System.out.println("Took " + (System.currentTimeMillis() - l) + " ms for " + n + " (" + arrayList.size() + ")");
        return tuple;
    }
}

