/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.CloseableIterable;
import ix.CloseableIterator;
import ix.Enumerable;
import ix.Enumerator;
import ix.GroupedIterable;
import ix.Pair;
import ix.internal.operators.AggregateIterable;
import ix.internal.operators.AllIterable;
import ix.internal.operators.AnyIterable;
import ix.internal.operators.BufferIterable;
import ix.internal.operators.CastIterable;
import ix.internal.operators.ConcatIterable;
import ix.internal.operators.CountIterable;
import ix.internal.operators.DeferIterable;
import ix.internal.operators.DematerializeIterable;
import ix.internal.operators.DoOnCompletedIterable;
import ix.internal.operators.DoOnEachIterable;
import ix.internal.operators.DoOnNextIterable;
import ix.internal.operators.DoWhileIterable;
import ix.internal.operators.EnumerationToIterator;
import ix.internal.operators.ErrorIterable;
import ix.internal.operators.FilterIndexedIterable;
import ix.internal.operators.FlatMapIterable;
import ix.internal.operators.GenerateIterable;
import ix.internal.operators.GenerateIterableTimed;
import ix.internal.operators.IteratorToEnumerator;
import ix.internal.operators.JustIterable;
import ix.internal.operators.LongCountIterable;
import ix.internal.operators.LongRangeIterable;
import ix.internal.operators.MapIndexedIterable;
import ix.internal.operators.MaterializeIterable;
import ix.internal.operators.MemoizeAllIterable;
import ix.internal.operators.MemoizeIterable;
import ix.internal.operators.MergeIterable;
import ix.internal.operators.MinMaxIterable;
import ix.internal.operators.OnErrorResumeNext;
import ix.internal.operators.OnErrorResumeNextIterable;
import ix.internal.operators.OrderByIterable;
import ix.internal.operators.PartialIterable;
import ix.internal.operators.PrintAction1;
import ix.internal.operators.RangeIterable;
import ix.internal.operators.RepeatCountIterable;
import ix.internal.operators.RepeatIterable;
import ix.internal.operators.RetryIterable;
import ix.internal.operators.ScanIterable;
import ix.internal.operators.ShareIterable;
import ix.internal.operators.ShareSelectorIterable;
import ix.internal.operators.SkipLastIterable;
import ix.internal.operators.SubsequentCountIterable;
import ix.internal.operators.SubsequentIterable;
import ix.internal.operators.SwitchCaseIterable;
import ix.internal.operators.TakeIterable;
import ix.internal.operators.TakeLastIterable;
import ix.internal.operators.UsingIterable;
import ix.internal.operators.ZipIterable;
import ix.internal.util.IxHelperFunctions;
import ix.internal.util.LinkedBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Notification;
import rx.Scheduler;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Functions;
import rx.schedulers.Schedulers;

public final class Interactive {
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };
    private static final Iterable<Object> EMPTY_ITERABLE = new Iterable<Object>(){

        @Override
        public Iterator<Object> iterator() {
            return EMPTY_ITERATOR;
        }
    };

    public static <T, U, V> Iterable<V> aggregate(Iterable<? extends T> source, Func2<? super U, ? super T, ? extends U> sum, Func2<? super U, ? super Integer, ? extends V> divide) {
        return new AggregateIterable<V, T, U>(source, sum, divide);
    }

    public static <T> Iterable<Boolean> all(Iterable<? extends T> source, Func1<? super T, Boolean> predicate) {
        return new AllIterable<T>(source, predicate);
    }

    public static <T> Iterable<Boolean> any(Iterable<? extends T> source, Func1<? super T, Boolean> predicate) {
        return Interactive.any(Interactive.filter(source, predicate));
    }

    public static <T> Iterable<Boolean> any(Iterable<T> source) {
        return new AnyIterable<T>(source);
    }

    public static <T, V extends Comparable<? super V>> Pair<T, V> argAndMax(Iterable<? extends T> source, Func1<? super T, ? extends V> valueSelector) {
        return Interactive.argAndMax(source, valueSelector, IxHelperFunctions.comparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, V> Pair<T, V> argAndMax(Iterable<? extends T> source, Func1<? super T, ? extends V> valueSelector, Comparator<? super V> valueComparator) {
        Object arg = null;
        Object max = null;
        boolean hasElement = false;
        Iterator<T> it = source.iterator();
        try {
            while (it.hasNext()) {
                T item = it.next();
                Object itemValue = valueSelector.call(item);
                if (!hasElement || valueComparator.compare(max, itemValue) < 0) {
                    arg = item;
                    max = itemValue;
                }
                hasElement = true;
            }
            if (hasElement) {
                Pair<Object, Object> pair = Pair.of(arg, max);
                return pair;
            }
        }
        finally {
            Interactive.unsubscribe(it);
        }
        return null;
    }

    public static <T, V extends Comparable<? super V>> Pair<T, V> argAndMin(Iterable<? extends T> source, Func1<? super T, ? extends V> valueSelector) {
        return Interactive.argAndMin(source, valueSelector, IxHelperFunctions.comparator());
    }

    public static <T, V> Pair<T, V> argAndMin(Iterable<? extends T> source, Func1<? super T, ? extends V> valueSelector, final Comparator<? super V> valueComparator) {
        return Interactive.argAndMax(source, valueSelector, new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                return valueComparator.compare(o2, o1);
            }
        });
    }

    public static Iterable<BigDecimal> averageBigDecimal(Iterable<BigDecimal> source) {
        return Interactive.aggregate(source, new Func2<BigDecimal, BigDecimal, BigDecimal>(){

            public BigDecimal call(BigDecimal param1, BigDecimal param2) {
                return param1 != null ? param1.add(param2) : param2;
            }
        }, new Func2<BigDecimal, Integer, BigDecimal>(){

            public BigDecimal call(BigDecimal param1, Integer param2) {
                return param1.divide(new BigDecimal(param2), 4);
            }
        });
    }

    public static Iterable<BigDecimal> averageBigInteger(Iterable<BigInteger> source) {
        return Interactive.aggregate(source, new Func2<BigInteger, BigInteger, BigInteger>(){

            public BigInteger call(BigInteger param1, BigInteger param2) {
                return param1 != null ? param1.add(param2) : param2;
            }
        }, new Func2<BigInteger, Integer, BigDecimal>(){

            public BigDecimal call(BigInteger param1, Integer param2) {
                return new BigDecimal(param1).divide(new BigDecimal(param2), 4);
            }
        });
    }

    public static Iterable<Double> averageDouble(Iterable<Double> source) {
        return Interactive.aggregate(source, new Func2<Double, Double, Double>(){

            public Double call(Double param1, Double param2) {
                return param1 != null ? param1 + param2 : param2;
            }
        }, new Func2<Double, Integer, Double>(){

            public Double call(Double param1, Integer param2) {
                return param1 / (double)param2.intValue();
            }
        });
    }

    public static Iterable<Float> averageFloat(Iterable<Float> source) {
        return Interactive.aggregate(source, new Func2<Float, Float, Float>(){

            public Float call(Float param1, Float param2) {
                return Float.valueOf(param1 != null ? param1.floatValue() + param2.floatValue() : param2.floatValue());
            }
        }, new Func2<Float, Integer, Float>(){

            public Float call(Float param1, Integer param2) {
                return Float.valueOf(param1.floatValue() / (float)param2.intValue());
            }
        });
    }

    public static Iterable<Double> averageInt(Iterable<Integer> source) {
        return Interactive.aggregate(source, new Func2<Double, Integer, Double>(){

            public Double call(Double param1, Integer param2) {
                return param1 != null ? param1 + (double)param2.intValue() : param2.doubleValue();
            }
        }, new Func2<Double, Integer, Double>(){

            public Double call(Double param1, Integer param2) {
                return param1 / (double)param2.intValue();
            }
        });
    }

    public static Iterable<Double> averageLong(Iterable<Long> source) {
        return Interactive.aggregate(source, new Func2<Double, Long, Double>(){

            public Double call(Double param1, Long param2) {
                return param1 != null ? param1 + (double)param2.longValue() : param2.doubleValue();
            }
        }, new Func2<Double, Integer, Double>(){

            public Double call(Double param1, Integer param2) {
                return param1 / (double)param2.intValue();
            }
        });
    }

    public static <T> Iterable<List<T>> buffer(Iterable<? extends T> source, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize <= 0");
        }
        return new BufferIterable<T>(source, bufferSize);
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> sources) {
        return new ConcatIterable(sources);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> first, Iterable<? extends T> second) {
        LinkedList<Iterable<? extends T>> list = new LinkedList<Iterable<? extends T>>();
        list.add(first);
        list.add(second);
        return Interactive.concat(list);
    }

    public static <T> Iterable<Boolean> contains(Iterable<? extends T> source, final Object value) {
        return Interactive.any(source, new Func1<T, Boolean>(){

            public Boolean call(T param1) {
                return param1 == value || param1 != null && param1.equals(value);
            }
        });
    }

    public static <T> Iterable<Integer> count(Iterable<T> source) {
        return new CountIterable<T>(source);
    }

    public static <T> Iterable<Long> countLong(Iterable<T> source) {
        return new LongCountIterable<T>(source);
    }

    public static <T> Iterable<T> defer(Func0<? extends Iterable<T>> func) {
        return new DeferIterable(func);
    }

    public static <T> Iterable<T> dematerialize(Iterable<? extends Notification<? extends T>> source) {
        return new DematerializeIterable(source);
    }

    public static <T> Iterable<T> distinct(Iterable<? extends T> source) {
        return Interactive.distinct(source, Functions.identity(), Functions.identity());
    }

    public static <T, U, V> Iterable<V> distinct(Iterable<? extends T> source, final Func1<? super T, ? extends U> keySelector, final Func1<? super T, ? extends V> valueSelector) {
        return Interactive.map(Interactive.filterIndexed(source, new Func0<Func2<Integer, T, Boolean>>(){

            public Func2<Integer, T, Boolean> call() {
                return new Func2<Integer, T, Boolean>(){
                    final Set<U> memory = new HashSet();

                    public Boolean call(Integer index, T param1) {
                        return this.memory.add(keySelector.call(param1));
                    }
                };
            }
        }), new Func1<T, V>(){

            public V call(T param1) {
                return valueSelector.call(param1);
            }
        });
    }

    public static <T> Iterable<T> distinctNext(Iterable<? extends T> source) {
        return Interactive.filterIndexed(source, new Func0<Func2<Integer, T, Boolean>>(){

            public Func2<Integer, T, Boolean> call() {
                return new Func2<Integer, T, Boolean>(){
                    boolean first = true;
                    T last;

                    public Boolean call(Integer index, T param1) {
                        if (this.first) {
                            this.first = false;
                            this.last = param1;
                            return true;
                        }
                        if (this.last == param1 || this.last != null && this.last.equals(param1)) {
                            this.last = param1;
                            return false;
                        }
                        this.last = param1;
                        return true;
                    }
                };
            }
        });
    }

    public static <T, U> Iterable<T> distinctNext(Iterable<? extends T> source, final Func1<T, U> keyExtractor) {
        return Interactive.filterIndexed(source, new Func0<Func2<Integer, T, Boolean>>(){

            public Func2<Integer, T, Boolean> call() {
                return new Func2<Integer, T, Boolean>(){
                    boolean first = true;
                    U last;

                    public Boolean call(Integer index, T param1) {
                        Object key = keyExtractor.call(param1);
                        if (this.first) {
                            this.first = false;
                            this.last = key;
                            return true;
                        }
                        if (this.last == key || this.last != null && this.last.equals(key)) {
                            this.last = key;
                            return false;
                        }
                        this.last = key;
                        return true;
                    }
                };
            }
        });
    }

    public static <T> Iterable<T> doOnNext(Iterable<? extends T> source, Action1<? super T> action) {
        return new DoOnNextIterable<T>(source, action);
    }

    public static <T> Iterable<T> doWhile(Iterable<? extends T> source, Func0<Boolean> gate) {
        return new DoWhileIterable<T>(source, gate);
    }

    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> iterator1 = iterable1.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        return Interactive.elementsEqual(iterator1, iterator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        try {
            while (iterator1.hasNext()) {
                Object o2;
                if (!iterator2.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                Object o1 = iterator1.next();
                if (Interactive.equal(o1, o2 = iterator2.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !iterator2.hasNext();
            return bl;
        }
        finally {
            Interactive.unsubscribe(iterator1);
            Interactive.unsubscribe(iterator2);
        }
    }

    public static <T> Iterable<T> empty() {
        return EMPTY_ITERABLE;
    }

    public static <T> Iterable<T> endWith(Iterable<? extends T> source, T value) {
        return Interactive.concat(source, Interactive.just(value));
    }

    private static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static <T> Notification<T> err(Throwable t) {
        return Notification.createOnError((Throwable)t);
    }

    public static <T> Iterable<T> doOnCompleted(Iterable<? extends T> source, Action0 action) {
        return new DoOnCompletedIterable<T>(action, source);
    }

    public static <T> T first(Iterable<? extends T> src) {
        return src.iterator().next();
    }

    public static <T, U> Iterable<U> flatMapAll(Iterable<? extends T> source, Func1<? super T, ? extends Iterable<? extends U>> selector) {
        return Interactive.concat(Interactive.map(source, selector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void forEach(Iterable<? extends T> source, Action1<? super T> action) {
        Iterator<T> iter = source.iterator();
        try {
            while (iter.hasNext()) {
                T t = iter.next();
                action.call(t);
            }
        }
        finally {
            Interactive.unsubscribe(iter);
        }
    }

    public static <T> Iterable<T> generate(T seed, Func1<? super T, Boolean> predicate, Func1<? super T, ? extends T> next) {
        return new GenerateIterable<T>(seed, next, predicate);
    }

    public static <T> Iterable<T> generate(T seed, Func1<? super T, Boolean> predicate, Func1<? super T, ? extends T> next, long initialDelay, long betweenDelay, TimeUnit unit) {
        return new GenerateIterableTimed<T>(predicate, next, seed, initialDelay, betweenDelay, unit);
    }

    public static <T, V> Iterable<GroupedIterable<V, T>> groupBy(Iterable<? extends T> source, Func1<? super T, ? extends V> keySelector) {
        return Interactive.groupBy(source, keySelector, Functions.identity());
    }

    public static <T, U, V> Iterable<GroupedIterable<V, U>> groupBy(final Iterable<? extends T> source, final Func1<? super T, ? extends V> keySelector, final Func1<? super T, ? extends U> valueSelector) {
        return Interactive.distinct(new Iterable<GroupedIterable<V, U>>(){

            @Override
            public Iterator<GroupedIterable<V, U>> iterator() {
                final LinkedHashMap groups = new LinkedHashMap();
                final Iterator it = source.iterator();
                return new Iterator<GroupedIterable<V, U>>(){
                    Iterator<GroupedIterable<V, U>> groupIt;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext() || this.groupIt != null && this.groupIt.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public GroupedIterable<V, U> next() {
                        if (this.hasNext()) {
                            if (this.groupIt == null) {
                                try {
                                    while (it.hasNext()) {
                                        Object t = it.next();
                                        Object v = keySelector.call(t);
                                        Object u = valueSelector.call(t);
                                        GroupedIterable<Object, Object> g = (GroupedIterable<Object, Object>)groups.get(v);
                                        if (g == null) {
                                            g = new GroupedIterable<Object, Object>(v);
                                            groups.put(v, g);
                                        }
                                        g.add(u);
                                    }
                                }
                                finally {
                                    Interactive.unsubscribe(it);
                                }
                                this.groupIt = groups.values().iterator();
                            }
                            return this.groupIt.next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Func1<GroupedIterable<V, U>, V>(){

            public V call(GroupedIterable<V, U> param1) {
                return param1.getKey();
            }
        }, Functions.identity());
    }

    public static <T> Iterable<T> doOnEach(Iterable<? extends T> source, Action1<? super T> next, Action0 finish) {
        return Interactive.doOnEach(source, next, (Action1<? super Throwable>)Actions.empty(), finish);
    }

    public static <T> Iterable<T> doOnEach(Iterable<? extends T> source, Action1<? super T> next, Action1<? super Throwable> error) {
        return Interactive.doOnEach(source, next, error, (Action0)Actions.empty());
    }

    public static <T> Iterable<T> doOnEach(Iterable<? extends T> source, Action1<? super T> next, Action1<? super Throwable> error, Action0 finish) {
        return new DoOnEachIterable<T>(error, finish, source);
    }

    public static Iterable<Boolean> isEmpty(Iterable<?> source) {
        return Interactive.map(Interactive.any(source), IxHelperFunctions.negate());
    }

    public static Iterable<String> join(Iterable<?> source, final String separator) {
        return Interactive.aggregate(source, new Func2<StringBuilder, Object, StringBuilder>(){

            public StringBuilder call(StringBuilder param1, Object param2) {
                if (param1 == null) {
                    param1 = new StringBuilder();
                } else {
                    param1.append(separator);
                }
                param1.append(param2);
                return param1;
            }
        }, new Func2<StringBuilder, Integer, String>(){

            public String call(StringBuilder param1, Integer param2) {
                return param1.toString();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T last(Iterable<? extends T> source) {
        Iterator<T> it = source.iterator();
        try {
            if (it.hasNext()) {
                T t = null;
                while (it.hasNext()) {
                    t = it.next();
                }
                T t2 = t;
                return t2;
            }
        }
        finally {
            Interactive.unsubscribe(it);
        }
        throw new NoSuchElementException();
    }

    public static <T, U> Iterable<U> map(Iterable<? extends T> source, final Func1<? super T, ? extends U> selector) {
        return Interactive.mapIndexed(source, new Func2<Integer, T, U>(){

            public U call(Integer param1, T param2) {
                return selector.call(param2);
            }
        });
    }

    public static <T, U> Iterable<U> mapIndexed(Iterable<? extends T> source, Func2<? super Integer, ? super T, ? extends U> selector) {
        return new MapIndexedIterable<U, T>(source, selector);
    }

    public static <T> Iterable<Notification<T>> materialize(Iterable<? extends T> source) {
        return new MaterializeIterable<T>(source);
    }

    /*
     * Exception decompiling
     */
    public static <T extends Comparable<? super T>> Iterable<T> max(Iterable<? extends T> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> Iterable<T> max(Iterable<? extends T> source, Comparator<? super T> comparator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends Comparable<? super T>> Iterable<List<T>> maxBy(Iterable<? extends T> source) {
        return Interactive.minMax(source, Functions.identity(), IxHelperFunctions.comparator(), true);
    }

    public static <T> Iterable<List<T>> maxBy(Iterable<? extends T> source, Comparator<? super T> comparator) {
        return Interactive.minMax(source, Functions.identity(), comparator, true);
    }

    public static <T, U extends Comparable<? super U>> Iterable<List<T>> maxBy(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return Interactive.minMax(source, keySelector, IxHelperFunctions.comparator(), true);
    }

    public static <T, U> Iterable<List<T>> maxBy(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<? super U> keyComparator) {
        return Interactive.minMax(source, keySelector, keyComparator, true);
    }

    public static <T> Iterable<T> memoize(Iterable<? extends T> source, int bufferSize) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize < 0");
        }
        return new MemoizeIterable<T>(source, bufferSize);
    }

    public static <T> Iterable<T> memoizeAll(Iterable<? extends T> source) {
        Iterator<? extends T> it = source.iterator();
        LinkedBuffer buffer = new LinkedBuffer();
        return new MemoizeAllIterable<T>(it, buffer);
    }

    public static <T> Iterable<T> merge(Iterable<? extends Iterable<? extends T>> sources) {
        return Interactive.merge(sources, Interactive.scheduler());
    }

    public static <T> Iterable<T> merge(Iterable<? extends Iterable<? extends T>> sources, Scheduler scheduler) {
        return new MergeIterable(scheduler, sources);
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> first, Iterable<? extends T> second) {
        ArrayList<Iterable<? extends T>> list = new ArrayList<Iterable<? extends T>>(2);
        list.add(first);
        list.add(second);
        return Interactive.merge(list);
    }

    /*
     * Exception decompiling
     */
    public static <T extends Comparable<? super T>> Iterable<T> min(Iterable<? extends T> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> Iterable<T> min(Iterable<? extends T> source, Comparator<? super T> comparator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends Comparable<? super T>> Iterable<List<T>> minBy(Iterable<? extends T> source) {
        return Interactive.minMax(source, Functions.identity(), IxHelperFunctions.comparator(), false);
    }

    public static <T> Iterable<List<T>> minBy(Iterable<? extends T> source, Comparator<? super T> comparator) {
        return Interactive.minMax(source, Functions.identity(), comparator, false);
    }

    public static <T, U extends Comparable<? super U>> Iterable<List<T>> minBy(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return Interactive.minMax(source, keySelector, IxHelperFunctions.comparator(), false);
    }

    public static <T, U> Iterable<List<T>> minBy(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<? super U> keyComparator) {
        return Interactive.minMax(source, keySelector, keyComparator, false);
    }

    static <T, U> Iterable<List<T>> minMax(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<? super U> keyComparator, boolean max) {
        return new MinMaxIterable<T, U>(keySelector, source, max, keyComparator);
    }

    public static <T> CloseableIterable<T> newCloseableIterable(final Iterable<? extends T> src, final Action0 close) {
        return new CloseableIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return Interactive.newCloseableIterator(src.iterator(), close);
            }
        };
    }

    public static <T> CloseableIterable<T> newCloseableIterable(final Iterable<? extends T> src, final Action1<? super Iterator<? extends T>> close) {
        return new CloseableIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return Interactive.newCloseableIterator(src.iterator(), close);
            }
        };
    }

    public static <T> CloseableIterable<T> newCloseableIterable(final Iterable<? extends T> src, final Closeable close) {
        return new CloseableIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return Interactive.newCloseableIterator(src.iterator(), close);
            }
        };
    }

    public static <T> CloseableIterator<T> newCloseableIterator(final Iterator<? extends T> src, final Action0 close) {
        return new CloseableIterator<T>(){
            final AtomicBoolean once = new AtomicBoolean();

            @Override
            public boolean hasNext() {
                return src.hasNext();
            }

            public boolean isUnsubscribed() {
                return this.once.get();
            }

            @Override
            public T next() {
                return src.next();
            }

            @Override
            public void remove() {
                src.remove();
            }

            public void unsubscribe() {
                if (this.once.compareAndSet(false, true)) {
                    close.call();
                }
            }
        };
    }

    public static <T> CloseableIterator<T> newCloseableIterator(final Iterator<? extends T> src, final Action1<? super Iterator<? extends T>> close) {
        return new CloseableIterator<T>(){
            final AtomicBoolean once = new AtomicBoolean();

            @Override
            public boolean hasNext() {
                return src.hasNext();
            }

            public boolean isUnsubscribed() {
                return this.once.get();
            }

            @Override
            public T next() {
                return src.next();
            }

            @Override
            public void remove() {
                src.remove();
            }

            public void unsubscribe() {
                if (this.once.compareAndSet(false, true)) {
                    close.call((Object)src);
                }
            }
        };
    }

    public static <T> CloseableIterator<T> newCloseableIterator(final Iterator<? extends T> src, final Closeable close) {
        return new CloseableIterator<T>(){
            final AtomicBoolean once = new AtomicBoolean();

            @Override
            public boolean hasNext() {
                return src.hasNext();
            }

            public boolean isUnsubscribed() {
                return this.once.get();
            }

            @Override
            public T next() {
                return src.next();
            }

            @Override
            public void remove() {
                src.remove();
            }

            public void unsubscribe() {
                if (this.once.compareAndSet(false, true)) {
                    try {
                        close.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static <T, U extends Iterator<T>> Iterable<T> newIterable(final Func0<U> body) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)body.call();
            }
        };
    }

    public static <T> Iterator<T> newIterator(final Func0<Boolean> hasNext, final Func0<? extends T> next) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return (Boolean)hasNext.call();
            }

            @Override
            public T next() {
                return next.call();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> newIterator(Func0<Boolean> hasNext, final Func0<? extends T> next, final Action0 remove) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return this.hasNext();
            }

            @Override
            public T next() {
                return next.call();
            }

            @Override
            public void remove() {
                remove.call();
            }
        };
    }

    static <T> Notification<T> none() {
        return Notification.createOnCompleted();
    }

    public static <T> Iterable<T> ofType(Iterable<?> source, Class<T> token) {
        return new CastIterable<T>(source, token);
    }

    public static <T> Iterable<T> onErrorResumeNext(Iterable<? extends T> source, Func1<? super Throwable, ? extends Iterable<? extends T>> handler) {
        return new OnErrorResumeNextIterable<T>(source, handler);
    }

    public static <T> Iterable<T> onErrorTerminate(Iterable<? extends T> source) {
        Iterable<T> e = Interactive.empty();
        return Interactive.onErrorResumeNext(source, IxHelperFunctions.constant(e));
    }

    public static <T extends Comparable<? super T>> Iterable<T> orderBy(Iterable<? extends T> source) {
        return Interactive.orderBy(source, Functions.identity(), IxHelperFunctions.comparator());
    }

    public static <T> Iterable<T> orderBy(Iterable<? extends T> source, Comparator<? super T> comparator) {
        return Interactive.orderBy(source, Functions.identity(), comparator);
    }

    public static <T, U extends Comparable<? super U>> Iterable<T> orderBy(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return Interactive.orderBy(source, keySelector, IxHelperFunctions.comparator());
    }

    public static <T, U> Iterable<T> orderBy(Iterable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<? super U> keyComparator) {
        return new OrderByIterable<T, U>(source, keyComparator, keySelector);
    }

    public static <T> Action1<T> print() {
        return Interactive.print(", ", 80);
    }

    public static <T> Action1<T> print(String separator, int maxLineLength) {
        return new PrintAction1(separator, maxLineLength);
    }

    public static <T> Action1<T> println() {
        return new Action1<T>(){

            public void call(T value) {
                System.out.println(value);
            }
        };
    }

    public static <T> Action1<T> println(final String prefix) {
        return new Action1<T>(){

            public void call(T value) {
                System.out.print(prefix);
                System.out.println(value);
            }
        };
    }

    public static <T, U> Iterable<U> prune(Iterable<? extends T> source, Func1<? super Iterable<? extends T>, ? extends Iterable<U>> func) {
        return (Iterable)func.call(Interactive.share(source));
    }

    public static <T, U> Iterable<U> publish(Iterable<? extends T> source, Func1<? super Iterable<? super T>, ? extends Iterable<? extends U>> func, U initial) {
        return Interactive.startWith((Iterable)func.call(Interactive.memoizeAll(source)), initial);
    }

    public static <T, U> Iterable<U> publish(Iterable<? extends T> source, Func1<? super Iterable<T>, ? extends Iterable<U>> func) {
        return (Iterable)func.call(Interactive.memoizeAll(source));
    }

    public static Iterable<Integer> range(int start, int count) {
        return new RangeIterable(start, count);
    }

    public static Iterable<Long> range(long start, long count) {
        return new LongRangeIterable(start, count);
    }

    public static <T> Iterable<T> relayWhile(Iterable<? extends T> source, final Func0<Boolean> gate) {
        return Interactive.filterIndexed(source, new Func0<Func2<Integer, T, Boolean>>(){

            public Func2<Integer, T, Boolean> call() {
                return new Func2<Integer, T, Boolean>(){
                    boolean active = true;

                    public Boolean call(Integer param1, T param2) {
                        this.active &= ((Boolean)gate.call()).booleanValue();
                        return this.active;
                    }
                };
            }
        });
    }

    public static <T> Iterable<T> repeat(T value) {
        return new RepeatIterable<T>(value);
    }

    public static <T> Iterable<T> repeat(T value, int count) {
        return new RepeatCountIterable<T>(count, value);
    }

    public static <T, U> Iterable<U> replay(Iterable<? extends T> source, Func1<? super Iterable<T>, ? extends Iterable<U>> func) {
        return (Iterable)func.call(Interactive.memoize(source, 0));
    }

    public static <T, U> Iterable<U> replay(Iterable<? extends T> source, Func1<? super Iterable<T>, ? extends Iterable<U>> func, int bufferSize) {
        return (Iterable)func.call(Interactive.memoize(source, bufferSize));
    }

    public static <T> Iterable<T> onErrorResumeNext(Iterable<? extends Iterable<? extends T>> sources) {
        return new OnErrorResumeNext(sources);
    }

    public static <T> Iterable<T> onErrorResumeNext(Iterable<? extends T> first, Iterable<? extends T> second) {
        ArrayList<Iterable<? extends T>> list = new ArrayList<Iterable<? extends T>>(2);
        list.add(first);
        list.add(second);
        return Interactive.onErrorResumeNext(list);
    }

    public static <T> Iterable<T> retry(Iterable<? extends T> source, int count) {
        return new RetryIterable<T>(count, source);
    }

    public static void run(Iterable<?> source) {
        Interactive.forEach(source, Actions.empty());
    }

    public static <T, U> Iterable<U> scan(Iterable<? extends T> source, Func2<? super U, ? super T, ? extends U> aggregator) {
        return Interactive.scan(source, null, aggregator);
    }

    public static <T, U> Iterable<U> scan(Iterable<? extends T> source, U seed, Func2<? super U, ? super T, ? extends U> aggregator) {
        return new ScanIterable<U, T>(source, aggregator, seed);
    }

    static Scheduler scheduler() {
        return Schedulers.computation();
    }

    public static <T, U> Iterable<U> flatMap(Iterable<? extends T> source, Func1<? super T, ? extends Iterable<? extends U>> selector) {
        return new FlatMapIterable(selector, source);
    }

    public static <T> Iterable<T> share(Iterable<T> source) {
        return new ShareIterable<T>(source);
    }

    public static <T, U> Iterable<U> share(Iterable<T> source, Func1<? super Iterable<T>, ? extends Iterable<U>> selector) {
        return new ShareSelectorIterable(source, selector);
    }

    public static <T> Iterable<T> just(T value) {
        return new JustIterable<T>(value);
    }

    public static int size(Iterable<?> iterable) {
        return Interactive.first(Interactive.count(iterable));
    }

    public static <T> Iterable<T> skipLast(Iterable<? extends T> source, int num) {
        return new SkipLastIterable<T>(source, num);
    }

    static <T> Notification<T> some(T value) {
        return Notification.createOnNext(value);
    }

    public static <T> Iterable<T> startWith(Iterable<? extends T> source, T ... value) {
        return Interactive.concat(Arrays.asList(value), source);
    }

    public static <T> Iterable<Pair<T, T>> subsequent(Iterable<? extends T> source) {
        return new SubsequentIterable<T>(source);
    }

    public static <T> Iterable<Iterable<T>> subsequent(Iterable<? extends T> source, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be > 0");
        }
        if (count == 1) {
            return Interactive.map(source, new Func1<T, Iterable<T>>(){

                public Iterable<T> call(T param1) {
                    return Interactive.just(param1);
                }
            });
        }
        return new SubsequentCountIterable<T>(source, count);
    }

    /*
     * Exception decompiling
     */
    public static Iterable<BigDecimal> sumBigDecimal(Iterable<BigDecimal> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<BigInteger> sumBigInteger(Iterable<BigInteger> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Double> sumDouble(Iterable<Double> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Float> sumFloat(Iterable<Float> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Integer> sumInt(Iterable<Integer> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Double> sumIntAsDouble(Iterable<Integer> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Long> sumLong(Iterable<Long> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Double> sumLongAsDouble(Iterable<Long> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T, U> Iterable<U> switchCase(Func0<T> selector, Map<T, Iterable<U>> options) {
        return new SwitchCaseIterable<U, T>(selector, options);
    }

    public static <T> Iterable<T> take(Iterable<? extends T> source, int num) {
        return new TakeIterable<T>(num, source);
    }

    public static <T> Iterable<T> takeLast(Iterable<? extends T> source, int num) {
        return new TakeLastIterable<T>(source, num);
    }

    public static <T> Iterable<T> error(Throwable t) {
        return new ErrorIterable(t);
    }

    public static <T> Enumerable<T> toEnumerable(final Iterable<? extends T> e) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                return Interactive.toEnumerator(e.iterator());
            }
        };
    }

    public static <T> Enumerator<T> toEnumerator(Iterator<? extends T> it) {
        return new IteratorToEnumerator<T>(it);
    }

    public static <T> Iterable<T> toIterable(final Enumerable<? extends T> e) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Interactive.toIterator(e.enumerator());
            }
        };
    }

    public static <T> Iterable<T> toIterable(final T ... ts) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int index;
                    final int size;
                    {
                        this.size = ts.length;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < this.size;
                    }

                    @Override
                    public T next() {
                        if (this.hasNext()) {
                            return ts[this.index++];
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> toIterablePart(int from, int to, T ... ts) {
        return new PartialIterable<T>(from, ts, to);
    }

    public static <T> Iterator<T> toIterator(Enumerator<? extends T> en) {
        return new EnumerationToIterator<T>(en);
    }

    public static void unsubscribe(Iterator<?> iter) {
        if (iter instanceof Subscription) {
            ((Subscription)iter).unsubscribe();
        }
    }

    public static <T, U extends Closeable> Iterable<T> using(Func0<U> resource, Func1<? super U, Iterable<? extends T>> usage) {
        return new UsingIterable<T, U>(resource, usage);
    }

    static <T> T value(Notification<T> notif) {
        if (notif.isOnNext()) {
            return (T)notif.getValue();
        }
        if (notif.isOnError()) {
            Exceptions.propagate((Throwable)notif.getThrowable());
        }
        throw new NoSuchElementException();
    }

    public static <T> Iterable<T> filterIndexed(Iterable<? extends T> source, Func0<? extends Func2<? super Integer, ? super T, Boolean>> predicateFactory) {
        return new FilterIndexedIterable<T>(source, predicateFactory);
    }

    public static <T> Iterable<T> filter(Iterable<? extends T> source, final Func1<? super T, Boolean> predicate) {
        return Interactive.filterIndexed(source, IxHelperFunctions.constant0(new Func2<Integer, T, Boolean>(){

            public Boolean call(Integer param1, T param2) {
                return (Boolean)predicate.call(param2);
            }
        }));
    }

    public static <T> Iterable<T> filterIndexed(Iterable<? extends T> source, Func2<? super Integer, ? super T, Boolean> predicate) {
        return Interactive.filterIndexed(source, IxHelperFunctions.constant0(predicate));
    }

    public static <T, U, V> Iterable<V> zip(Iterable<? extends T> left, Iterable<? extends U> right, Func2<? super T, ? super U, ? extends V> combiner) {
        return new ZipIterable<V, T, U>(right, combiner, left);
    }

    private Interactive() {
    }
}

